/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.lambda.DelayedThunk;

public class BoundedSymbol {
    private final Object _id;
    private final boolean _generated;
    private final String _name;
    private final DelayedThunk<Type> _upperBound;
    private final DelayedThunk<Type> _lowerBound;

    public BoundedSymbol(Object id) {
        this._id = id;
        this._generated = true;
        this._name = null;
        this._upperBound = new DelayedThunk();
        this._lowerBound = new DelayedThunk();
    }

    public BoundedSymbol(Object id, String name) {
        this._id = id;
        this._generated = false;
        this._name = name;
        this._upperBound = new DelayedThunk();
        this._lowerBound = new DelayedThunk();
    }

    public BoundedSymbol(Object id, Type upperBound, Type lowerBound) {
        this(id);
        this._upperBound.set(upperBound);
        this._lowerBound.set(lowerBound);
    }

    public BoundedSymbol(Object id, String name, Type upperBound, Type lowerBound) {
        this(id, name);
        this._upperBound.set(upperBound);
        this._lowerBound.set(lowerBound);
    }

    public boolean generated() {
        return this._generated;
    }

    public String name() {
        if (this._generated) {
            throw new IllegalArgumentException("Symbol is unnamed");
        }
        return this._name;
    }

    public void initializeUpperBound(Type t) {
        this._upperBound.set(t);
    }

    public void initializeLowerBound(Type t) {
        this._lowerBound.set(t);
    }

    public Type upperBound() {
        return this._upperBound.value();
    }

    public Type lowerBound() {
        return this._lowerBound.value();
    }

    public String toString() {
        return "symbol " + this._id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundedSymbol)) {
            return false;
        }
        return ((BoundedSymbol)o)._id.equals(this._id);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this._id.hashCode();
    }
}

