/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.Library;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.plt.collect.IndexedInjectiveRelation;
import edu.rice.cs.plt.collect.InjectiveRelation;
import edu.rice.cs.plt.collect.TotalMap;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.CompilationUnit;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLibrary
implements Library {
    private final TotalMap<String, InjectiveRelation<String, DJClass>> _packages = new TotalMap<String, InjectiveRelation<String, DJClass>>(new Lambda<String, InjectiveRelation<String, DJClass>>(){

        @Override
        public InjectiveRelation<String, DJClass> value(String pkg) {
            return new IndexedInjectiveRelation<String, DJClass>();
        }
    }, true);
    private final TreeClassLoader _loader;

    public TreeLibrary(Iterable<CompilationUnit> cus, ClassLoader parentLoader, Options opt) {
        this._loader = new TreeClassLoader(parentLoader, opt);
        for (CompilationUnit cu : cus) {
            PackageDeclaration pd = cu.getPackage();
            String pkg = pd == null ? "" : pd.getName();
            InjectiveRelation<String, DJClass> classes = this._packages.get(pkg);
            for (Node ast : cu.getDeclarations()) {
                if (!(ast instanceof TypeDeclaration)) continue;
                String declaredName = ((TypeDeclaration)ast).getName();
                String fullName = pkg.equals("") ? declaredName : pkg + "." + declaredName;
                TreeClass c = new TreeClass(fullName, null, null, ast, this._loader, opt);
                NodeProperties.setDJClass(ast, c);
                classes.add(declaredName, c);
            }
        }
    }

    @Override
    public Iterable<DJClass> declaredClasses(String fullName) {
        String className;
        String packageName;
        int dot = fullName.lastIndexOf(46);
        if (dot == -1) {
            packageName = "";
            className = fullName;
        } else {
            packageName = fullName.substring(0, dot);
            className = fullName.substring(dot + 1);
        }
        if (this._packages.containsOverride(packageName)) {
            return this._packages.get(packageName).matchFirst(className);
        }
        return IterUtil.empty();
    }

    @Override
    public ClassLoader classLoader() {
        return this._loader;
    }
}

