/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol.type;

import edu.rice.cs.dynamicjava.symbol.type.TabPrintWriter;
import edu.rice.cs.dynamicjava.symbol.type.TreeWalker;
import java.io.Writer;

public class ToStringWalker
extends TreeWalker {
    private final TabPrintWriter _out;

    public ToStringWalker(Writer writer, int tabSize) {
        this._out = new TabPrintWriter(writer, tabSize);
    }

    public boolean visitNode(Object node, String type, int fields) {
        this._out.print(type);
        this._out.print(':');
        this._out.indent();
        return true;
    }

    public boolean visitNodeField(String name, Object value) {
        this._out.startLine(name);
        this._out.print(" = ");
        return true;
    }

    public void endNode(Object node, String type, int fields) {
        this._out.unindent();
    }

    public boolean visitIterated(Object iterable) {
        this._out.print("{");
        this._out.indent();
        return true;
    }

    public boolean visitIteratedElement(int index, Object element) {
        this._out.startLine("* ");
        return true;
    }

    public void endIterated(Object iterable, int size) {
        this._out.unindent();
        if (size > 0) {
            this._out.startLine("}");
        } else {
            this._out.print("}");
        }
    }

    public boolean visitNonEmptyOption(Object option) {
        this._out.print('(');
        return true;
    }

    public void endNonEmptyOption(Object option) {
        this._out.print(')');
    }

    public void visitEmptyOption(Object option) {
        this._out.print("()");
    }

    public boolean visitTuple(Object tuple, int arity) {
        this._out.print(')');
        return true;
    }

    public boolean visitTupleElement(int index, Object element) {
        if (index > 0) {
            this._out.print(", ");
        }
        return true;
    }

    public void endTuple(Object tuple, int arity) {
        this._out.print(')');
    }

    public void visitString(String s) {
        this._out.print(s);
    }

    public void visitUnknownObject(Object o) {
        this._out.print(o);
    }

    public void visitNull() {
        this._out.print("null");
    }

    public void visitBoolean(boolean b) {
        this._out.print(b);
    }

    public void visitChar(char c) {
        this._out.print(c);
    }

    public void visitByte(byte b) {
        this._out.print(b);
    }

    public void visitShort(short s) {
        this._out.print(s);
    }

    public void visitInt(int i) {
        this._out.print(i);
    }

    public void visitLong(long l) {
        this._out.print(l);
    }

    public void visitFloat(float f) {
        this._out.print(f);
    }

    public void visitDouble(double d) {
        this._out.print(d);
    }

    public void writeString(String s) {
        this._out.print(s);
    }

    public void writeUnknownObject(Object o) {
        this._out.print(o);
    }
}

