/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyBodyFullJavaVisitor;
import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.FullJavaVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.javalanglevels.util.Utilities;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBodyFullJavaVisitor
extends FullJavaVisitor {
    private SymbolData _enclosing;

    public ClassBodyFullJavaVisitor(SymbolData sd, String className, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps) {
        super(file, packageName, className, importedFiles, importedPackages, classesInThisFile, continuations, fixUps);
        this._enclosing = sd;
        assert (sd != null && className != null && !className.equals(""));
    }

    public ClassBodyFullJavaVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps, HashMap<String, SymbolData> genericTypes) {
        super(file, packageName, sd.getName(), importedFiles, importedPackages, classesInThisFile, continuations, fixUps, genericTypes);
        this._enclosing = sd;
        assert (sd != null);
    }

    @Override
    public Void forStatementDoFirst(Statement that) {
        return null;
    }

    @Override
    public Void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        if (!this._enclosing.isInterface() && !this._enclosing.hasModifier("abstract")) {
            ClassBodyFullJavaVisitor._addError("Abstract methods can only be declared in abstract classes", that);
        }
        return super.forAbstractMethodDefDoFirst(that);
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        ClassBodyFullJavaVisitor._addError("This open brace must mark the beginning of a method or class body", that);
        return null;
    }

    @Override
    public Void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._enclosing);
        if (!this._enclosing.addVars(vds)) {
            ClassBodyFullJavaVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses or interfaces has a field by that name", that);
        }
        return null;
    }

    @Override
    public Void forConcreteMethodDef(ConcreteMethodDef that) {
        HashMap copy;
        this.forConcreteMethodDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        assert (this._enclosing != null);
        TypeParameter[] tps = that.getTypeParams();
        HashMap oldGenericTypes = this._genericTypes;
        this._genericTypes = copy = (HashMap)this._genericTypes.clone();
        if (tps != null && tps.length > 0) {
            for (TypeParameter tp : tps) {
                String typeName = tp.getVariable().getName();
                String boundName = tp.getBound().getName();
                SymbolData boundSD = this._identifyType(boundName, that.getSourceInfo(), this._enclosingClassName);
                if (boundSD == null) {
                    boundSD = (SymbolData)this.symbolTable.get("java.lang.Object");
                }
                this._genericTypes.put(typeName, boundSD);
            }
        }
        MethodData md = this.createMethodData(that, this._enclosing);
        String className = ClassBodyFullJavaVisitor.getUnqualifiedClassName(this._enclosing.getName());
        if (className.equals(md.getName())) {
            ClassBodyFullJavaVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._enclosing.addMethod(md);
        }
        that.getBody().visit(new BodyBodyFullJavaVisitor(md, this._file, this._package, this._enclosingClassName, this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps, new HashSet<String>(), this._genericTypes));
        this._genericTypes = oldGenericTypes;
        return null;
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef that) {
        HashMap copy;
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        assert (this._enclosing != null);
        TypeParameter[] tps = that.getTypeParams();
        HashMap oldGenericTypes = this._genericTypes;
        this._genericTypes = copy = (HashMap)this._genericTypes.clone();
        if (tps != null) {
            for (TypeParameter tp : tps) {
                String typeName = tp.getVariable().getName();
                String boundName = tp.getBound().getName();
                SymbolData boundSD = this._identifyType(boundName, that.getSourceInfo(), this._enclosingClassName);
                if (boundSD == null) {
                    boundSD = (SymbolData)this.symbolTable.get("java.lang.Object");
                }
                this._genericTypes.put(typeName, boundSD);
            }
        }
        MethodData md = this.createMethodData(that, this._enclosing);
        String className = ClassBodyFullJavaVisitor.getUnqualifiedClassName(this._enclosing.getName());
        if (className.equals(md.getName())) {
            ClassBodyFullJavaVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._enclosing.addMethod(md);
        }
        this._genericTypes = oldGenericTypes;
        return null;
    }

    @Override
    public Void forInnerInterfaceDef(InnerInterfaceDef that) {
        String relName = that.getName().getText();
        this.handleInnerInterfaceDef(that, this._enclosing, relName, this.getQualifiedClassName(this._enclosing.getName()) + '.' + relName);
        return null;
    }

    @Override
    public Void forInnerClassDef(InnerClassDef that) {
        String relName = that.getName().getText();
        this.handleInnerClassDef(that, this._enclosing, relName, this.getQualifiedClassName(this._enclosing.getName()) + '.' + relName);
        return null;
    }

    @Override
    public Void forConstructorDef(ConstructorDef that) {
        this.forConstructorDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        that.getMav().visit(this);
        String name = ClassBodyFullJavaVisitor.getUnqualifiedClassName(that.getName().getText());
        if (that.getName().getText().indexOf(46) != -1 && !that.getName().getText().equals(this._enclosing.getName()) || !name.equals(ClassBodyFullJavaVisitor.getUnqualifiedClassName(this._enclosing.getName()))) {
            ClassBodyFullJavaVisitor._addAndIgnoreError("The constructor return type and class name must match", that);
        }
        String[] throwStrings = ClassBodyFullJavaVisitor.referenceType2String(that.getThrows());
        SymbolData returnType = this._enclosing;
        MethodData md = MethodData.make(name, that.getMav(), new TypeParameter[0], returnType, new VariableData[0], throwStrings, this._enclosing, that);
        ClassBodyFullJavaVisitor._checkError();
        VariableData[] vds = this.formalParameters2VariableData(that.getParameters(), this._enclosing);
        if (!ClassBodyFullJavaVisitor._checkError()) {
            md.setParams(vds);
            if (!md.addVars(vds)) {
                ClassBodyFullJavaVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
            }
        }
        this._enclosing.addMethod(md);
        that.getStatements().visit(new BodyBodyFullJavaVisitor(md, this._file, this._package, this._enclosingClassName, this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps, new HashSet<String>()));
        this._enclosing.incrementConstructorCount();
        return null;
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String[] modifiers = that.getModifiers();
        if (Utilities.isAbstract(modifiers) && Utilities.isStatic(modifiers)) {
            this._badModifiers("static", "abstract", that);
        }
        return super.forModifiersAndVisibilityDoFirst(that);
    }

    static /* synthetic */ SymbolData access$000(ClassBodyFullJavaVisitor x0) {
        return x0._enclosing;
    }

    static /* synthetic */ SymbolData access$002(ClassBodyFullJavaVisitor x0, SymbolData x1) {
        x0._enclosing = x1;
        return x0._enclosing;
    }
}

