/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.FullJavaVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SuperReference;
import edu.rice.cs.javalanglevels.tree.ThisReference;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyFullJavaVisitor
extends FullJavaVisitor {
    private SymbolData _enclosing;

    public InterfaceBodyFullJavaVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps) {
        super(file, packageName, sd.getName(), importedFiles, importedPackages, classesInThisFile, continuations, fixUps);
        this._enclosing = sd;
    }

    public InterfaceBodyFullJavaVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps, HashMap<String, SymbolData> genericTypes) {
        super(file, packageName, sd.getName(), importedFiles, importedPackages, classesInThisFile, continuations, fixUps, genericTypes);
        this._enclosing = sd;
    }

    @Override
    public Void forStatementDoFirst(Statement that) {
        return null;
    }

    @Override
    public Void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        InterfaceBodyFullJavaVisitor._addError("You cannot have concrete methods definitions in interfaces", that);
        return null;
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        InterfaceBodyFullJavaVisitor._addError("This open brace must mark the beginning of an interface body", that);
        return null;
    }

    @Override
    public Void forVariableDeclarationOnly(VariableDeclaration that) {
        return null;
    }

    @Override
    public Void forThisReferenceDoFirst(ThisReference that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("The field 'this' does not exist in interfaces.  Only classes have a 'this' field.", that);
        return null;
    }

    @Override
    public Void forSuperReferenceDoFirst(SuperReference that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("The field 'super' does not exist in interfaces.  Only classes have a 'super' field", that);
        return null;
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef that) {
        MethodData md;
        HashMap copy;
        this.forAbstractMethodDefDoFirst(that);
        if (InterfaceBodyFullJavaVisitor._checkError()) {
            return null;
        }
        assert (this._enclosing != null);
        TypeParameter[] tps = that.getTypeParams();
        HashMap oldGenericTypes = this._genericTypes;
        this._genericTypes = copy = (HashMap)this._genericTypes.clone();
        if (tps != null) {
            for (TypeParameter tp : tps) {
                String typeName = tp.getVariable().getName();
                String boundName = tp.getBound().getName();
                SymbolData boundSD = this._identifyType(boundName, that.getSourceInfo(), this._enclosingClassName);
                if (boundSD == null) {
                    boundSD = (SymbolData)this.symbolTable.get("java.lang.Object");
                }
                this._genericTypes.put(typeName, boundSD);
            }
        }
        if ((md = this.createMethodData(that, this._enclosing)).hasModifier("private")) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Interface methods cannot be private.  They must be public.", that.getMav());
        }
        if (md.hasModifier("protected")) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Interface methods cannot be protected.  They must be public.", that.getMav());
        }
        md.addModifier("public");
        md.addModifier("abstract");
        String className = InterfaceBodyFullJavaVisitor.getUnqualifiedClassName(this._enclosing.getName());
        if (className.equals(md.getName())) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors cannot appear in interfaces.", that);
        } else {
            this._enclosing.addMethod(md);
        }
        this._genericTypes = oldGenericTypes;
        return null;
    }

    @Override
    public Void forInnerInterfaceDef(InnerInterfaceDef that) {
        String relName = that.getName().getText();
        this.handleInnerInterfaceDef(that, this._enclosing, relName, this.getQualifiedClassName(this._enclosing.getName()) + '.' + relName);
        return null;
    }

    @Override
    public Void forInnerClassDef(InnerClassDef that) {
        String relName = that.getName().getText();
        this.handleInnerClassDef(that, this._enclosing, relName, this.getQualifiedClassName(this._enclosing.getName()) + '.' + relName);
        return null;
    }

    @Override
    public Void forConstructorDefDoFirst(ConstructorDef that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("Constructor definitions cannot appear in interfaces", that);
        return null;
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            vds[i].setFinalAndStatic();
        }
        return vds;
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    static /* synthetic */ SymbolData access$000(InterfaceBodyFullJavaVisitor x0) {
        return x0._enclosing;
    }

    static /* synthetic */ SymbolData access$002(InterfaceBodyFullJavaVisitor x0, SymbolData x1) {
        x0._enclosing = x1;
        return x0._enclosing;
    }
}

