/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SuperReference;
import edu.rice.cs.javalanglevels.tree.ThisReference;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyIntermediateVisitor
extends IntermediateVisitor {
    private SymbolData _enclosing;

    public InterfaceBodyIntermediateVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps) {
        super(file, packageName, sd.getName(), importedFiles, importedPackages, classesInThisFile, continuations, fixUps);
        this._enclosing = sd;
    }

    @Override
    public Void forStatementDoFirst(Statement that) {
        InterfaceBodyIntermediateVisitor._addError("Statements cannot appear outside of method bodies", that);
        return null;
    }

    @Override
    public Void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        InterfaceBodyIntermediateVisitor._addError("You cannot have concrete methods definitions in interfaces", that);
        return null;
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        InterfaceBodyIntermediateVisitor._addError("This open brace must mark the beginning of an interface body", that);
        return null;
    }

    @Override
    public Void forVariableDeclarationDoFirst(VariableDeclaration that) {
        InterfaceBodyIntermediateVisitor._addError("You cannot have fields in interfaces at the Intermediate level", that);
        return null;
    }

    @Override
    public Void forSuperReferenceDoFirst(SuperReference that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("The field 'super' does not exist in interfaces.  Only classes have a 'super' field", that);
        return null;
    }

    @Override
    public Void forThisReferenceDoFirst(ThisReference that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("The field 'this' does not exist in interfaces.  Only classes have a 'this' field.", that);
        return null;
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (InterfaceBodyIntermediateVisitor._checkError()) {
            return null;
        }
        MethodData md = this.createMethodData(that, this._enclosing);
        if (md.hasModifier("private")) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Interface methods cannot be private.  They must be public.", that.getMav());
        }
        if (md.hasModifier("protected")) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Interface methods cannot be protected.  They must be public.", that.getMav());
        }
        md.addModifier("public");
        md.addModifier("abstract");
        String className = InterfaceBodyIntermediateVisitor.getUnqualifiedClassName(this._enclosing.getName());
        if (className.equals(md.getName())) {
            InterfaceBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors cannot appear in interfaces.", that);
        } else {
            this._enclosing.addMethod(md);
        }
        return null;
    }

    @Override
    public Void forConstructorDefDoFirst(ConstructorDef that) {
        InterfaceBodyIntermediateVisitor._addAndIgnoreError("Constructor definitions cannot appear in interfaces", that);
        return null;
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            vds[i].setFinalAndStatic();
        }
        return vds;
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._enclosing);
        return null;
    }

    static /* synthetic */ SymbolData access$000(InterfaceBodyIntermediateVisitor x0) {
        return x0._enclosing;
    }
}

