/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyFullJavaVisitor;
import edu.rice.cs.javalanglevels.ClassBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InterfaceBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.BitwiseAndExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseBinaryExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseNotExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseOrExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseXorExpression;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.ShiftAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.ShiftBinaryExpression;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.SynchronizedStatement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateVisitor
extends LanguageLevelVisitor {
    public IntermediateVisitor(File file, String packageName, String enclosingClassName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps) {
        super(file, packageName, enclosingClassName, importedFiles, importedPackages, classesInThisFile, continuations, fixUps);
    }

    public IntermediateVisitor(File file) {
        this(file, new LinkedList<Pair<String, JExpressionIF>>(), new Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>>(), new LinkedList<Command>(), new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>());
    }

    public IntermediateVisitor(File file, LinkedList<Pair<String, JExpressionIF>> errors, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles) {
        this(file, new LinkedList<String>(), errors, continuations, fixUps, visitedFiles);
    }

    public IntermediateVisitor(File file, LinkedList<String> importedPackages, LinkedList<Pair<String, JExpressionIF>> errors, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles) {
        super(file, "", null, new LinkedList<String>(), importedPackages, new HashSet<String>(), continuations, fixUps);
        IntermediateVisitor.errors = errors;
        IntermediateVisitor.visitedFiles = visitedFiles;
    }

    @Override
    public LanguageLevelVisitor newClassBodyVisitor(SymbolData anonSD, String anonName) {
        return new ClassBodyFullJavaVisitor(anonSD, anonName, this._file, this._package, (LinkedList<String>)this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps);
    }

    protected void handleInnerClassDef(InnerClassDef that, Data enclosing, String relName, String name) {
        assert (enclosing instanceof SymbolData || enclosing instanceof MethodData);
        this.forInnerClassDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        that.getSuperclass().visit(this);
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.defineInnerSymbolData(that, relName, name, enclosing);
        if (sd != null) {
            that.getBody().visit(new ClassBodyIntermediateVisitor(sd, sd.getName(), this._file, this._package, (LinkedList<String>)this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps));
            IntermediateVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forInnerClassDefOnly(that);
    }

    protected void handleInnerInterfaceDef(InnerInterfaceDef that, Data enclosing, String relName, String name) {
        assert (enclosing instanceof SymbolData || enclosing instanceof MethodData);
        this.forInnerInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.defineInnerSymbolData(that, relName, name, enclosing);
        if (sd != null) {
            that.getBody().visit(new InterfaceBodyIntermediateVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, (HashSet<String>)this._classesInThisFile, (Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>>)continuations, (LinkedList<Command>)fixUps));
        }
        this.forInnerInterfaceDefOnly(that);
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String temp;
        String[] modifiersAndVisibility = that.getModifiers();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (int i = 0; i < modifiersAndVisibility.length; ++i) {
            temp = modifiersAndVisibility[i];
            if (temp.equals("final") || temp.equals("abstract") || temp.equals("public") || temp.equals("private") || temp.equals("protected") || temp.equals("static")) continue;
            sb.append(" \"" + temp + "\"");
            ++count;
        }
        temp = "The keyword";
        if (sb.length() > 0) {
            if (count > 1) {
                temp = temp + "s";
            }
            IntermediateVisitor._addAndIgnoreError(temp + sb.toString() + " cannot be used at the Intermediate level", that);
            return null;
        }
        return super.forModifiersAndVisibilityDoFirst(that);
    }

    @Override
    public Void forSynchronizedStatementDoFirst(SynchronizedStatement that) {
        IntermediateVisitor._addError("Synchronized statements cannot be used at the Intermediate level", that);
        return null;
    }

    @Override
    public Void forTypeParameterDoFirst(TypeParameter that) {
        IntermediateVisitor._addError("Type Parameters cannot be used at the Intermediate level", that);
        return null;
    }

    private boolean _isClassInCurrentFile(String className) {
        for (String s : this._classesInThisFile) {
            if (!s.equals(className) && !s.endsWith('.' + className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void forClassDef(ClassDef that) {
        this.forClassDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        String superName = that.getSuperclass().getName();
        SymbolData sd = this.defineSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        that.getSuperclass().visit(this);
        if (sd != null) {
            this.identifyInnerClasses(that);
        }
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            if (superName.equals("TestCase") || superName.equals("junit.framework.TestCase")) {
                sd.addModifier("public");
                if (!this._importedPackages.contains("junit.framework") && !this._importedFiles.contains("junit.framework.TestCase")) {
                    sd.setHasAutoGeneratedJunitImport(true);
                    this._importedFiles.addLast("junit.framework.TestCase");
                    this.createImportedSymbolContinuation("junit.framework.TestCase", that.getSourceInfo());
                }
                assert (this.getQualifiedSymbolData("junit.framework.TestCase", that.getSourceInfo()) != null);
            }
            that.getBody().visit(new ClassBodyIntermediateVisitor(sd, className, this._file, this._package, (LinkedList<String>)this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps));
            IntermediateVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forClassDefOnly(that);
        this._classesInThisFile.remove(className);
        return null;
    }

    @Override
    public Void forInterfaceDef(InterfaceDef that) {
        this.forInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.defineSymbolData(that, className);
        if (sd != null) {
            sd.setInterface(true);
            this.identifyInnerClasses(that);
            that.getBody().visit(new InterfaceBodyIntermediateVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, (HashSet<String>)this._classesInThisFile, (Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>>)continuations, (LinkedList<Command>)fixUps));
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        this.forInterfaceDefOnly(that);
        this._classesInThisFile.remove(className);
        return null;
    }

    @Override
    public Void forShiftAssignmentExpressionDoFirst(ShiftAssignmentExpression that) {
        IntermediateVisitor._addAndIgnoreError("Shift assignment operators cannot be used at any language level", that);
        return null;
    }

    @Override
    public Void forBitwiseAssignmentExpressionDoFirst(BitwiseAssignmentExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise operators cannot be used at any language level", that);
        return null;
    }

    @Override
    public Void forBitwiseBinaryExpressionDoFirst(BitwiseBinaryExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise binary expressions cannot be used at any language level", that);
        return null;
    }

    @Override
    public Void forBitwiseOrExpressionDoFirst(BitwiseOrExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise or expressions cannot be used in the functional language level.  Perhaps you meant to compare two values using regular or (||)", that);
        return null;
    }

    @Override
    public Void forBitwiseXorExpressionDoFirst(BitwiseXorExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise xor expressions cannot be used at any language level", that);
        return null;
    }

    @Override
    public Void forBitwiseAndExpressionDoFirst(BitwiseAndExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise and expressions cannot be used at any language level.  Perhaps you meant to compare two values using regular and (&&)", that);
        return null;
    }

    @Override
    public Void forBitwiseNotExpressionDoFirst(BitwiseNotExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise not expressions cannot be used at any language level.  Perhaps you meant to negate this value using regular not (!)", that);
        return null;
    }

    @Override
    public Void forShiftBinaryExpressionDoFirst(ShiftBinaryExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bit shifting operators cannot be used at any language level", that);
        return null;
    }

    @Override
    public Void forBitwiseNotExpressionDoFirst(ShiftBinaryExpression that) {
        IntermediateVisitor._addAndIgnoreError("Bitwise operators cannot be used at any language level", that);
        return null;
    }

    protected VariableData[] llVariableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        return super._variableDeclaration2VariableData(vd, enclosingData);
    }

    public void simpleAnonymousClassInstantiationHelper(SimpleAnonymousClassInstantiation that, SymbolData enclosing) {
        this.forSimpleAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        String superName = that.getType().getName();
        this.anonymousClassInstantiationHelper(that, enclosing, superName);
        this.forSimpleAnonymousClassInstantiationOnly(that);
    }

    public void complexAnonymousClassInstantiationHelper(ComplexAnonymousClassInstantiation that, SymbolData enclosing) {
        this.forComplexAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getEnclosing().visit(this);
        String superName = that.getType().getName();
        this.anonymousClassInstantiationHelper(that, enclosing, superName);
        this.forComplexAnonymousClassInstantiationOnly(that);
    }

    static /* synthetic */ boolean access$000(IntermediateVisitor x0, String x1) {
        return x0._isClassInCurrentFile(x1);
    }
}

