/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ArrayData;
import edu.rice.cs.javalanglevels.ClassBodyFullJavaVisitor;
import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.FullJavaVisitor;
import edu.rice.cs.javalanglevels.JExpressionIFPrunableDepthFirstVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.BitwiseAndExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseBinaryExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseNotExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseOrExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseXorExpression;
import edu.rice.cs.javalanglevels.tree.BodyItemI;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ClassImportStatement;
import edu.rice.cs.javalanglevels.tree.ComplexNameReference;
import edu.rice.cs.javalanglevels.tree.CompoundWord;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.EmptyExpression;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.MemberType;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NoOpExpression;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.PackageImportStatement;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.ReferenceType;
import edu.rice.cs.javalanglevels.tree.ShiftAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.ShiftBinaryExpression;
import edu.rice.cs.javalanglevels.tree.SimpleNameReference;
import edu.rice.cs.javalanglevels.tree.SimpleNamedClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StringLiteral;
import edu.rice.cs.javalanglevels.tree.Type;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.javalanglevels.tree.VariableDeclarator;
import edu.rice.cs.javalanglevels.tree.Word;
import edu.rice.cs.javalanglevels.util.Log;
import edu.rice.cs.javalanglevels.util.Utilities;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelVisitor
extends JExpressionIFPrunableDepthFirstVisitor {
    public static final ModifiersAndVisibility PUBLIC_MAV = new ModifiersAndVisibility(SourceInfo.NONE, new String[]{"public"});
    public static final ModifiersAndVisibility PROTECTED_MAV = new ModifiersAndVisibility(SourceInfo.NONE, new String[]{"protected"});
    public static final ModifiersAndVisibility PRIVATE_MAV = new ModifiersAndVisibility(SourceInfo.NONE, new String[]{"private"});
    public static final ModifiersAndVisibility PACKAGE_MAV = new ModifiersAndVisibility(SourceInfo.NONE, new String[0]);
    public static final ModifiersAndVisibility FINAL_MAV = new ModifiersAndVisibility(SourceInfo.NONE, new String[]{"final"});
    protected static LinkedList<Pair<String, JExpressionIF>> errors;
    public final Symboltable symbolTable;
    static Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations;
    static LinkedList<Command> fixUps;
    static LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles;
    static boolean _errorAdded;
    File _file;
    String _package;
    String _enclosingClassName;
    LinkedList<String> _importedFiles;
    LinkedList<String> _importedPackages;
    public HashMap<String, SymbolData> _genericTypes;
    HashSet<String> _classesInThisFile;
    protected static final Log _log;

    public LanguageLevelVisitor(File file, String packageName, String enclosingClassName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps, HashMap<String, SymbolData> genericTypes) {
        this._file = file;
        this._package = packageName;
        this._enclosingClassName = enclosingClassName;
        if (this._enclosingClassName != null && this._enclosingClassName.startsWith("null")) assert (false);
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
        this._classesInThisFile = classesInThisFile;
        LanguageLevelVisitor.continuations = continuations;
        LanguageLevelVisitor.fixUps = fixUps;
        this._genericTypes = genericTypes;
        this.symbolTable = LanguageLevelConverter.symbolTable;
        assert (fixUps != null);
        assert (this._genericTypes != null);
        if (!this._importedPackages.contains("java.lang")) {
            this._importedPackages.addFirst("java.lang");
        }
        LanguageLevelConverter.loadSymbolTable();
    }

    public LanguageLevelVisitor(File file, String packageName, String enclosingClassName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, HashSet<String> classesInThisFile, Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>> continuations, LinkedList<Command> fixUps) {
        this(file, packageName, enclosingClassName, importedFiles, importedPackages, classesInThisFile, continuations, fixUps, new HashMap<String, SymbolData>());
    }

    protected void _resetNonStaticFields() {
        this._file = new File("");
        this._enclosingClassName = null;
        this._package = "";
        this._importedFiles = new LinkedList();
        this._importedPackages = new LinkedList();
    }

    public static String getFieldAccessorName(String name) {
        return name;
    }

    public File getFile() {
        return this._file;
    }

    protected boolean isConstructor(Data d) {
        if (!(d instanceof MethodData)) {
            return false;
        }
        MethodData md = (MethodData)d;
        SymbolData rt = md.getReturnType();
        SymbolData sd = md.getSymbolData();
        return rt != null && sd != null && rt.getName().indexOf(md.getName()) != -1 && rt == sd;
    }

    public LanguageLevelVisitor newClassBodyVisitor(SymbolData anonSD, String anonName) {
        return new ClassBodyFullJavaVisitor(anonSD, anonName, this._file, this._package, this._importedFiles, this._importedPackages, this._classesInThisFile, continuations, fixUps);
    }

    public static String getUnqualifiedClassName(String className) {
        int lastIndexOfDollar;
        int lastIndexOfDot = className.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            className = className.substring(lastIndexOfDot + 1);
        }
        if ((lastIndexOfDollar = className.lastIndexOf(36)) != -1) {
            className = className.substring(lastIndexOfDollar + 1);
        }
        while (className.length() > 0 && Character.isDigit(className.charAt(0))) {
            className = className.substring(1, className.length());
        }
        return className;
    }

    protected static String[] referenceType2String(ReferenceType[] rts) {
        String[] throwStrings = new String[rts.length];
        for (int i = 0; i < throwStrings.length; ++i) {
            throwStrings[i] = rts[i].getName();
        }
        return throwStrings;
    }

    public static boolean isJavaLibraryClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.ietf.") || className.startsWith("org.omg.") || className.startsWith("org.w3c.") || className.startsWith("org.xml.") || className.startsWith("sun.") || className.startsWith("junit.framework.");
    }

    public static boolean isDuplicateVariableData(LinkedList<VariableData> vds, VariableData toInsert) {
        for (int i = 0; i < vds.size(); ++i) {
            VariableData temp = vds.get(i);
            if (!temp.getName().equals(toInsert.getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayData defineArraySymbolData(SymbolData eltSd, LanguageLevelVisitor llv, SourceInfo si) {
        ArrayData arraySd = new ArrayData(eltSd, llv, si);
        this.symbolTable.put(arraySd.getName(), arraySd);
        return arraySd;
    }

    private SymbolData getArraySymbolData(String eltClassName, SourceInfo si, boolean addError, boolean checkImports) {
        return this._getArraySymbolData(eltClassName, si, addError, checkImports);
    }

    private SymbolData _getArraySymbolData(String eltClassName, SourceInfo si, boolean addError, boolean checkImports) {
        SymbolData eltSD = this.getSymbolData(eltClassName, si, addError, checkImports);
        if (eltSD != null) {
            SymbolData sd = (SymbolData)this.symbolTable.get(eltSD.getName() + "[]");
            if (sd != null) {
                return sd;
            }
            return this.defineArraySymbolData(eltSD, this, si);
        }
        return null;
    }

    private SymbolData _getQualifiedArraySymbolData(String eltClassName, SourceInfo si, boolean resolve, boolean fromClassFile) {
        SymbolData eltSD = this.getQualifiedSymbolData(eltClassName, si, resolve, fromClassFile, true);
        if (eltSD != null) {
            SymbolData sd = (SymbolData)this.symbolTable.get(eltSD.getName() + "[]");
            if (sd != null) {
                return sd;
            }
            return this.defineArraySymbolData(eltSD, this, si);
        }
        return null;
    }

    protected SymbolData _getSymbolDataFromFileSystem(String qualifiedClassName, SourceInfo si, boolean resolve, boolean addError) {
        String dirPath;
        String path;
        String programRoot;
        SymbolData sd = (SymbolData)this.symbolTable.get(qualifiedClassName);
        if (!(sd == null || sd.isContinuation() && resolve)) {
            return sd;
        }
        String qualifiedClassNameWithSlashes = qualifiedClassName.replace('.', System.getProperty("file.separator").charAt(0));
        File _fileParent = this._file.getParentFile();
        String string = programRoot = _fileParent == null ? "" : _fileParent.getAbsolutePath();
        assert (programRoot != null);
        if (programRoot.length() > 0) {
            String packageWithSlashes = this._package.replace('.', System.getProperty("file.separator").charAt(0));
            int indexOfPackage = programRoot.lastIndexOf(packageWithSlashes);
            if (indexOfPackage < 0) {
                path = qualifiedClassName;
            } else {
                programRoot = programRoot.substring(0, indexOfPackage);
                path = programRoot + System.getProperty("file.separator") + qualifiedClassNameWithSlashes;
            }
        } else {
            path = qualifiedClassNameWithSlashes;
        }
        String newPackage = "";
        int lastSlashIndex = qualifiedClassNameWithSlashes.lastIndexOf(System.getProperty("file.separator"));
        if (lastSlashIndex != -1) {
            String newPackageWithSlashes = qualifiedClassNameWithSlashes.substring(0, lastSlashIndex);
            dirPath = programRoot + System.getProperty("file.separator") + newPackageWithSlashes;
            newPackage = newPackageWithSlashes.replace(System.getProperty("file.separator").charAt(0), '.');
        } else {
            int lastPathSlashIndex = path.lastIndexOf(System.getProperty("file.separator"));
            dirPath = lastPathSlashIndex != -1 ? path.substring(0, lastPathSlashIndex) : "";
        }
        File classFile = new File(path + ".class");
        File[] sourceFiles = new File(dirPath).listFiles(new FileFilter(){

            public boolean accept(File f) {
                try {
                    f = f.getCanonicalFile();
                    return new File(path + ".dj").getCanonicalFile().equals(f) || new File(path + ".dj0").getCanonicalFile().equals(f) || new File(path + ".dj1").getCanonicalFile().equals(f) || new File(path + ".dj2").getCanonicalFile().equals(f) || new File(path + ".java").getCanonicalFile().equals(f);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
        File sourceFile = null;
        if (sourceFiles != null) {
            long mostRecentTime = 0L;
            for (File f : sourceFiles) {
                long currentLastModified = f.lastModified();
                if (!f.exists() || mostRecentTime >= currentLastModified) continue;
                mostRecentTime = currentLastModified;
                sourceFile = f;
            }
        }
        if (sourceFile != null) {
            if (!resolve) {
                assert (sd == null);
                sd = this.makeContinuation(si, qualifiedClassName);
                return sd;
            }
            long classModTime = classFile.lastModified();
            if (classModTime == 0L) {
                return null;
            }
            if (sourceFile.lastModified() > classModTime) {
                if (addError) {
                    LanguageLevelVisitor._addAndIgnoreError("The file " + sourceFile.getAbsolutePath() + " needs to be recompiled; it's class files either do not exist or are out of date.", new NullLiteral(si));
                }
                return null;
            }
        }
        if (classFile.exists()) {
            _log.log("Reading classFile " + qualifiedClassName);
            sd = LanguageLevelConverter._classFile2SymbolData(qualifiedClassName, programRoot);
            if (sd == null) {
                if (addError) {
                    LanguageLevelVisitor._addAndIgnoreError("File " + classFile + " is not a valid class file.", new NullLiteral(si));
                }
                return null;
            }
            _log.log("Returning symbol constructed by loading class file");
            return sd;
        }
        return SymbolData.NOT_FOUND;
    }

    public SymbolData resolveSymbol(SourceInfo si, SymbolData cont) {
        return this.getQualifiedSymbolData(cont.getName(), si, true);
    }

    public SymbolData getSymbolData(String className, SourceInfo si) {
        return this.getSymbolData(className, si, true, true);
    }

    protected SymbolData getSymbolData(String className, SourceInfo si, boolean addError) {
        return this.getSymbolData(className, si, addError, true);
    }

    protected SymbolData getSymbolData(String className, SourceInfo si, boolean addError, boolean checkImports) {
        return this.getSymbolData(this._file, this._package, this._importedFiles, this._importedPackages, this._enclosingClassName, className, si, addError, checkImports);
    }

    protected SymbolData getSymbolData(File file, String pkg, LinkedList<String> importedFiles, LinkedList<String> importedPackages, String enclosingClassName, String className, SourceInfo si, boolean addError, boolean checkImports) {
        SymbolData sd;
        SymbolData enclosingSD;
        if (className == null) assert (false);
        SymbolData existingSD = this.getQualifiedSymbolData(className, si, false, false, addError);
        if (existingSD != null) {
            return existingSD;
        }
        if (className.endsWith("[]")) {
            String eltClassName = className.substring(0, className.length() - 2);
            return this.getArraySymbolData(eltClassName, si, addError, checkImports);
        }
        String qualClassName = LanguageLevelVisitor.getQualifiedClassName(pkg, className);
        existingSD = this.getQualifiedSymbolData(qualClassName, si);
        if (existingSD != null) {
            return existingSD;
        }
        if (enclosingClassName != null && (enclosingSD = this.getQualifiedSymbolData(enclosingClassName, si)) != null && (sd = enclosingSD.getInnerClassOrInterface(className)) != null) {
            return sd;
        }
        if (className.indexOf(46) == -1) {
            if (checkImports) {
                for (String s : importedFiles) {
                    if (!s.endsWith(className)) continue;
                    SymbolData importSD = (SymbolData)this.symbolTable.get(s);
                    return importSD;
                }
            }
            SymbolData resultSD = null;
            assert (importedPackages.contains("java.lang"));
            for (String prefix : importedPackages) {
                String s = prefix + '.' + className;
                SymbolData sD = this.getQualifiedSymbolData(s, si, false, false, false);
                if (sD == null) continue;
                if (resultSD == null || resultSD.equals(sD)) {
                    resultSD = sD;
                    continue;
                }
                if (!addError) continue;
                LanguageLevelVisitor._addAndIgnoreError("The class name " + qualClassName + " is ambiguous.  It could be " + resultSD.getName() + " or " + sD.getName(), new NullLiteral(si));
                return null;
            }
            if (resultSD != null) {
                return resultSD;
            }
            return null;
        }
        int indexOfNextDot = 0;
        int length = className.length();
        while (indexOfNextDot != length) {
            SymbolData outerClassSD;
            String prefix;
            if ((indexOfNextDot = className.indexOf(46, indexOfNextDot + 1)) == -1) {
                indexOfNextDot = length;
            }
            if ((sd = this.getQualifiedSymbolData(prefix = className.substring(0, indexOfNextDot), si, false, false, false)) == null || sd == SymbolData.AMBIGUOUS_REFERENCE) continue;
            String outerClassName = prefix;
            String innerClassName = "";
            if (indexOfNextDot == length || (sd = (outerClassSD = sd).getInnerClassOrInterface(innerClassName = className.substring(indexOfNextDot + 1))) == null) continue;
            return sd;
        }
        return null;
    }

    protected SymbolData getSymbolData(TypeData lhs, String name, SourceInfo si, boolean addError) {
        boolean checkImports = false;
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof PackageData) {
            String qualClassName = lhs.getName() + '.' + name;
            return this.getQualifiedSymbolData(qualClassName, si, false, false, addError);
        }
        SymbolData result = lhs.getInnerClassOrInterface(name);
        if (result == SymbolData.AMBIGUOUS_REFERENCE) {
            if (addError) {
                LanguageLevelVisitor._addAndIgnoreError("Ambiguous reference to class or interface " + name, new NullLiteral(si));
            }
            return null;
        }
        return result;
    }

    protected SymbolData getQualifiedSymbolData(String qualClassName) {
        return this.getQualifiedSymbolData(qualClassName, SourceInfo.NONE);
    }

    protected SymbolData getQualifiedSymbolData(String qualClassName, SourceInfo si) {
        return this.getQualifiedSymbolData(qualClassName, si, false, false, true);
    }

    protected SymbolData getQualifiedSymbolData(String qualClassName, SourceInfo si, boolean resolve) {
        return this.getQualifiedSymbolData(qualClassName, si, resolve, false, true);
    }

    protected SymbolData getQualifiedSymbolData(String qualClassName, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError) {
        assert (qualClassName != null);
        if (qualClassName.equals("java.lang.Throwable")) {
            // empty if block
        }
        assert (qualClassName != null && !qualClassName.equals(""));
        SymbolData sd = LanguageLevelConverter._getPrimitiveSymbolData(qualClassName);
        if (sd != null) {
            return sd;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(qualClassName);
        if (this._genericTypes.containsKey(name)) {
            return this._genericTypes.get(name);
        }
        SymbolData existingSD = (SymbolData)this.symbolTable.get(qualClassName);
        if (!(existingSD == null || resolve && existingSD.isContinuation())) {
            return existingSD;
        }
        if (qualClassName.endsWith("[]")) {
            return this._getQualifiedArraySymbolData(qualClassName.substring(0, qualClassName.length() - 2), si, resolve, fromClassFile);
        }
        SymbolData genericBinding = this._genericTypes.get(qualClassName);
        if (genericBinding != null) {
            return genericBinding;
        }
        if (LanguageLevelVisitor.isJavaLibraryClass(qualClassName)) {
            _log.log("Calling  _classFile2SymbolData");
            SymbolData cfSD = LanguageLevelConverter._classFile2SymbolData(qualClassName, null);
            if (!qualClassName.startsWith("java.") && !qualClassName.startsWith("sun.")) assert (cfSD == null || this.symbolTable.contains(cfSD));
            return cfSD;
        }
        if (this._classesInThisFile.contains(qualClassName)) {
            return this.makeContinuation(si, qualClassName);
        }
        if (resolve) {
            SymbolData newSd = this._getSymbolDataFromFileSystem(qualClassName, si, true, true);
            if (newSd != null && newSd != SymbolData.NOT_FOUND) {
                _log.log("Returning " + sd + " from file system");
                return newSd;
            }
            LanguageLevelVisitor._addAndIgnoreError("The class " + qualClassName + " was not found.", new NullLiteral(si));
            assert (false);
        }
        return null;
    }

    protected String getQualifiedClassName(String className) {
        return LanguageLevelVisitor.getQualifiedClassName(this._package, className);
    }

    public static String getQualifiedClassName(String pkg, String className) {
        if (!pkg.equals("") && !className.startsWith(pkg)) {
            return pkg + '.' + className;
        }
        return className;
    }

    protected SymbolData addInnerSymbolData(SourceInfo si, String qualifiedTypeName, Data enclosing) {
        SymbolData sd = this.makeContinuation(si, qualifiedTypeName);
        SymbolData enclosingSD = enclosing.getSymbolData();
        enclosing.getSymbolData().addInnerClass(sd);
        sd.setOuterData(enclosingSD);
        return sd;
    }

    protected SymbolData makeContinuation(SourceInfo si, String qualClassName) {
        if (qualClassName.equals("D.E")) assert (false);
        SymbolData sd = new SymbolData(qualClassName);
        this.symbolTable.put(qualClassName, sd);
        continuations.put(qualClassName, new Triple<SourceInfo, LanguageLevelVisitor, SymbolData>(si, this, sd));
        return sd;
    }

    protected SymbolData _lookupTypeFromWithinClass(ReferenceType rt, String qualifiedClassName) {
        String rtName = rt.getName();
        SourceInfo si = rt.getSourceInfo();
        assert (this._importedPackages.contains("java.lang"));
        SymbolData sD = this.getSymbolData(rtName, si, false);
        if (sD == null && qualifiedClassName != null) {
            SymbolData sd = this.getQualifiedSymbolData(qualifiedClassName, SourceInfo.NONE);
            sD = sd.getInnerClassOrInterface(rtName);
            assert (sD == this.getQualifiedSymbolData(qualifiedClassName + '.' + rtName, SourceInfo.NONE));
        } else if (qualifiedClassName != null) {
            String qualifyingBase;
            SymbolData outerSD;
            int prefixLen = qualifiedClassName.lastIndexOf(46);
            if (sD == null && prefixLen >= 0 && (outerSD = this.getQualifiedSymbolData(qualifyingBase = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf(46)), SourceInfo.NONE)) != null) {
                sD = outerSD.getInnerClassOrInterface(rtName);
                assert (sD == this.getQualifiedSymbolData(qualifyingBase + '.' + rtName, si));
            }
        }
        return sD;
    }

    protected SymbolData defineSymbolData(TypeDefBase typeDefBase, String qualifiedTypeName) {
        return this.defineSymbolData(typeDefBase, qualifiedTypeName, this._enclosingClassName);
    }

    protected SymbolData defineSymbolData(final TypeDefBase typeDefBase, String qualifiedTypeName, final String enclosingClassName) {
        assert (typeDefBase instanceof InterfaceDef || typeDefBase instanceof ClassDef);
        assert (!qualifiedTypeName.startsWith("null."));
        String name = qualifiedTypeName;
        SymbolData contSd = (SymbolData)this.symbolTable.get(qualifiedTypeName);
        if (contSd != null && !contSd.isContinuation()) {
            LanguageLevelVisitor._addAndIgnoreError("The class or interface " + name + " has already been defined.", typeDefBase);
            return null;
        }
        final SymbolData sd = contSd == null ? new SymbolData(qualifiedTypeName) : contSd;
        this.symbolTable.put(qualifiedTypeName, sd);
        sd.setIsContinuation(false);
        sd.setPackage(this._package);
        sd.setMav(typeDefBase.getMav());
        sd.setTypeParameters(typeDefBase.getTypeParameters());
        final ArrayList<SymbolData> interfaces = new ArrayList<SymbolData>();
        ReferenceType[] rts = typeDefBase.getInterfaces();
        for (int i = 0; i < rts.length; ++i) {
            final ReferenceType rt = rts[i];
            final String rtName = rt.getName();
            boolean forwardRef = false;
            SymbolData iD = this._lookupTypeFromWithinClass(rt, enclosingClassName);
            if (iD != null && !iD.isContinuation() && !iD.isInterface()) {
                LanguageLevelVisitor._addAndIgnoreError("The symbol " + rtName + " is not an interface", typeDefBase);
            }
            if (iD == null || iD.isContinuation()) {
                iD = new SymbolData(rtName);
                forwardRef = true;
            }
            interfaces.add(iD);
            if (!forwardRef) continue;
            final int j = i;
            Command fixUp = new Command(){

                public void execute() {
                    SymbolData newID = LanguageLevelVisitor.this._lookupTypeFromWithinClass(rt, enclosingClassName);
                    if (newID == null) {
                        LanguageLevelVisitor._addAndIgnoreError("The symbol " + rtName + " is not defined", typeDefBase);
                    } else if (!newID.isInterface()) {
                        LanguageLevelVisitor._addAndIgnoreError("The symbol " + rtName + " is not an interface", typeDefBase);
                    }
                    interfaces.set(j, newID);
                    sd.addEnclosingData(newID);
                }
            };
            fixUps.add(fixUp);
        }
        sd.setInterfaces(interfaces);
        SymbolData superSD = null;
        if (typeDefBase instanceof InterfaceDef) {
            SymbolData objectSD = this.getSymbolData("java.lang.Object", typeDefBase.getSourceInfo(), false);
            sd.setInterface(true);
            sd.setSuperClass(objectSD);
        } else if (typeDefBase instanceof ClassDef) {
            sd.setInterface(false);
            ClassDef cd = (ClassDef)typeDefBase;
            final ReferenceType rt = cd.getSuperclass();
            superSD = this._lookupTypeFromWithinClass(rt, enclosingClassName);
            if (superSD != null) {
                sd.setSuperClass(superSD);
            } else {
                Command fixUp = new Command(){

                    public void execute() {
                        SymbolData newSuperSD = LanguageLevelVisitor.this._lookupTypeFromWithinClass(rt, enclosingClassName);
                        if (newSuperSD == null) {
                            LanguageLevelVisitor._addAndIgnoreError("The class " + sd + " has an undefined superclass " + rt, typeDefBase);
                        } else {
                            sd.setSuperClass(newSuperSD);
                        }
                    }
                };
                fixUps.add(fixUp);
            }
        }
        _log.log("REMOVING continuation " + qualifiedTypeName);
        continuations.remove(qualifiedTypeName);
        if (!sd.isInterface()) {
            LanguageLevelConverter._newSDs.put(sd, this);
        }
        this._classesInThisFile.remove(qualifiedTypeName);
        return sd;
    }

    protected SymbolData defineInnerSymbolData(TypeDefBase typeDefBase, String relName, String qualifiedTypeName, Data enclosing) {
        assert (enclosing instanceof SymbolData || enclosing instanceof MethodData);
        SymbolData sd = this.defineSymbolData(typeDefBase, qualifiedTypeName);
        assert (sd != null);
        sd.setOuterData(enclosing);
        if (sd.isInterface()) {
            ((SymbolData)enclosing).addInnerInterface(sd);
        } else if (!enclosing.getName().equals(this._enclosingClassName)) {
            assert (enclosing instanceof MethodData);
            SymbolData enclosingClassSD = this.getQualifiedSymbolData(this._enclosingClassName);
            assert (enclosingClassSD != null);
            enclosingClassSD.addInnerClass(sd);
            enclosing.addInnerClass(sd);
        } else {
            assert (enclosing.getName().equals(this._enclosingClassName));
            enclosing.addInnerClass(sd);
        }
        return sd;
    }

    protected SymbolData defineAnonymousSymbolData(final AnonymousClassInstantiation anonInst, String qualifiedAnonName, final String superName) {
        SymbolData superSD;
        final SourceInfo si = anonInst.getSourceInfo();
        final SymbolData sd = new SymbolData(qualifiedAnonName);
        this.symbolTable.put(qualifiedAnonName, sd);
        sd.setIsContinuation(false);
        sd.setPackage(this._package);
        if (this._enclosingClassName != null) {
            SymbolData enclosingSD = this.getQualifiedSymbolData(this._enclosingClassName, SourceInfo.NONE);
            assert (enclosingSD != null);
            enclosingSD.addInnerClass(sd);
            sd.setOuterData(enclosingSD);
        }
        if ((superSD = this.getSymbolData(superName, anonInst.getSourceInfo())) != null) {
            if (superSD.isInterface()) {
                sd.setSuperClass(this.getQualifiedSymbolData("java.lang.Object", si));
                sd.setInterfaces(new ArrayList<SymbolData>(Arrays.asList(superSD)));
            } else {
                sd.setSuperClass(superSD);
            }
        } else {
            Command fixUp = new Command(){

                public void execute() {
                    SymbolData superSD = LanguageLevelVisitor.this.getSymbolData(superName, si);
                    if (superSD == null) {
                        LanguageLevelVisitor._addAndIgnoreError("The class/interface " + superName + " was not found.", anonInst);
                    } else if (superSD.isInterface()) {
                        sd.setSuperClass(LanguageLevelVisitor.this.getQualifiedSymbolData("java.lang.Object", si));
                        sd.setInterfaces(new ArrayList<SymbolData>(Arrays.asList(superSD)));
                    } else {
                        sd.setSuperClass(superSD);
                    }
                }
            };
            fixUps.add(fixUp);
        }
        return sd;
    }

    protected String[] getFormalParameterMav(Data d) {
        return new String[]{"final"};
    }

    protected VariableData[] formalParameters2VariableData(FormalParameter[] fps, SymbolData enclosing) {
        assert (enclosing != null);
        final VariableData[] varData = new VariableData[fps.length];
        final String enclosingClassName = enclosing.getName();
        String[] mav = this.getFormalParameterMav(enclosing);
        for (int i = 0; i < fps.length; ++i) {
            VariableDeclarator vd = fps[i].getDeclarator();
            String name = vd.getName().getText();
            Type type = vd.getType();
            final String typeName = type.getName();
            final SourceInfo si = type.getSourceInfo();
            SymbolData sd = this._identifyType(typeName, si, enclosingClassName);
            varData[i] = new VariableData(name, new ModifiersAndVisibility(SourceInfo.NONE, mav), sd, true, enclosing);
            assert (!varData[i].isPrivate());
            if (sd == null || sd == SymbolData.NOT_FOUND) {
                final int j = i;
                varData[j].setType(new SymbolData(typeName));
                Command fixUp = new Command(){

                    public void execute() {
                        SymbolData newSd = LanguageLevelVisitor.this._identifyType(typeName, si, enclosingClassName);
                        if (newSd == null || newSd == SymbolData.NOT_FOUND) {
                            System.err.println("****** In fixUp, the type " + typeName + " at " + si + " was NOT found.");
                        }
                        if (newSd != null) {
                            varData[j].setType(newSd);
                        }
                    }
                };
                fixUps.add(fixUp);
            }
            varData[i].gotValue();
            varData[i].setIsLocalVariable(true);
        }
        return varData;
    }

    private SymbolData _lookupReturnString(String rtString, SourceInfo si) {
        return rtString.equals("void") ? SymbolData.VOID_TYPE : this.getSymbolData(rtString, si);
    }

    protected MethodData createMethodData(final MethodDef that, final SymbolData sd) {
        assert (this._enclosingClassName != null && this.getQualifiedSymbolData(this._enclosingClassName).equals(sd));
        that.getMav().visit(this);
        that.getName().visit(this);
        String[] throwStrings = LanguageLevelVisitor.referenceType2String(that.getThrows());
        final String rtString = that.getResult().getName();
        final SourceInfo si = that.getResult().getSourceInfo();
        SymbolData returnType = this._identifyType(rtString, si, this._enclosingClassName);
        final String name = that.getName().getText();
        final MethodData md = MethodData.make(name, that.getMav(), that.getTypeParams(), returnType, null, throwStrings, sd, that);
        VariableData[] vds = this.formalParameters2VariableData(that.getParams(), sd);
        if (returnType == null) {
            final String enclosingClassName = this._enclosingClassName;
            Command fixUp = new Command(){

                public void execute() {
                    SymbolData newReturnType = LanguageLevelVisitor.this._identifyType(rtString, si, enclosingClassName);
                    if (newReturnType == null && !(LanguageLevelVisitor.this instanceof FullJavaVisitor)) {
                        LanguageLevelVisitor._addAndIgnoreError("The return type " + rtString + " for method " + name + " in type " + sd + " is undefined.", that);
                    } else {
                        md.setReturnType(newReturnType);
                    }
                }
            };
            fixUps.add(fixUp);
        }
        if (LanguageLevelVisitor._checkError()) {
            return md;
        }
        md.setParams(vds);
        if (!md.addVars(vds)) {
            LanguageLevelVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
        }
        return md;
    }

    private static String declaratorsToString(VariableDeclarator[] vds) {
        StringBuilder printString = new StringBuilder("{ ");
        for (VariableDeclarator vd : vds) {
            printString.append(vd.getName().getText()).append(": ").append(vd.getType().getName()).append("; ");
        }
        return printString.append('}').toString();
    }

    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosing) {
        VariableDeclarator[] declarators;
        assert (enclosing != null);
        LinkedList<VariableData> vds = new LinkedList<VariableData>();
        ModifiersAndVisibility mav = vd.getMav();
        for (final VariableDeclarator declarator : declarators = vd.getDeclarators()) {
            declarator.visit(this);
            final Type type = declarator.getType();
            String name = declarator.getName().getText();
            final String typeName = type.getName();
            SymbolData sd = this._identifyType(typeName, declarator.getSourceInfo(), this._enclosingClassName);
            boolean initialized = declarator instanceof InitializedVariableDeclarator;
            final VariableData vdata = new VariableData(name, mav, sd, initialized, enclosing);
            vdata.setHasInitializer(initialized);
            vds.addLast(vdata);
            if (sd != null) continue;
            final String enclosingName = this._enclosingClassName;
            Command fixup = new Command(){

                public void execute() {
                    SymbolData newSd = LanguageLevelVisitor.this._identifyType(typeName, declarator.getSourceInfo(), enclosingName);
                    if (newSd != null) {
                        vdata.setType(newSd);
                    } else if (!(LanguageLevelVisitor.this instanceof FullJavaVisitor)) {
                        LanguageLevelVisitor._addAndIgnoreError("Class or Interface " + typeName + " not found", type);
                    }
                }
            };
            fixUps.add(fixup);
        }
        return vds.toArray(new VariableData[vds.size()]);
    }

    protected SymbolData _identifyType(String name, SourceInfo si, String enclosingClassName) {
        if (this._genericTypes.containsKey(name)) {
            return this._genericTypes.get(name);
        }
        SymbolData sd = this.getSymbolData(name, si);
        if (sd != null) {
            return sd;
        }
        if (enclosingClassName == null) {
            return null;
        }
        SymbolData enclosingSD = this.getQualifiedSymbolData(enclosingClassName, SourceInfo.NONE);
        if (enclosingSD == null) {
            return null;
        }
        sd = enclosingSD.getInnerClassOrInterface(name);
        return sd;
    }

    protected static void _addError(String message, JExpressionIF that) {
        _errorAdded = true;
        Pair<String, JExpressionIF> p = new Pair<String, JExpressionIF>(message, that);
        if (!errors.contains(p)) {
            errors.addLast(p);
        }
    }

    protected static void _addAndIgnoreError(String message, JExpressionIF that) {
        if (_errorAdded) {
            throw new RuntimeException("Internal Program Error: _addAndIgnoreError called while _errorAdded was true.  Please report this bug.");
        }
        _errorAdded = false;
        Pair<String, JExpressionIF> newMsg = new Pair<String, JExpressionIF>(message, that);
        if (!errors.contains(newMsg)) {
            errors.addLast(newMsg);
        }
    }

    @Override
    protected boolean prune(JExpressionIF node) {
        return LanguageLevelVisitor._checkError();
    }

    protected static boolean _checkError() {
        if (_errorAdded) {
            _errorAdded = false;
            return true;
        }
        return false;
    }

    public void _badModifiers(String first, String second, JExpressionIF that) {
        LanguageLevelVisitor._addError("Illegal combination of modifiers. Can't use " + first + " and " + second + " together.", that);
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        Object[] modifiersAndVisibility = that.getModifiers();
        Arrays.sort(modifiersAndVisibility);
        if (modifiersAndVisibility.length > 0) {
            Object s = modifiersAndVisibility[0];
            for (int i = 1; i < modifiersAndVisibility.length; ++i) {
                if (((String)s).equals(modifiersAndVisibility[i])) {
                    LanguageLevelVisitor._addError("Duplicate modifier: " + (String)s, that);
                }
                s = modifiersAndVisibility[i];
            }
            Object visibility = "package";
            boolean isAbstract = false;
            boolean isStatic = false;
            boolean isFinal = false;
            boolean isSynchronized = false;
            boolean isStrictfp = false;
            boolean isTransient = false;
            boolean isVolatile = false;
            boolean isNative = false;
            for (int i = 0; i < modifiersAndVisibility.length; ++i) {
                s = modifiersAndVisibility[i];
                if (((String)s).equals("public") || ((String)s).equals("protected") || ((String)s).equals("private")) {
                    if (!((String)visibility).equals("package")) {
                        this._badModifiers((String)visibility, (String)s, that);
                        continue;
                    }
                    if (((String)s).equals("private") && isAbstract) {
                        this._badModifiers("private", "abstract", that);
                        continue;
                    }
                    visibility = s;
                    continue;
                }
                if (((String)s).equals("abstract")) {
                    isAbstract = true;
                    continue;
                }
                if (((String)s).equals("final")) {
                    isFinal = true;
                    if (!isAbstract) continue;
                    this._badModifiers("final", "abstract", that);
                    continue;
                }
                if (((String)s).equals("native")) {
                    isNative = true;
                    if (!isAbstract) continue;
                    this._badModifiers("native", "abstract", that);
                    continue;
                }
                if (((String)s).equals("synchronized")) {
                    isSynchronized = true;
                    if (!isAbstract) continue;
                    this._badModifiers("synchronized", "abstract", that);
                    continue;
                }
                if (!((String)s).equals("volatile")) continue;
                isVolatile = true;
                if (!isFinal) continue;
                this._badModifiers("final", "volatile", that);
            }
            return this.forJExpressionDoFirst(that);
        }
        return null;
    }

    @Override
    public Void forClassDefDoFirst(ClassDef that) {
        String name = that.getName().getText();
        for (String s : this._importedFiles) {
            if (!s.endsWith(name) || s.equals(this.getQualifiedClassName(name))) continue;
            LanguageLevelVisitor._addAndIgnoreError("The class " + name + " was already imported.", that);
        }
        String[] mavStrings = that.getMav().getModifiers();
        if (!(that instanceof InnerClassDef)) {
            for (int i = 0; i < mavStrings.length; ++i) {
                if (!mavStrings[i].equals("private")) continue;
                LanguageLevelVisitor._addAndIgnoreError("Top level classes cannot be private", that);
            }
        }
        SymbolData javaLangClass = this.getQualifiedSymbolData("java.lang." + that.getName().getText(), that.getSourceInfo(), false, false, false);
        if (that.getName().getText().equals("TestCase") || javaLangClass != null && !javaLangClass.isContinuation()) {
            LanguageLevelVisitor._addError("You cannot define a class with the name " + that.getName().getText() + " because that class name is reserved." + "  Please choose a different name for this class", that);
        }
        return this.forTypeDefBaseDoFirst(that);
    }

    @Override
    public Void forInterfaceDefDoFirst(InterfaceDef that) {
        String[] mavStrings = that.getMav().getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (mavStrings[i].equals("private")) {
                LanguageLevelVisitor._addAndIgnoreError("Top level interfaces cannot be private", that);
            }
            if (!mavStrings[i].equals("final")) continue;
            LanguageLevelVisitor._addAndIgnoreError("Interfaces cannot be final", that);
        }
        return this.forTypeDefBaseDoFirst(that);
    }

    @Override
    public Void forInnerInterfaceDefDoFirst(InnerInterfaceDef that) {
        String[] mavStrings = that.getMav().getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (!mavStrings[i].equals("final")) continue;
            LanguageLevelVisitor._addAndIgnoreError("Interfaces cannot be final", that);
        }
        return this.forTypeDefBaseDoFirst(that);
    }

    public void anonymousClassInstantiationHelper(AnonymousClassInstantiation that, SymbolData enclosing, String superName) {
        that.getArguments().visit(this);
        SymbolData enclosingSD = enclosing.getSymbolData();
        String enclosingSDName = enclosingSD.getName();
        assert (enclosingSDName.equals(this._enclosingClassName));
        String anonName = this.getQualifiedClassName(enclosingSDName) + "$" + enclosingSD.preincrementAnonymousInnerClassNum();
        SymbolData anonSD = this.defineAnonymousSymbolData(that, anonName, superName);
        this.createToString(anonSD);
        this.createHashCode(anonSD);
        this.createEquals(anonSD);
        that.getBody().visit(this.newClassBodyVisitor(anonSD, anonName));
    }

    protected void identifyInnerClasses(TypeDefBase that) {
        String prefix = this._enclosingClassName == null ? "" : this._enclosingClassName + '.';
        String enclosingType = this.getQualifiedClassName(prefix + that.getName().getText());
        assert (enclosingType != null);
        SymbolData sd = this.getSymbolData(enclosingType, SourceInfo.NONE);
        enclosingType = sd.getName();
        BracedBody body = that.getBody();
        for (BodyItemI bi : body.getStatements()) {
            if (!(bi instanceof TypeDefBase)) continue;
            TypeDefBase type = (TypeDefBase)((Object)bi);
            String rawClassName = type.getName().getText();
            String fullClassName = enclosingType + '.' + rawClassName;
            SymbolData innerSD = this.makeContinuation(bi.getSourceInfo(), fullClassName);
            sd.addInnerClass(innerSD);
        }
    }

    @Override
    public Void forPackageStatementOnly(PackageStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        String separator = System.getProperty("file.separator");
        if (words.length > 0) {
            String newPackage = this._package = words[0].getText();
            for (int i = 1; i < words.length; ++i) {
                String temp = words[i].getText();
                newPackage = newPackage + separator + temp;
                this._package = this._package + '.' + temp;
            }
            String directory = this._file.getParent();
            if (directory == null || !directory.endsWith(newPackage)) {
                LanguageLevelVisitor._addAndIgnoreError("The package name must mirror your file's directory.", that);
            }
        }
        return this.forJExpressionOnly(that);
    }

    @Override
    public Void forClassImportStatementOnly(ClassImportStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        for (int i = 0; i < this._importedFiles.size(); ++i) {
            String name = this._importedFiles.get(i);
            int indexOfLastDot = name.lastIndexOf(46);
            if (indexOfLastDot == -1 || !words[words.length - 1].getText().equals(name.substring(indexOfLastDot + 1, name.length()))) continue;
            LanguageLevelVisitor._addAndIgnoreError("The class " + words[words.length - 1].getText() + " has already been imported.", that);
            return null;
        }
        StringBuilder nameBuff = new StringBuilder(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            nameBuff.append('.' + words[i].getText());
        }
        String qualifiedTypeName = nameBuff.toString();
        this._importedFiles.addLast(qualifiedTypeName);
        this.createImportedSymbolContinuation(qualifiedTypeName, that.getSourceInfo());
        return this.forImportStatementOnly(that);
    }

    protected SymbolData createImportedSymbolContinuation(String qualifiedTypeName, SourceInfo si) {
        SymbolData sd = (SymbolData)this.symbolTable.get(qualifiedTypeName);
        if (sd == null) {
            sd = this.makeContinuation(si, qualifiedTypeName);
        }
        return sd;
    }

    @Override
    public Void forPackageImportStatementOnly(PackageImportStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuilder tempBuff = new StringBuilder(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            tempBuff.append('.' + words[i].getText());
        }
        String temp = tempBuff.toString();
        if (this._package.equals(temp)) {
            LanguageLevelVisitor._addAndIgnoreError("You do not need to import package " + temp + ". It is your package so all public classes in it are already visible.", that);
            return null;
        }
        if (!this._importedPackages.contains(temp)) {
            this._importedPackages.addLast(temp);
        }
        return this.forImportStatementOnly(that);
    }

    @Override
    public Void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        for (int i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("abstract")) continue;
            LanguageLevelVisitor._addError("Methods that have a braced body cannot be declared \"abstract\"", that);
            break;
        }
        return super.forConcreteMethodDefDoFirst(that);
    }

    @Override
    public Void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        if (Utilities.isStatic(modifiers)) {
            this._badModifiers("static", "abstract", that);
        }
        return super.forAbstractMethodDefDoFirst(that);
    }

    @Override
    public Void forShiftAssignmentExpressionDoFirst(ShiftAssignmentExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseAssignmentExpressionDoFirst(BitwiseAssignmentExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseBinaryExpressionDoFirst(BitwiseBinaryExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseOrExpressionDoFirst(BitwiseOrExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseXorExpressionDoFirst(BitwiseXorExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseAndExpressionDoFirst(BitwiseAndExpression that) {
        return null;
    }

    @Override
    public Void forBitwiseNotExpressionDoFirst(BitwiseNotExpression that) {
        return null;
    }

    @Override
    public Void forShiftBinaryExpressionDoFirst(ShiftBinaryExpression that) {
        return null;
    }

    public Void forBitwiseNotExpressionDoFirst(ShiftBinaryExpression that) {
        return null;
    }

    @Override
    public Void forEmptyExpressionDoFirst(EmptyExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("You appear to be missing an expression here", that);
        return null;
    }

    @Override
    public Void forNoOpExpressionDoFirst(NoOpExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("You are missing a binary operator here", that);
        return null;
    }

    @Override
    public Void forSourceFileDoFirst(SourceFile that) {
        for (int i = 0; i < that.getTypes().length; ++i) {
            ClassDef c;
            String superName;
            if (!(that.getTypes()[i] instanceof ClassDef) || !(superName = (c = (ClassDef)that.getTypes()[i]).getSuperclass().getName()).equals("TestCase") && !superName.equals("junit.framework.TestCase") || that.getTypes().length <= 1) continue;
            LanguageLevelVisitor._addAndIgnoreError("TestCases must appear in files by themselves in functional code", c);
        }
        return null;
    }

    @Override
    public Void forSourceFile(SourceFile that) {
        String qualifiedClassName;
        int i;
        int i2;
        this.forSourceFileDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        for (i2 = 0; i2 < that.getPackageStatements().length; ++i2) {
            that.getPackageStatements()[i2].visit(this);
        }
        for (i2 = 0; i2 < that.getImportStatements().length; ++i2) {
            that.getImportStatements()[i2].visit(this);
        }
        if (!this._importedPackages.contains("java.lang")) {
            this._importedPackages.addFirst("java.lang");
        }
        TypeDefBase[] types = that.getTypes();
        this._classesInThisFile = new HashSet();
        for (i = 0; i < types.length; ++i) {
            qualifiedClassName = this.getQualifiedClassName(types[i].getName().getText());
            this._classesInThisFile.add(qualifiedClassName);
            _log.log("Adding " + qualifiedClassName + " to _classesInThisFile");
        }
        for (i = 0; i < types.length; ++i) {
            qualifiedClassName = this.getQualifiedClassName(types[i].getName().getText());
            if (!this._classesInThisFile.contains(qualifiedClassName)) continue;
            types[i].visit(this);
        }
        return this.forSourceFileOnly(that);
    }

    @Override
    public Void forSimpleNameReference(SimpleNameReference that) {
        that.visit(new ResolveNameVisitor());
        return null;
    }

    @Override
    public Void forComplexNameReference(ComplexNameReference that) {
        that.visit(new ResolveNameVisitor());
        return null;
    }

    @Override
    public Void forVariableDeclaration(VariableDeclaration that) {
        this.forVariableDeclarationDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        that.getMav().visit(this);
        return this.forVariableDeclarationOnly(that);
    }

    protected static void addGeneratedMethod(SymbolData sd, MethodData md) {
        MethodData rmd = SymbolData.repeatedSignature(sd.getMethods(), md);
        if (rmd == null) {
            sd.addMethod(md, true);
            md.setGenerated(true);
        } else if (!LanguageLevelVisitor.getUnqualifiedClassName(sd.getName()).equals(md.getName())) {
            LanguageLevelVisitor._addAndIgnoreError("The method " + md.getName() + " is automatically generated, and thus you cannot override it", rmd.getJExpression());
        }
    }

    public void createConstructor(SymbolData sd) {
        if (LanguageLevelConverter.isAdvancedFile(this._file)) {
            return;
        }
        if (sd.isContinuation()) {
            LanguageLevelVisitor._addAndIgnoreError("Could not generate constructor for class " + sd + " because it has no definition", new NullLiteral(SourceInfo.NONE));
            return;
        }
        SymbolData superSd = sd.getSuperClass();
        if (superSd == null) {
            LanguageLevelVisitor._addAndIgnoreError("Could not generate constructor for class " + sd + " because it has no superclass", new NullLiteral(SourceInfo.NONE));
            return;
        }
        LinkedList<MethodData> superMethods = superSd.getMethods();
        String superUnqualifiedName = LanguageLevelVisitor.getUnqualifiedClassName(superSd.getName());
        LanguageLevelVisitor sslv = LanguageLevelConverter._newSDs.remove(superSd);
        if (sslv != null) {
            sslv.createConstructor(superSd);
        }
        MethodData superConstructor = null;
        for (MethodData superMd : superMethods) {
            if (!superMd.getName().equals(superUnqualifiedName) || superConstructor != null && superMd.getParams().length >= superConstructor.getParams().length) continue;
            superConstructor = superMd;
        }
        if (superConstructor == null) {
            LanguageLevelVisitor._addAndIgnoreError("Could not generate constructor for class " + sd + " superclass has no constructor, perhaps" + " because the class hierarchy is cyclic.", new NullLiteral(SourceInfo.NONE));
            return;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(sd.getName());
        MethodData md = new MethodData(name, PUBLIC_MAV, new TypeParameter[0], sd, new VariableData[0], new String[0], sd, null);
        LinkedList<VariableData> params = new LinkedList<VariableData>();
        for (VariableData superParam : superConstructor.getParams()) {
            String paramName = md.createUniqueName("super_" + superParam.getName());
            SymbolData superParamSD = superParam.getType();
            assert (superParamSD != null);
            VariableData newParam = new VariableData(paramName, PACKAGE_MAV, superParamSD, true, sd);
            newParam.setGenerated(true);
            params.add(newParam);
            md.addVar(newParam);
        }
        boolean hasOtherConstructor = sd.hasMethod(name);
        for (VariableData field : sd.getVars()) {
            if (field.hasInitializer() || field.hasModifier("static")) continue;
            if (!hasOtherConstructor) {
                field.gotValue();
            }
            VariableData param = field.copyWithoutVisibility();
            params.add(param);
        }
        md.setParams(params.toArray(new VariableData[params.size()]));
        md.setVars(params);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
        LanguageLevelConverter._newSDs.remove(sd);
    }

    protected static void createAccessors(SymbolData sd, File file) {
        if (LanguageLevelConverter.isAdvancedFile(file)) {
            return;
        }
        LinkedList<VariableData> fields = sd.getVars();
        for (final VariableData vd : fields) {
            if (vd.hasModifier("static")) continue;
            String name = LanguageLevelVisitor.getFieldAccessorName(vd.getName());
            SymbolData returnTypeSD = vd.getType();
            final MethodData md = new MethodData(name, PUBLIC_MAV, new TypeParameter[0], returnTypeSD, new VariableData[0], new String[0], sd, null);
            LanguageLevelVisitor.addGeneratedMethod(sd, md);
            if (returnTypeSD != null) continue;
            Command fixUp = new Command(){

                public void execute() {
                    md.setReturnType(vd.getType());
                }
            };
            fixUps.add(fixUp);
        }
    }

    protected void createToString(SymbolData sd) {
        String name = "toString";
        MethodData md = new MethodData(name, PUBLIC_MAV, new TypeParameter[0], this.getSymbolData("java.lang.String", SourceInfo.make("java.lang.String")), new VariableData[0], new String[0], sd, null);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    protected void createHashCode(SymbolData sd) {
        String name = "hashCode";
        MethodData md = new MethodData(name, PUBLIC_MAV, new TypeParameter[0], SymbolData.INT_TYPE, new VariableData[0], new String[0], sd, null);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    protected void createEquals(SymbolData sd) {
        String name = "equals";
        SymbolData type = this.getSymbolData("java.lang.Object", SourceInfo.make("java.lang.Object"));
        VariableData param = new VariableData(type);
        MethodData md = new MethodData(name, PUBLIC_MAV, new TypeParameter[0], SymbolData.BOOLEAN_TYPE, new VariableData[]{param}, new String[0], sd, null);
        param.setEnclosingData(md);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    @Override
    public Void forMemberType(MemberType that) {
        this.forMemberTypeDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        return this.forMemberTypeOnly(that);
    }

    @Override
    public Void forStringLiteralOnly(StringLiteral that) {
        this.getQualifiedSymbolData("java.lang.String", that.getSourceInfo(), true);
        return null;
    }

    @Override
    public Void forSimpleNamedClassInstantiation(SimpleNamedClassInstantiation that) {
        this.forSimpleNamedClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        that.getType().visit(this);
        that.getArguments().visit(this);
        this.getSymbolData(that.getType().getName(), that.getSourceInfo());
        return this.forSimpleNamedClassInstantiationOnly(that);
    }

    public static boolean arrayEquals(Object[] array1, Object[] array2) {
        int n = array1.length;
        if (n != array2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object o1 = array1[i];
            Object o2 = array2[i];
            if (o1 == null && o2 != null) {
                return false;
            }
            if (o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ SymbolData access$000(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3, boolean x4) {
        return x0.getArraySymbolData(x1, x2, x3, x4);
    }

    static {
        _log = new Log("LLConverter.txt", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveNameVisitor
    extends JExpressionIFAbstractVisitor<TypeData> {
        @Override
        public TypeData defaultCase(JExpressionIF that) {
            that.visit(LanguageLevelVisitor.this);
            return null;
        }

        @Override
        public TypeData forSimpleNameReference(SimpleNameReference that) {
            SymbolData result = LanguageLevelVisitor.this.getSymbolData(that.getName().getText(), that.getSourceInfo());
            if (result == SymbolData.NOT_FOUND) {
                return new PackageData(that.getName().getText());
            }
            return result;
        }

        @Override
        public TypeData forComplexNameReference(ComplexNameReference that) {
            TypeData lhs = that.getEnclosing().visit(this);
            SymbolData result = LanguageLevelVisitor.this.getSymbolData(lhs, that.getName().getText(), that.getSourceInfo(), true);
            if (result == SymbolData.NOT_FOUND) {
                if (lhs instanceof PackageData) {
                    return new PackageData((PackageData)lhs, that.getName().getText());
                }
                return null;
            }
            return result;
        }
    }
}

