/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import java.io.File;

public final class SourceInfo {
    public static final SourceInfo NONE;
    public static final SourceInfo NO_INFO;
    public static final SourceInfo TEST_0;
    public static final SourceInfo TEST_1;
    private final File _file;
    private final int _startLine;
    private final int _startColumn;
    private final int _endLine;
    private final int _endColumn;

    public SourceInfo(File file, int startLine, int startColumn, int endLine, int endColumn) {
        this._file = file;
        this._startLine = startLine;
        this._startColumn = startColumn;
        this._endLine = endLine;
        this._endColumn = endColumn;
    }

    public final File getFile() {
        return this._file;
    }

    public final int getStartLine() {
        return this._startLine;
    }

    public final int getStartColumn() {
        return this._startColumn;
    }

    public final int getEndLine() {
        return this._endLine;
    }

    public final int getEndColumn() {
        return this._endColumn;
    }

    public String toString() {
        String fileName = this._file == null ? "(no file)" : this._file.getName();
        return "[" + fileName + ": " + "(" + this._startLine + "," + this._startColumn + ")-" + "(" + this._endLine + "," + this._endColumn + ")]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SourceInfo casted = (SourceInfo)obj;
        File tF = this.getFile();
        File oF = casted.getFile();
        if (tF == null && oF != null || tF != null && !tF.equals(oF)) {
            return false;
        }
        if (this.getStartLine() != casted.getStartLine()) {
            return false;
        }
        if (this.getStartColumn() != casted.getStartColumn()) {
            return false;
        }
        if (this.getEndLine() != casted.getEndLine()) {
            return false;
        }
        return this.getEndColumn() == casted.getEndColumn();
    }

    public final int hashCode() {
        int code = this.getClass().hashCode();
        if (this.getFile() != null) {
            code ^= this.getFile().hashCode();
        }
        code ^= this.getStartLine();
        code ^= this.getStartColumn();
        code ^= this.getEndLine();
        return code ^= this.getEndColumn();
    }

    public static SourceInfo make(String qualifiedClassName) {
        return new SourceInfo(new File(qualifiedClassName), -1, -1, -1, -1);
    }

    static {
        NO_INFO = NONE = new SourceInfo(null, -1, -1, -1, -1);
        TEST_0 = new SourceInfo(null, 0, 0, 0, 0);
        TEST_1 = new SourceInfo(null, 1, 1, 1, 1);
    }
}

