/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.util.Utilities;
import java.util.Arrays;
import java.util.LinkedList;

public class VariableData {
    private String _name;
    private ModifiersAndVisibility _modifiersAndVisibility;
    private SymbolData _type;
    private boolean _hasBeenAssigned;
    private boolean _hasInitializer;
    private Data _enclosingData;
    private boolean _generated;
    private boolean _isLocalVariable;
    private InstanceData _instance;

    public VariableData(String name, ModifiersAndVisibility modifiersAndVisibility, SymbolData type, boolean hasBeenAssigned, Data enclosingData) {
        this._name = name;
        this._modifiersAndVisibility = modifiersAndVisibility;
        this._type = type;
        this._hasBeenAssigned = hasBeenAssigned;
        this._enclosingData = enclosingData;
        this._hasInitializer = false;
        this._generated = false;
        this._isLocalVariable = false;
        this._instance = null;
    }

    public VariableData(SymbolData type) {
        this._name = "";
        this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NONE, new String[0]);
        this._type = type;
        this._hasBeenAssigned = false;
        this._isLocalVariable = true;
        this._instance = null;
    }

    public VariableData copyWithoutVisibility() {
        String[] mavStrings = this._modifiersAndVisibility.getModifiers();
        LinkedList<String> newMavList = new LinkedList<String>();
        int size = 0;
        for (int i = 0; i < mavStrings.length; ++i) {
            String mod = mavStrings[i];
            if (VariableData.isVisibility(mod)) continue;
            newMavList.add(mod);
            ++size;
        }
        String[] newMavStrings = newMavList.toArray(new String[size]);
        ModifiersAndVisibility newMav = new ModifiersAndVisibility(SourceInfo.NONE, newMavStrings);
        return new VariableData(this._name, newMav, this._type, true, this._enclosingData);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VariableData vd = (VariableData)obj;
        if (!this._name.equals(vd.getName())) {
            return false;
        }
        if (!this._modifiersAndVisibility.equals(vd.getMav())) {
            return false;
        }
        if (!this._type.equals(vd.getType())) {
            return false;
        }
        if (this._hasBeenAssigned != vd.hasValue()) {
            return false;
        }
        if (this._hasInitializer != vd._hasInitializer) {
            return false;
        }
        Data otherEnclosingData = vd.getEnclosingData();
        if (this._enclosingData == null) {
            return otherEnclosingData == null;
        }
        return this._enclosingData == otherEnclosingData;
    }

    public int hashCode() {
        return this.getEnclosingData().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return "VariableData(" + this._name + ", " + Arrays.toString(this._modifiersAndVisibility.getModifiers()) + ", " + this._type + ", " + this._hasBeenAssigned + ")";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    public ModifiersAndVisibility getMav() {
        return this._modifiersAndVisibility;
    }

    public void setMav(ModifiersAndVisibility mav) {
        this._modifiersAndVisibility = mav;
    }

    public SymbolData getType() {
        return this._type;
    }

    public void setType(SymbolData type) {
        this._type = type;
    }

    public InstanceData getInstanceData() {
        assert (this._type != null);
        if (this._instance == null) {
            this._instance = this._type.getInstanceData();
        }
        return this._instance;
    }

    public Data getEnclosingData() {
        return this._enclosingData;
    }

    public void setEnclosingData(Data d) {
        this._enclosingData = d;
    }

    public boolean isLocalVariable() {
        return this._isLocalVariable;
    }

    public void setIsLocalVariable(boolean b) {
        this._isLocalVariable = b;
    }

    public void setFinal() {
        String[] newModifiers = Utilities.catenate(this._modifiersAndVisibility.getModifiers(), new String[]{"final"});
        this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NONE, newModifiers);
    }

    public void setPrivate() {
        if (!this.hasModifier("private")) {
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = "private";
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NONE, newModifiers);
        }
    }

    public void addModifier(String s) {
        if (!this.hasModifier(s)) {
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = s;
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NONE, newModifiers);
        }
    }

    public void setPrivateAndFinal() {
        this.setPrivate();
        this.setFinal();
    }

    public void setFinalAndStatic() {
        this.setFinal();
        this.addModifier("static");
    }

    public boolean isFinal() {
        return this.hasModifier("final");
    }

    public boolean isPrivate() {
        return this.hasModifier("private");
    }

    public boolean isStatic() {
        return this.hasModifier("static");
    }

    public static boolean isVisibility(String s) {
        return s.equals("private") || s.equals("protected") || s.equals("public");
    }

    public boolean hasModifier(String modifier) {
        String[] mavStrings = this._modifiersAndVisibility.getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (!mavStrings[i].equals(modifier)) continue;
            return true;
        }
        return false;
    }

    public void setGenerated(boolean value) {
        this._generated = value;
    }

    public boolean isGenerated() {
        return this._generated;
    }

    public boolean hasInitializer() {
        return this._hasInitializer;
    }

    public void setHasInitializer(boolean value) {
        this._hasInitializer = value;
    }

    public boolean hasValue() {
        return this._hasBeenAssigned;
    }

    public void setHasValue() {
        this._hasBeenAssigned = true;
    }

    public boolean gotValue() {
        if (this.hasValue()) {
            return false;
        }
        this._hasBeenAssigned = true;
        return true;
    }

    public boolean lostValue() {
        if (this.hasValue()) {
            this._hasBeenAssigned = false;
            return true;
        }
        return false;
    }
}

