/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.util;

import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.util.ScrollableDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.swing.AbstractAction;
import javax.swing.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
            }
        });
    }

    public static void show(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, "Debug Message", "Debug Message from Utilities.show():", msg, false).show();
            }
        });
    }

    public static void showDebug(String msg) {
        Utilities.showMessageBox(msg, "Debug Message");
    }

    public static void showMessageBox(final String msg, final String title) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, title, "Message:", msg, false).show();
            }
        });
    }

    public static void showStackTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, "Stack Trace", "Stack Trace:", Utilities.getStackTrace(t), false).show();
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            int ch;
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            StringBuilder sb = new StringBuilder();
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            s = sb.toString();
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static AbstractAction createDelegateAction(String newName, final Action delegate) {
        return new AbstractAction(newName){

            public void actionPerformed(ActionEvent ae) {
                delegate.actionPerformed(ae);
            }
        };
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String getStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] stes = e.getStackTrace();
            int skip = 1;
            for (StackTraceElement ste : stes) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                pw.print("at ");
                pw.println(ste);
            }
            return sw.toString();
        }
    }

    public static boolean contains(Object[] a, Object elt) {
        for (Object o : a) {
            if (!o.equals(elt)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisibilityModifier(String[] modifiers) {
        for (String s : modifiers) {
            if (!s.equals("private") && !s.equals("public") && !s.equals("protected")) continue;
            return true;
        }
        return false;
    }

    public static boolean isFinal(String[] modifiers) {
        return Utilities.contains(modifiers, "final");
    }

    public static boolean isStatic(String[] modifiers) {
        return Utilities.contains(modifiers, "static");
    }

    public static boolean isPublic(String[] modifiers) {
        return Utilities.contains(modifiers, "public");
    }

    public static boolean isProtected(String[] modifiers) {
        return Utilities.contains(modifiers, "protected");
    }

    public static boolean isPrivate(String[] modifiers) {
        return Utilities.contains(modifiers, "private");
    }

    public static boolean isAbstract(String[] modifiers) {
        return Utilities.contains(modifiers, "abstract");
    }

    public static boolean isFinal(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "final");
    }

    public static boolean isStatic(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "static");
    }

    public static boolean isPublic(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "public");
    }

    public static boolean isProtected(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "protected");
    }

    public static boolean isPrivate(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "private");
    }

    public static boolean isAbstract(ModifiersAndVisibility mav) {
        return Utilities.contains(mav.getModifiers(), "abstract");
    }

    public static <T> T[] catenate(T[] A, T[] B) {
        Class<?> eltClass = A.getClass().getComponentType();
        Object[] C = (Object[])Array.newInstance(eltClass, A.length + B.length);
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }
}

