/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.collect.ListenerSet;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.lambda.WrappedException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IncrementalTaskController<I, R>
extends TaskController<R> {
    private final boolean _ignoreIntermediate;
    private final AtomicInteger _steps;
    private final BlockingQueue<I> _intermediateQueue;
    private final ListenerSet<I> _intermediateListeners;

    protected IncrementalTaskController() {
        this(false);
    }

    protected IncrementalTaskController(boolean ignoreIntermediate) {
        this._ignoreIntermediate = ignoreIntermediate;
        this._steps = new AtomicInteger(0);
        this._intermediateQueue = this._ignoreIntermediate ? null : new LinkedBlockingQueue();
        this._intermediateListeners = new ListenerSet();
    }

    public int steps() {
        return this._steps.get();
    }

    public BlockingQueue<I> intermediateQueue() {
        if (this._ignoreIntermediate) {
            throw new IllegalStateException("No queue is maintained");
        }
        return this._intermediateQueue;
    }

    public ListenerSet.Sink intermediateListeners() {
        return this._intermediateListeners.sink();
    }

    public void pause() {
        boolean success = false;
        do {
            TaskController.State s;
            TaskController.State sObj;
            if ((sObj = (s = (TaskController.State)this.state.get())) instanceof TaskController.RunningState) {
                success = this.state.compareAndSet(s, new FreshPausingState());
                if (!success) continue;
                this.doPause();
                continue;
            }
            if (sObj instanceof TaskController.FreshStartingState) {
                success = this.state.compareAndSet(s, new PausedStartingState());
                continue;
            }
            if (sObj instanceof StartedPausingState) {
                success = this.state.compareAndSet(s, new FreshPausingState());
                continue;
            }
            if (sObj instanceof TaskController.CanceledState) {
                throw new CancellationException("Task is canceled");
            }
            success = true;
        } while (!success);
    }

    protected abstract void doPause();

    protected abstract void doResume();

    protected void paused() {
        boolean kept = false;
        TaskController.State current = (TaskController.State)this.state.get();
        PausedState next = new PausedState();
        while (current instanceof PausingState && !kept) {
            kept = this.state.weakCompareAndSet(current, next);
            if (kept) {
                ((PausingState)current).paused();
                continue;
            }
            current = (TaskController.State)this.state.get();
        }
    }

    protected void stepped(I intermediateResult) {
        if (!this._ignoreIntermediate) {
            try {
                this._intermediateQueue.put(intermediateResult);
            }
            catch (InterruptedException e) {
                throw new WrappedException(e);
            }
        }
        this._steps.incrementAndGet();
        this._intermediateListeners.run(intermediateResult);
    }

    protected class PausedStartingState
    extends TaskController.StartingState {
        protected PausedStartingState() {
            super(IncrementalTaskController.this);
        }

        public void start() {
            if (!IncrementalTaskController.this.state.compareAndSet(this, new TaskController.FreshStartingState(IncrementalTaskController.this))) {
                ((TaskController.State)IncrementalTaskController.this.state.get()).start();
            }
        }

        public void started() {
            IncrementalTaskController.this.pause();
        }
    }

    protected class StartedPausingState
    extends PausingState {
        protected StartedPausingState() {
        }

        public void start() {
        }

        public void paused() {
            ((TaskController.State)IncrementalTaskController.this.state.get()).start();
        }
    }

    protected class CanceledPausingState
    extends PausingState {
        protected CanceledPausingState() {
        }

        public void start() {
        }

        public boolean cancel(boolean stopRunning) {
            return stopRunning;
        }

        public void paused() {
            ((TaskController.State)IncrementalTaskController.this.state.get()).cancel(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FreshPausingState
    extends PausingState {
        protected FreshPausingState() {
        }

        @Override
        public void start() {
            if (!IncrementalTaskController.this.state.compareAndSet(this, new StartedPausingState())) {
                ((TaskController.State)IncrementalTaskController.this.state.get()).start();
            }
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            this.start();
            return ((TaskController.State)IncrementalTaskController.this.state.get()).get();
        }

        @Override
        public R get(long timeout, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
            this.start();
            return ((TaskController.State)IncrementalTaskController.this.state.get()).get(timeout, u);
        }

        @Override
        public void paused() {
        }
    }

    protected abstract class PausingState
    extends TaskController.ComputingState {
        protected PausingState() {
            super(IncrementalTaskController.this);
        }

        public TaskController.Status status() {
            return TaskController.Status.RUNNING;
        }

        public boolean cancel(boolean stopRunning) {
            if (stopRunning) {
                if (IncrementalTaskController.this.state.compareAndSet(this, new CanceledPausingState())) {
                    IncrementalTaskController.this.doStop();
                    return true;
                }
                return ((TaskController.State)IncrementalTaskController.this.state.get()).cancel(stopRunning);
            }
            return false;
        }

        public abstract void paused();
    }

    protected class PausedState
    extends TaskController.WaitingState {
        protected PausedState() {
            super(IncrementalTaskController.this);
        }

        public final void start() {
            if (IncrementalTaskController.this.state.compareAndSet(this, new TaskController.FreshStartingState(IncrementalTaskController.this))) {
                IncrementalTaskController.this.doResume();
            } else {
                ((TaskController.State)IncrementalTaskController.this.state.get()).start();
            }
        }
    }
}

