/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.Predicate;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMonitor<T>
implements Box<T>,
Serializable {
    private volatile T _state;

    public StateMonitor(T state) {
        this._state = state;
    }

    @Override
    public T value() {
        return this._state;
    }

    @Override
    public synchronized void set(T newState) {
        this._state = newState;
        this.notifyAll();
    }

    public synchronized T getAndSet(T newState) {
        T result = this._state;
        this._state = newState;
        this.notifyAll();
        return result;
    }

    public synchronized boolean compareAndSet(T expect, T update) {
        if (this._state == expect) {
            this._state = update;
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized T ensureState(T expected) throws InterruptedException {
        while (!this.inState(expected)) {
            this.wait();
        }
        return this._state;
    }

    public T ensureState(T expected, long timeout) throws InterruptedException, TimeoutException {
        return this.ensureState(expected, timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized T ensureState(T expected, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.inState(expected)) {
            long timeoutTime = ConcurrentUtil.futureTimeNanos(timeout, unit);
            do {
                ConcurrentUtil.waitUntilNanos(this, timeoutTime);
            } while (!this.inState(expected));
        }
        return this._state;
    }

    public synchronized T attemptEnsureState(T expected) {
        try {
            return this.ensureState(expected);
        }
        catch (InterruptedException e) {
            return this._state;
        }
    }

    public T attemptEnsureState(T expected, long timeout) {
        try {
            this.ensureState(expected, timeout, TimeUnit.MILLISECONDS);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    public T attemptEnsureState(T expected, long timeout, TimeUnit unit) {
        try {
            this.ensureState(expected, timeout, unit);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    public synchronized T ensureNotState(T wrong) throws InterruptedException {
        while (this.inState(wrong)) {
            this.wait();
        }
        return this._state;
    }

    public T ensureNotState(T wrong, long timeout) throws InterruptedException, TimeoutException {
        return this.ensureNotState(wrong, timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized T ensureNotState(T wrong, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.inState(wrong)) {
            long timeoutTime = ConcurrentUtil.futureTimeNanos(timeout, unit);
            do {
                ConcurrentUtil.waitUntilNanos(this, timeoutTime);
            } while (this.inState(wrong));
        }
        return this._state;
    }

    public synchronized T attemptEnsureNotState(T wrong) {
        try {
            return this.ensureNotState(wrong);
        }
        catch (InterruptedException e) {
            return this._state;
        }
    }

    public T attemptEnsureNotState(T expected, long timeout) {
        try {
            this.ensureNotState(expected, timeout, TimeUnit.MILLISECONDS);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    public T attemptEnsureNotState(T expected, long timeout, TimeUnit unit) {
        try {
            this.ensureNotState(expected, timeout, unit);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    public synchronized T ensurePredicate(Predicate<? super T> predicate) throws InterruptedException {
        while (!predicate.contains(this._state)) {
            this.wait();
        }
        return this._state;
    }

    public T ensurePredicate(Predicate<? super T> predicate, long timeout) throws InterruptedException, TimeoutException {
        return this.ensurePredicate(predicate, timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized T ensurePredicate(Predicate<? super T> predicate, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!predicate.contains(this._state)) {
            long timeoutTime = ConcurrentUtil.futureTimeNanos(timeout, unit);
            do {
                ConcurrentUtil.waitUntilNanos(this, timeoutTime);
            } while (!predicate.contains(this._state));
        }
        return this._state;
    }

    public synchronized T attemptEnsurePredicate(Predicate<? super T> predicate) {
        try {
            return this.ensurePredicate(predicate);
        }
        catch (InterruptedException e) {
            return this._state;
        }
    }

    public T attemptEnsurePredicate(Predicate<? super T> predicate, long timeout) {
        try {
            this.ensurePredicate(predicate, timeout, TimeUnit.MILLISECONDS);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    public T attemptEnsurePredicate(Predicate<? super T> predicate, long timeout, TimeUnit unit) {
        try {
            this.ensurePredicate(predicate, timeout, unit);
            return this._state;
        }
        catch (InterruptedException e) {
            return this._state;
        }
        catch (TimeoutException e) {
            return this._state;
        }
    }

    private boolean inState(T expected) {
        return expected == null ? this._state == null : expected.equals(this._state);
    }
}

