/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.text.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indenter {
    private final String _token;
    private int _level;
    private Thunk<String> _stringFactory;

    public Indenter() {
        this("  ");
    }

    public Indenter(int spaces) {
        this(TextUtil.repeat(' ', spaces));
    }

    public Indenter(String token) {
        this._token = token;
        this._level = 0;
        this._stringFactory = this.makeThunk();
    }

    public void push() {
        ++this._level;
        this._stringFactory = this.makeThunk();
    }

    public void pop() {
        --this._level;
        this._stringFactory = this.makeThunk();
    }

    public void atomicPush() {
        this.adjust(1);
        this._stringFactory = this.makeThunk();
    }

    public void atomicPop() {
        this.adjust(-1);
        this._stringFactory = this.makeThunk();
    }

    private synchronized void adjust(int delta) {
        this._level += delta;
    }

    public String indentString() {
        return this._stringFactory.value();
    }

    private Thunk<String> makeThunk() {
        return LazyThunk.make(new Thunk<String>(){

            @Override
            public String value() {
                if (Indenter.this._level <= 0) {
                    return "";
                }
                return TextUtil.repeat(Indenter.this._token, Indenter.this._level);
            }
        });
    }
}

