/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectOutputStream;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamSplitter
extends DirectOutputStream
implements Composite {
    private final Iterable<? extends OutputStream> _streams;

    public OutputStreamSplitter(OutputStream ... streams) {
        this._streams = IterUtil.asIterable(streams);
    }

    public OutputStreamSplitter(Iterable<? extends OutputStream> streams) {
        this._streams = streams;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._streams) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._streams) + 1;
    }

    @Override
    public void close() throws IOException {
        for (OutputStream outputStream : this._streams) {
            outputStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream outputStream : this._streams) {
            outputStream.flush();
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        for (OutputStream outputStream : this._streams) {
            outputStream.write(bytes);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        for (OutputStream outputStream : this._streams) {
            outputStream.write(bytes, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream outputStream : this._streams) {
            outputStream.write(b);
        }
    }
}

