/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityTriple;
import edu.rice.cs.plt.tuple.Triple;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecomputedRecursionStack3<T1, T2, T3, R> {
    private final Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> _tripleFactory;
    private final Map<Triple<T1, T2, T3>, Lambda3<? super T1, ? super T2, ? super T3, ? extends R>> _previous;
    private final LinkedList<Triple<T1, T2, T3>> _stack;

    public PrecomputedRecursionStack3() {
        this(IdentityTriple.factory());
    }

    public PrecomputedRecursionStack3(Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> tripleFactory) {
        this._tripleFactory = tripleFactory;
        this._previous = new HashMap<Triple<T1, T2, T3>, Lambda3<? super T1, ? super T2, ? super T3, ? extends R>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
        return this._previous.containsKey(this._tripleFactory.value(arg1, arg2, arg3));
    }

    public R get(T1 arg1, T2 arg2, T3 arg3) {
        Lambda3<T1, T2, T3, R> result = this._previous.get(this._tripleFactory.value(arg1, arg2, arg3));
        if (result == null) {
            throw new IllegalArgumentException("Values are not on the stack");
        }
        return result.value(arg1, arg2, arg3);
    }

    public void push(T1 arg1, T2 arg2, T3 arg3, R value) {
        this.push(arg1, arg2, arg3, (Lambda3<? super T1, ? super T2, ? super T3, ? extends R>)LambdaUtil.valueLambda(value));
    }

    public void push(T1 arg1, T2 arg2, T3 arg3, Thunk<? extends R> value) {
        this.push(arg1, arg2, arg3, (Lambda3<? super T1, ? super T2, ? super T3, ? extends R>)LambdaUtil.promote(value));
    }

    public void push(T1 arg1, T2 arg2, T3 arg3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> value) {
        Triple<T1, T2, T3> wrapped = this._tripleFactory.value(arg1, arg2, arg3);
        if (this._previous.containsKey(wrapped)) {
            throw new IllegalArgumentException("The given arguments are already on the stack");
        }
        this._stack.addLast(wrapped);
        this._previous.put(wrapped, value);
    }

    public void pop(T1 arg1, T2 arg2, T3 arg3) {
        Triple<T1, T2, T3> wrapped = this._tripleFactory.value(arg1, arg2, arg3);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("the given arguments are not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, R precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Thunk<? extends R> precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, R precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = lambda.value(arg1, arg2, arg3);
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, Thunk<? extends R> precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = lambda.value(arg1, arg2, arg3);
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> precomputed, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3, precomputed);
            try {
                R r = lambda.value(arg1, arg2, arg3);
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return this.get(arg1, arg2, arg3);
    }

    public static <T1, T2, T3, R> PrecomputedRecursionStack3<T1, T2, T3, R> make() {
        return new PrecomputedRecursionStack3<T1, T2, T3, R>();
    }

    public static <T1, T2, T3, R> PrecomputedRecursionStack3<T1, T2, T3, R> make(Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> tripleFactory) {
        return new PrecomputedRecursionStack3<T1, T2, T3, R>(tripleFactory);
    }
}

