/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.JoinInputStream;
import edu.rice.cs.util.ProcessCreator;
import edu.rice.cs.util.StreamRedirectException;
import edu.rice.cs.util.StreamRedirectThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class ProcessChain
extends Process {
    public static final char PROCESS_SEPARATOR_CHAR = '#';
    public static final String PROCESS_SEPARATOR = String.valueOf('#');
    public static final char PIPE_SEPARATOR_CHAR = '|';
    public static final String PIPE_SEPARATOR = String.valueOf('|');
    protected ProcessCreator[] _creators;
    protected Process[] _processes;
    protected boolean _aborted = false;
    protected Set<StreamRedirectThread> _redirectors = new HashSet<StreamRedirectThread>();
    protected PipedInputStream _combinedInputStream;
    protected PipedOutputStream _combinedStdOutStream;
    protected JoinInputStream _combinedInputJoinedWithDebugStream;
    protected PrintWriter _debugOutput;
    protected PipedInputStream _debugInputStream;
    protected PipedOutputStream _debugOutputStream;
    protected PipedInputStream _combinedErrorStream;
    protected PipedOutputStream _combinedStdErrStream;

    public ProcessChain(ProcessCreator[] pcs) {
        int i;
        this._creators = pcs;
        this._processes = new Process[this._creators.length];
        this._combinedInputStream = new PipedInputStream();
        try {
            this._combinedStdOutStream = new PipedOutputStream(this._combinedInputStream);
            this._combinedInputStream.connect(this._combinedStdOutStream);
        }
        catch (IOException e) {
            // empty catch block
        }
        this._debugInputStream = new PipedInputStream();
        try {
            this._debugOutputStream = new PipedOutputStream(this._debugInputStream);
            this._debugInputStream.connect(this._debugOutputStream);
        }
        catch (IOException e) {
            // empty catch block
        }
        this._combinedInputJoinedWithDebugStream = new JoinInputStream(this._combinedInputStream, this._debugInputStream);
        this._debugOutput = new PrintWriter(new OutputStreamWriter(this._debugOutputStream));
        this._combinedErrorStream = new PipedInputStream();
        try {
            this._combinedStdErrStream = new PipedOutputStream(this._combinedErrorStream);
            this._combinedErrorStream.connect(this._combinedStdErrStream);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (i = 0; i < this._processes.length; ++i) {
            try {
                this._processes[i] = this._creators[i].start();
                continue;
            }
            catch (IOException e) {
                GeneralProcessCreator.LOG.log("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
                this._debugOutput.println("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
                this._debugOutput.flush();
                this._aborted = true;
                this.destroy();
                return;
            }
        }
        for (i = 0; i < this._processes.length - 1; ++i) {
            StreamRedirectThread r = new StreamRedirectThread("stdout Redirector " + i, this._processes[i].getInputStream(), this._processes[i + 1].getOutputStream(), new ProcessChainThreadGroup(this));
            this._redirectors.add(r);
            r.start();
            r = new StreamRedirectThread("stderr Redirector " + i, this._processes[i].getErrorStream(), this._processes[i + 1].getOutputStream(), new ProcessChainThreadGroup(this));
            this._redirectors.add(r);
            r.start();
        }
        StreamRedirectThread r = new StreamRedirectThread("stdout Redirector " + (this._processes.length - 1), this._processes[this._processes.length - 1].getInputStream(), (OutputStream)this._combinedStdOutStream, new ProcessChainThreadGroup(this));
        this._redirectors.add(r);
        r.start();
        r = new StreamRedirectThread("stderr Redirector " + (this._processes.length - 1), this._processes[this._processes.length - 1].getErrorStream(), (OutputStream)this._combinedStdErrStream, new ProcessChainThreadGroup(this));
        this._redirectors.add(r);
        r.start();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this._aborted) {
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
        }
        return new BufferedOutputStream(this._processes[0].getOutputStream());
    }

    @Override
    public InputStream getErrorStream() {
        return this._combinedErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this._combinedInputJoinedWithDebugStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this._aborted) {
            return -1;
        }
        int exitCode = 0;
        for (int i = 0; i < this._processes.length; ++i) {
            exitCode = this._processes[i].waitFor();
        }
        return exitCode;
    }

    @Override
    public int exitValue() {
        if (this._aborted) {
            return -1;
        }
        int exitCode = 0;
        for (int i = 0; i < this._processes.length; ++i) {
            exitCode = this._processes[i].exitValue();
        }
        return exitCode;
    }

    @Override
    public void destroy() {
        this._aborted = true;
        for (int i = 0; i < this._processes.length; ++i) {
            this._processes[i].destroy();
        }
        this.stopAllRedirectors();
    }

    protected void stopAllRedirectors() {
        for (StreamRedirectThread r : this._redirectors) {
            r.setStopFlag();
        }
        this._redirectors.clear();
    }

    protected static class ProcessChainThreadGroup
    extends ThreadGroup {
        private ProcessChain _chain;
        private PrintWriter _debugOut;

        public ProcessChainThreadGroup(ProcessChain chain) {
            super("Process Chain Thread Group");
            this._chain = chain;
            this._debugOut = this._chain._debugOutput;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.destroy();
            if (e instanceof StreamRedirectException && e.getCause() instanceof IOException) {
                this._debugOut.println("\n\n\nAn exception occurred during the execution of the command line:\n" + e.toString() + "\n\n");
            } else {
                DrJavaErrorHandler.record(e);
            }
        }
    }
}

