/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.concurrent.StateMonitor;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

public abstract class AbstractMasterJVM
implements MasterRemote {
    private final StateMonitor<State> _monitor = new StateMonitor<State>(State.FRESH);
    private final SlaveFactory _slaveFactory;
    private final LazyThunk<MasterRemote> _masterStub;
    private volatile SlaveRemote _slave;

    protected AbstractMasterJVM(String slaveClassName) {
        this._slaveFactory = new SlaveFactory(slaveClassName);
        this._masterStub = new LazyThunk<MasterRemote>(new Thunk<MasterRemote>(){

            @Override
            public MasterRemote value() {
                try {
                    return (MasterRemote)UnicastRemoteObject.exportObject((Remote)AbstractMasterJVM.this, 0);
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    throw new UnexpectedException(re);
                }
            }
        });
        this._slave = null;
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
    }

    protected abstract void handleSlaveConnected(SlaveRemote var1);

    protected abstract void handleSlaveQuit(int var1);

    protected abstract void handleSlaveWontStart(Exception var1);

    protected final void invokeSlave(JVMBuilder jvmBuilder) {
        this.transition(State.FRESH, State.STARTING);
        Map<String, String> props = ConcurrentUtil.getPropertiesAsMap("plt.", "drjava.", "edu.rice.cs.");
        if (!props.containsKey("plt.log.working.dir") && (props.containsKey("plt.debug.log") || props.containsKey("plt.error.log") || props.containsKey("plt.log.factory"))) {
            props.put("plt.log.working.dir", System.getProperty("user.dir", ""));
        }
        JVMBuilder tweakedJVMBuilder = jvmBuilder.properties(CollectUtil.union(props, jvmBuilder.properties()));
        SlaveRemote newSlave = null;
        try {
            DebugUtil.debug.logStart("invoking remote JVM process");
            newSlave = (SlaveRemote)ConcurrentUtil.exportInProcess(this._slaveFactory, tweakedJVMBuilder, (Runnable1<? super Process>)new Runnable1<Process>(){

                @Override
                public void run(Process p) {
                    DebugUtil.debug.log("Remote JVM quit");
                    AbstractMasterJVM.this._monitor.set(State.FRESH);
                    DebugUtil.debug.logStart("handleSlaveQuit");
                    AbstractMasterJVM.this.handleSlaveQuit(p.exitValue());
                    DebugUtil.debug.logEnd("handleSlaveQuit");
                }
            });
            DebugUtil.debug.logEnd("invoking remote JVM process");
        }
        catch (Exception e) {
            DebugUtil.debug.log(e);
            DebugUtil.debug.logEnd("invoking remote JVM process (failed)");
            this._monitor.set(State.FRESH);
            this.handleSlaveWontStart(e);
        }
        if (newSlave != null) {
            try {
                newSlave.start(this._masterStub.value());
            }
            catch (RemoteException e) {
                DebugUtil.debug.log(e);
                AbstractMasterJVM.attemptQuit(newSlave);
                this._monitor.set(State.FRESH);
                this.handleSlaveWontStart(e);
                return;
            }
            this.handleSlaveConnected(newSlave);
            this._slave = newSlave;
            this._monitor.set(State.RUNNING);
        }
    }

    protected final void quitSlave() {
        this.transition(State.RUNNING, State.QUITTING);
        AbstractMasterJVM.attemptQuit(this._slave);
        this._slave = null;
        this._monitor.set(State.FRESH);
    }

    private static void attemptQuit(SlaveRemote slave) {
        try {
            slave.quit();
        }
        catch (RemoteException e) {
            DebugUtil.error.log("Unable to complete slave.quit()", e);
        }
    }

    protected void dispose() {
        this.transition(State.FRESH, State.DISPOSED);
        if (this._masterStub.isResolved()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException e) {
                DebugUtil.error.log(e);
            }
        }
    }

    private void transition(State from, State to2) {
        State s = this._monitor.value();
        while (!s.equals((Object)from) || !this._monitor.compareAndSet(from, to2)) {
            if (s.equals((Object)State.DISPOSED)) {
                throw new IllegalStateException("In disposed state");
            }
            DebugUtil.debug.log("Waiting for transition from " + (Object)((Object)s) + " to " + (Object)((Object)from));
            try {
                s = this._monitor.ensureNotState(s);
            }
            catch (InterruptedException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    protected boolean isDisposed() {
        return this._monitor.value().equals((Object)State.DISPOSED);
    }

    @Override
    public void checkStillAlive() {
    }

    private static class SlaveFactory
    implements Thunk<AbstractSlaveJVM>,
    Serializable {
        private final String _className;

        public SlaveFactory(String className) {
            this._className = className;
        }

        @Override
        public AbstractSlaveJVM value() {
            try {
                return (AbstractSlaveJVM)ReflectUtil.getStaticField(this._className, "ONLY");
            }
            catch (ReflectException e) {
                try {
                    return (AbstractSlaveJVM)ReflectUtil.loadObject(this._className, new Object[0]);
                }
                catch (ReflectException e2) {
                    throw new WrappedException(e2);
                }
            }
        }
    }

    private static enum State {
        FRESH,
        STARTING,
        RUNNING,
        QUITTING,
        DISPOSED;

    }
}

