/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.Utilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    private static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private static final String[] SIZES = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "27", "30", "34", "39", "45", "51", "60"};
    private NwList _styleList;
    private NwList _fontList;
    private NwList _sizeList;
    private JButton _okButton;
    private JButton _cancelButton;
    private JLabel _sampleText = new JLabel();
    private boolean _clickedOK = false;

    private FontChooser(Frame parent, Font font) {
        super(parent, true);
        this.initAll();
        if (font == null) {
            font = this._sampleText.getFont();
        }
        this._fontList.setSelectedItem(font.getName());
        this._sizeList.setSelectedItem(font.getSize() + "");
        this._styleList.setSelectedItem(STYLES[font.getStyle()]);
    }

    public static Font showDialog(Frame parent, String title, Font font) {
        FontChooser fd = new FontChooser(parent, font);
        fd.setTitle(title);
        Utilities.setPopupLoc(fd, parent);
        fd.setVisible(true);
        Font chosenFont = null;
        if (fd.clickedOK()) {
            chosenFont = fd.getFont();
        }
        fd.dispose();
        return chosenFont;
    }

    public static Font showDialog(Frame parent, Font font) {
        return FontChooser.showDialog(parent, "Font Chooser", font);
    }

    private void initAll() {
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._fontList = new NwList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        cpLayout.setConstraints(this._fontList, c);
        cp.add(this._fontList);
        c.fill = 3;
        c.anchor = 11;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.3;
        c.weighty = 1.0;
        this._styleList = new NwList(STYLES);
        cpLayout.setConstraints(this._styleList, c);
        cp.add(this._styleList);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.3;
        c.weighty = 1.0;
        this._sizeList = new NwList(SIZES);
        cpLayout.setConstraints(this._sizeList, c);
        cp.add(this._sizeList);
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._sampleText = new JLabel();
        this._sampleText.setForeground(Color.black);
        cpLayout.setConstraints(this._sampleText, c);
        cp.add(this._sampleText);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        this._okButton = new JButton("OK");
        this._cancelButton = new JButton("Cancel");
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this._clickedOK = true;
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this._clickedOK = false;
            }
        });
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 20;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FontChooser.this.setVisible(false);
            }
        });
        this.setSize(425, 400);
    }

    private void showSample() {
        int g = 0;
        try {
            g = Integer.parseInt(this._sizeList.getSelectedValue());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String st = this._styleList.getSelectedValue();
        int s = 0;
        if (st.equalsIgnoreCase("Bold")) {
            s = 1;
        }
        if (st.equalsIgnoreCase("Italic")) {
            s = 2;
        }
        if (st.equalsIgnoreCase("Bold Italic")) {
            s = 3;
        }
        this._sampleText.setFont(new Font(this._fontList.getSelectedValue(), s, g));
        this._sampleText.setText("The quick brown fox jumped over the lazy dog.");
        this._sampleText.setVerticalAlignment(1);
    }

    public boolean clickedOK() {
        return this._clickedOK;
    }

    @Override
    public Font getFont() {
        return this._sampleText.getFont();
    }

    public class NwList
    extends JPanel {
        JList<String> jl;
        JScrollPane sp;
        JLabel jt;
        String si = " ";

        public NwList(String[] values) {
            GridBagLayout cpLayout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(cpLayout);
            this.jl = new JList<String>(values);
            this.sp = new JScrollPane(this.jl);
            this.jt = new JLabel();
            this.jt.setBackground(Color.white);
            this.jt.setForeground(Color.black);
            this.jt.setOpaque(true);
            this.jt.setBorder(new JTextField().getBorder());
            this.jt.setFont(this.getFont());
            this.jl.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    NwList.this.si = NwList.this.jl.getSelectedValue();
                    NwList.this.jt.setText(NwList.this.si);
                    FontChooser.this.showSample();
                }
            });
            c.fill = 2;
            c.anchor = 11;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            cpLayout.setConstraints(this.jt, c);
            this.add(this.jt);
            c.fill = 1;
            c.anchor = 11;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            cpLayout.setConstraints(this.sp, c);
            this.add(this.sp);
        }

        public String getSelectedValue() {
            return this.si;
        }

        public void setSelectedItem(String s) {
            this.jl.setSelectedValue(s, true);
        }
    }
}

