/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.ContinueTarget;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForSlashEachStatement;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends ForSlashEachStatement
implements ContinueTarget {
    private List<Node> initialization;
    private Expression condition;
    private List<Node> update;
    private Node body;
    private List<String> labels;

    public ForStatement(List<Node> init, Expression cond, List<Node> updt, Node body) {
        this(init, cond, updt, body, SourceInfo.NONE);
    }

    public ForStatement(List<Node> init, Expression cond, List<Node> updt, Node body, SourceInfo si) {
        super(si);
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.initialization = init;
        this.condition = cond;
        this.update = updt;
        this.body = body;
        this.labels = new LinkedList<String>();
    }

    public List<Node> getInitialization() {
        return this.initialization;
    }

    public void setInitialization(List<Node> l) {
        this.initialization = l;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression e) {
        this.condition = e;
    }

    public List<Node> getUpdate() {
        return this.update;
    }

    public void setUpdate(List<Node> l) {
        this.update = l;
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.body = node;
    }

    @Override
    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        this.labels.add(label);
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getInitialization() + " " + this.getCondition() + " " + this.getUpdate() + " " + this.getBody() + ")";
    }
}

