/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import koala.dynamicjava.tree.Annotation;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierSet
extends Node {
    private final Set<Modifier> flags;
    private final List<Annotation> annotations;

    public ModifierSet(Set<Modifier> flgs, List<Annotation> annots) {
        this(flgs, annots, SourceInfo.NONE);
    }

    public ModifierSet(Set<Modifier> flgs, List<Annotation> annots, SourceInfo si) {
        super(si);
        this.flags = flgs;
        this.annotations = annots;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public Set<Modifier> getFlags() {
        return this.flags;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public int getBitVector(Modifier ... forced) {
        int result = 0;
        for (Modifier m : this.flags) {
            result |= m.getBits();
        }
        for (Modifier m : forced) {
            result |= m.getBits();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.annotations.isEmpty();
    }

    public boolean isPublic() {
        return this.flags.contains((Object)Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return this.flags.contains((Object)Modifier.PRIVATE);
    }

    public boolean isProtected() {
        return this.flags.contains((Object)Modifier.PROTECTED);
    }

    public boolean isStatic() {
        return this.flags.contains((Object)Modifier.STATIC);
    }

    public boolean isFinal() {
        return this.flags.contains((Object)Modifier.FINAL);
    }

    public boolean isAbstract() {
        return this.flags.contains((Object)Modifier.ABSTRACT);
    }

    public boolean isVolatile() {
        return this.flags.contains((Object)Modifier.VOLATILE);
    }

    public boolean isTransient() {
        return this.flags.contains((Object)Modifier.TRANSIENT);
    }

    public boolean isSynchronized() {
        return this.flags.contains((Object)Modifier.SYNCHRONIZED);
    }

    public boolean isNative() {
        return this.flags.contains((Object)Modifier.NATIVE);
    }

    public boolean isStrict() {
        return this.flags.contains((Object)Modifier.STRICT);
    }

    public boolean isInterface() {
        return this.flags.contains((Object)Modifier.INTERFACE);
    }

    public boolean isAnnotation() {
        return this.flags.contains((Object)Modifier.ANNOTATION);
    }

    public boolean isEnum() {
        return this.flags.contains((Object)Modifier.ENUM);
    }

    public boolean isBridge() {
        return this.flags.contains((Object)Modifier.BRIDGE);
    }

    public boolean isVarargs() {
        return this.flags.contains((Object)Modifier.VARARGS);
    }

    public boolean isSynthetic() {
        return this.flags.contains((Object)Modifier.SYNTHETIC);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.flags + ", " + this.annotations + ")";
    }

    public static ModifierSet make() {
        return new ModifierSet(EnumSet.noneOf(Modifier.class), new LinkedList<Annotation>());
    }

    public static ModifierSet make(Modifier mod, Modifier ... mods) {
        return new ModifierSet(EnumSet.of(mod, mods), new LinkedList<Annotation>());
    }

    public static ModifierSet make(Annotation ann, Annotation ... anns) {
        LinkedList<Annotation> l = new LinkedList<Annotation>();
        l.add(ann);
        for (Annotation a : anns) {
            l.add(a);
        }
        return new ModifierSet(EnumSet.noneOf(Modifier.class), l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modifier {
        PUBLIC{

            public int getBits() {
                return 1;
            }

            public String getName() {
                return "public";
            }
        }
        ,
        PRIVATE{

            public int getBits() {
                return 2;
            }

            public String getName() {
                return "private";
            }
        }
        ,
        PROTECTED{

            public int getBits() {
                return 4;
            }

            public String getName() {
                return "protected";
            }
        }
        ,
        STATIC{

            public int getBits() {
                return 8;
            }

            public String getName() {
                return "static";
            }
        }
        ,
        FINAL{

            public int getBits() {
                return 16;
            }

            public String getName() {
                return "final";
            }
        }
        ,
        ABSTRACT{

            public int getBits() {
                return 1024;
            }

            public String getName() {
                return "abstract";
            }
        }
        ,
        VOLATILE{

            public int getBits() {
                return 64;
            }

            public String getName() {
                return "volatile";
            }
        }
        ,
        TRANSIENT{

            public int getBits() {
                return 128;
            }

            public String getName() {
                return "transient";
            }
        }
        ,
        SYNCHRONIZED{

            public int getBits() {
                return 32;
            }

            public String getName() {
                return "synchronized";
            }
        }
        ,
        NATIVE{

            public int getBits() {
                return 256;
            }

            public String getName() {
                return "native";
            }
        }
        ,
        STRICT{

            public int getBits() {
                return 2048;
            }

            public String getName() {
                return "strictfp";
            }
        }
        ,
        INTERFACE{

            public int getBits() {
                return 512;
            }

            public String getName() {
                return "[interface]";
            }
        }
        ,
        ANNOTATION{

            public int getBits() {
                return 8192;
            }

            public String getName() {
                return "[annotation]";
            }
        }
        ,
        ENUM{

            public int getBits() {
                return 16384;
            }

            public String getName() {
                return "[enum]";
            }
        }
        ,
        BRIDGE{

            public int getBits() {
                return 64;
            }

            public String getName() {
                return "[bridge]";
            }
        }
        ,
        VARARGS{

            public int getBits() {
                return 128;
            }

            public String getName() {
                return "[varargs]";
            }
        }
        ,
        SYNTHETIC{

            public int getBits() {
                return 4096;
            }

            public String getName() {
                return "[synthetic]";
            }
        };


        public abstract int getBits();

        public abstract String getName();
    }
}

