/*
 * Decompiled with CFR 0.152.
 */
package contrib.net.xoetrope.editor.color;

import contrib.net.xoetrope.editor.color.ModelColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorWheelPanel
extends AbstractColorChooserPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
ChangeListener {
    public static final int MONOCHROMATIC_SCHEME = 0;
    public static final int CONTRASTING_SCHEME = 1;
    public static final int SOFT_CONTRAST_SCHEME = 2;
    public static final int DOUBLE_CONTRAST_SCHEME = 3;
    public static final int ANALOGIC_SCHEME = 4;
    protected JTextField hueEdit;
    protected JTextField satEdit;
    protected JTextField brightEdit;
    protected JTextField baseColorEdit;
    protected BufferedImage pickerImage;
    protected ColorWheel imagePicker;
    protected JPanel fixedPanel;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected JSlider brightnessSlider;
    protected JSlider saturationSlider;
    protected JLabel baseColorLabel;
    protected Ellipse2D innerCircle;
    protected Ellipse2D outerCircle;
    protected Ellipse2D borderCircle;
    protected JCheckBox useWebColors;
    protected JCheckBox decimalRGB;
    protected Font font9pt;
    protected ModelColor chooserColor;
    protected ModelColor[] selectedIttenColours;
    private float[] values = new float[3];
    private double h;
    private double s;
    private double b;
    private int colorScheme = 0;
    private boolean useComplement;
    private boolean busy = false;
    private boolean displayScheme = false;
    private boolean hasChooser = false;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private static double[] arcDelta = new double[]{-7.5, -7.5, -7.5, -7.5, -7.5, -1.0, 4.0, 7.5};
    private double ringThickness;
    private GeneralPath[] paths;
    private static ResourceBundle labelBundle;
    private GeneralPath rolloverPath;
    private GeneralPath selectedPath;
    private boolean showRollovers;
    private Color rolloverColor;
    private Color selectedColor;
    private String fontFamily;

    public ColorWheelPanel() {
        this.font9pt = UIManager.getFont("ColorChooser.smallFont");
        if (this.font9pt == null) {
            this.font9pt = new Font("Arial", 0, 9);
        }
        this.fontFamily = this.font9pt.getFamily();
        this.showRollovers = true;
        this.innerCircle = new Ellipse2D.Double(96.0, 96.0, 36.0, 36.0);
        this.outerCircle = new Ellipse2D.Double(6.0, 6.0, 214.0, 214.0);
        this.borderCircle = new Ellipse2D.Double(0.0, 0.0, 227.0, 227.0);
        this.fixedPanel = new JPanel();
        this.fixedPanel.setLayout(null);
        this.fixedPanel.setOpaque(false);
        this.fixedPanel.setBackground(Color.white);
        this.fixedPanel.setBounds(0, 0, 255, 328);
        this.fixedPanel.setPreferredSize(new Dimension(255, 328));
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public void layoutContainer(Container parent) {
                Dimension fpp = ColorWheelPanel.this.fixedPanel.getPreferredSize();
                int dx = (parent.getWidth() - fpp.width) / 2;
                int dy = (parent.getHeight() - fpp.height) / 2;
                ColorWheelPanel.this.fixedPanel.setBounds(dx, dy, fpp.width, fpp.height);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            public Dimension preferredLayoutSize(Container parent) {
                return ColorWheelPanel.this.fixedPanel.getPreferredSize();
            }
        });
        this.imagePicker = new ColorWheel();
        this.imagePicker.setBounds(0, 0, 228, 228);
        this.imagePicker.addMouseListener(this);
        this.imagePicker.addMouseMotionListener(this);
        this.imagePicker.setOpaque(false);
        this.fixedPanel.add(this.imagePicker);
        this.brightnessSlider = new JSlider(1);
        this.brightnessSlider.setBounds(230, 0, 25, 110);
        this.brightnessSlider.setMinimum(0);
        this.brightnessSlider.setMaximum(100);
        this.brightnessSlider.setValue(100);
        this.brightnessSlider.setOpaque(false);
        this.brightnessSlider.setBackground(Color.white);
        this.brightnessSlider.setPaintLabels(true);
        this.brightnessSlider.addChangeListener(this);
        this.fixedPanel.add(this.brightnessSlider);
        this.saturationSlider = new JSlider(1);
        this.saturationSlider.setBounds(230, 118, 25, 110);
        this.saturationSlider.setMinimum(0);
        this.saturationSlider.setMaximum(100);
        this.saturationSlider.setValue(100);
        this.saturationSlider.setOpaque(false);
        this.saturationSlider.setBackground(Color.white);
        this.saturationSlider.setInverted(true);
        this.saturationSlider.setPaintLabels(true);
        this.saturationSlider.addChangeListener(this);
        this.fixedPanel.add(this.saturationSlider);
        this.useWebColors = new JCheckBox(ColorWheelPanel.getLabel("Xoetrope.webSafeColors", "Use web safe colors"));
        this.useWebColors.setBounds(8, 248, 160, 18);
        this.useWebColors.addActionListener(this);
        this.useWebColors.setOpaque(false);
        this.useWebColors.setFont(this.font9pt);
        this.fixedPanel.add(this.useWebColors);
        this.decimalRGB = new JCheckBox(ColorWheelPanel.getLabel("Xoetrope.decimalRGB", "Decimal RGB"));
        this.decimalRGB.setBounds(176, 248, 85, 18);
        this.decimalRGB.addActionListener(this);
        this.decimalRGB.setOpaque(false);
        this.decimalRGB.setFont(this.font9pt);
        this.fixedPanel.add(this.decimalRGB);
        this.baseColorLabel = new JLabel();
        this.baseColorLabel.setBounds(10, 268, 160, 18);
        this.baseColorLabel.setBackground(Color.red);
        this.baseColorLabel.setOpaque(true);
        this.fixedPanel.add(this.baseColorLabel);
        this.baseColorEdit = new JTextField();
        this.baseColorEdit.setBounds(180, 268, 75, 18);
        this.baseColorEdit.setOpaque(true);
        this.fixedPanel.add(this.baseColorEdit);
        this.baseColorEdit.addActionListener(this);
        this.hueEdit = new JTextField();
        this.hueEdit.setBounds(10, 288, 75, 20);
        this.fixedPanel.add(this.hueEdit);
        this.hueEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.hueEdit));
        JLabel hueLabel = new JLabel(ColorWheelPanel.getLabel("Xoetrope.hue", "Hue") + "\u00b0");
        hueLabel.setBounds(10, 308, 75, 20);
        hueLabel.setFont(this.font9pt);
        this.fixedPanel.add(hueLabel);
        this.satEdit = new JTextField();
        this.satEdit.setBounds(95, 288, 75, 20);
        this.fixedPanel.add(this.satEdit);
        this.satEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.satEdit));
        JLabel satLabel = new JLabel(ColorWheelPanel.getLabel("Xoetrope.saturation", "Saturation") + " %");
        satLabel.setBounds(95, 308, 75, 20);
        satLabel.setFont(this.font9pt);
        this.fixedPanel.add(satLabel);
        this.brightEdit = new JTextField();
        this.brightEdit.setBounds(180, 288, 75, 20);
        this.fixedPanel.add(this.brightEdit);
        this.brightEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.brightEdit));
        JLabel brightLabel = new JLabel(ColorWheelPanel.getLabel("Xoetrope.brightness", "Brightness") + " %");
        brightLabel.setBounds(180, 308, 75, 20);
        brightLabel.setFont(this.font9pt);
        this.fixedPanel.add(brightLabel);
        this.add(this.fixedPanel);
    }

    public void setSelectedColors(ModelColor[] clrs) {
        this.selectedIttenColours = clrs;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public boolean useDecimalRGB() {
        return this.decimalRGB.isSelected();
    }

    public boolean useWebColors() {
        return this.useWebColors.isSelected();
    }

    public void setDisplayScheme(boolean disp) {
        this.displayScheme = disp;
    }

    public int getHue() {
        try {
            return Integer.parseInt(this.hueEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public int getSaturation() {
        try {
            return Integer.parseInt(this.satEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public int getBrightness() {
        try {
            return Integer.parseInt(this.brightEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public void setColorScheme(int scheme) {
        this.colorScheme = scheme;
    }

    private void setUseComplement(boolean useComp) {
        this.useComplement = useComp;
    }

    boolean moveHue(Point pt) {
        if (this.borderCircle.contains(pt) && !this.outerCircle.contains(pt) || this.innerCircle.contains(pt)) {
            int h = this.getAngle(pt);
            this.hueEdit.setText(Integer.toString(h));
            this.selectedPath = null;
            this.resetColor();
            return true;
        }
        return false;
    }

    private int getAngle(Point pt) {
        int eX = pt.x > 0 ? pt.x : 96;
        int eY = pt.y > 0 ? pt.y : 96;
        int x = eX - 112;
        int y = eY - 114;
        return (int)Math.round((Math.atan2(-x, y) * 180.0 / Math.PI + 180.0) % 360.0);
    }

    public void setColor(Color c) {
        if (c != null) {
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            if (this.useWebColors.isSelected()) {
                r = Math.round(r / 51) * 51;
                g = Math.round(g / 51) * 51;
                b = Math.round(b / 51) * 51;
            }
            this.chooserColor = new ModelColor(r, g, b);
        }
        c = new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B);
        this.values = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.values);
        this.h = this.values[0];
        this.s = this.values[1];
        this.b = this.values[2];
        this.h = Math.min(Math.max(this.h, 0.0), 1.0);
        this.s = Math.min(Math.max(this.s, 0.0), 1.0);
        this.b = Math.min(Math.max(this.b, 0.0), 1.0);
        this.setHue();
        this.setSaturation();
        this.setBrightness();
        this.busy = true;
        this.brightnessSlider.setValue(Integer.parseInt(this.brightEdit.getText()));
        this.saturationSlider.setValue(Integer.parseInt(this.satEdit.getText()));
        this.busy = false;
        this.baseColorLabel.setBackground(new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B));
        if (0.5 * (double)c.getRed() + (double)c.getGreen() + 0.3 * (double)c.getBlue() < 220.0) {
            this.baseColorLabel.setForeground(Color.white);
        } else {
            this.baseColorLabel.setForeground(Color.black);
        }
        String colorStr = this.decimalRGB.isSelected() ? " " + Integer.toString(c.getRed()) + "." + Integer.toString(c.getGreen()) + "." + Integer.toString(c.getBlue()) : " " + ModelColor.toHexString(c.getRed()) + ModelColor.toHexString(c.getGreen()) + ModelColor.toHexString(c.getBlue());
        this.baseColorLabel.setText(colorStr);
        this.baseColorEdit.setText(colorStr);
        ChangeEvent evt = new ChangeEvent(this);
        int numListeners = this.changeListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            ChangeListener l = this.changeListeners.get(i);
            l.stateChanged(evt);
        }
        if (this.hasChooser) {
            this.getColorSelectionModel().setSelectedColor(c);
        }
    }

    public Color getColor() {
        return new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B);
    }

    public ModelColor getChooserColour() {
        return this.chooserColor;
    }

    private void setHue() {
        this.hueEdit.setText(Integer.toString(this.chooserColor.getHue()));
    }

    private void setSaturation() {
        this.satEdit.setText(Integer.toString((int)(100.0 * this.chooserColor.S)));
    }

    private void setBrightness() {
        this.brightEdit.setText(Integer.toString((int)(100.0 * this.chooserColor.V)));
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useWebColors) {
            boolean snap = this.useWebColors.isSelected();
            this.chooserColor.setWebSnap(snap);
            if (snap) {
                this.resetColor();
            } else {
                source = this.baseColorEdit;
            }
        }
        if (source == this.baseColorEdit) {
            String hex = this.baseColorEdit.getText().trim();
            if (hex.length() == 0) {
                this.resetColor();
            } else if (this.decimalRGB.isSelected()) {
                int pos = 0;
                try {
                    int r = 255;
                    int g = 0;
                    int b = 0;
                    int pos2 = hex.indexOf(46, pos);
                    if (pos2 > 0) {
                        r = Integer.parseInt(hex.substring(pos, pos2));
                        ++pos2;
                        pos = pos2;
                        if ((pos2 = hex.indexOf(46, pos)) > 0) {
                            g = Integer.parseInt(hex.substring(pos, pos2));
                            pos = ++pos2;
                            if (pos2 < hex.length()) {
                                b = Integer.parseInt(hex.substring(pos));
                            }
                        }
                    }
                    this.setColor(new Color(r, g, b));
                }
                catch (NumberFormatException nfe) {
                    this.setColor(Color.red);
                    this.baseColorEdit.setText("255.0.0");
                }
            } else {
                for (int i = hex.length(); i < 6; ++i) {
                    hex = hex + "0";
                }
                try {
                    this.setColor(new Color(ModelColor.hex2dec(hex.substring(0, 2)), ModelColor.hex2dec(hex.substring(2, 4)), ModelColor.hex2dec(hex.substring(4, 6))));
                }
                catch (NumberFormatException nfe) {
                    this.setColor(Color.red);
                    this.baseColorEdit.setText("FF0000");
                }
            }
        } else {
            this.resetColor();
        }
    }

    private void resetColor() {
        if (this.chooserColor != null) {
            if (!this.busy) {
                this.busy = true;
                int h = 0;
                try {
                    h = Integer.parseInt(this.hueEdit.getText());
                    this.selectedPath = null;
                }
                catch (NumberFormatException nfe) {
                    this.hueEdit.setText("0");
                }
                if (h >= 360) {
                    this.hueEdit.setText(Integer.toString(h %= 360));
                }
                if (h < 0) {
                    h = (int)(((double)h + (Math.floor(-h / 360) + 1.0) * 360.0) % 360.0);
                    this.hueEdit.setText(Integer.toString(h));
                }
                double s = 1.0;
                try {
                    s = (double)Integer.parseInt(this.satEdit.getText()) / 100.0;
                }
                catch (NumberFormatException nfe) {
                    this.satEdit.setText("100");
                }
                if (s > 1.0 || s < 0.0) {
                    s = s < 0.0 ? 0.0 : 1.0;
                    this.satEdit.setText(Integer.toString((int)(s * 100.0)));
                }
                double v = 1.0;
                try {
                    v = (double)Integer.parseInt(this.brightEdit.getText()) / 100.0;
                }
                catch (NumberFormatException nfe) {
                    this.brightEdit.setText("100");
                }
                if (v > 1.0 || v < 0.0) {
                    v = v < 0.0 ? 0.0 : 1.0;
                    this.brightEdit.setText(Integer.toString((int)(v * 100.0)));
                }
                if (this.selectedIttenColours != null) {
                    this.selectedIttenColours[0].setHSV(h, s, v);
                }
                this.chooserColor.setHSV(h, s, v);
                this.busy = false;
            }
            this.setColor(null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Point pt;
        Object src = e.getSource();
        if (src == this.imagePicker && this.borderCircle.contains(pt = e.getPoint())) {
            this.selectedColor = this.rolloverColor;
            this.selectedPath = this.rolloverPath;
            if (!this.moveHue(pt) && this.outerCircle.contains(pt)) {
                int width = this.imagePicker.getWidth();
                int center = width / 2;
                int dx = Math.abs(pt.x - center);
                int dy = Math.abs(pt.y - center);
                double dr = Math.pow(dx * dx + dy * dy, 0.5);
                int bandIdx = (int)((dr -= this.ringThickness * 1.5) / this.ringThickness);
                int hue = 0;
                int bandOffset = bandIdx * 24;
                for (int i = 0; i < 24; ++i) {
                    if (!this.paths[bandOffset + i].contains(pt)) continue;
                    hue = i * 15;
                }
                int hueInc = hue / 15 % 2;
                ModelColor mc = new ModelColor((double)hue, ModelColor.SATURATION_BANDS[bandIdx], ModelColor.BRIGHTNESS_BANDS[bandIdx + 1 - hueInc]);
                Color pixelColor = new Color(mc.getRed(), mc.getGreen(), mc.getBlue());
                if (!pixelColor.equals(Color.white)) {
                    this.setColor(pixelColor);
                }
            }
        }
        if (this.displayScheme) {
            this.imagePicker.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.imagePicker.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.rolloverPath = null;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        GeneralPath oldPath = this.rolloverPath;
        this.rolloverPath = null;
        Point pt = e.getPoint();
        int numPaths = this.paths.length;
        for (int i = 0; i < numPaths; ++i) {
            if (!this.paths[i].contains(pt.x, pt.y)) continue;
            this.rolloverPath = this.paths[i];
            ModelColor[][] baseColors = ModelColor.getBaseColors();
            int ring = i / 24;
            ModelColor modelColor = baseColors[i % 24][ring];
            this.rolloverColor = new Color(modelColor.getRed(), modelColor.getGreen(), modelColor.getBlue());
            if (ring < 4) {
                this.rolloverColor = this.rolloverColor.darker();
                break;
            }
            this.rolloverColor = this.rolloverColor.brighter().brighter();
            break;
        }
        if (this.rolloverPath != oldPath) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.saturationSlider) {
            this.satEdit.setText(Integer.toString(this.saturationSlider.getValue()));
            this.resetColor();
        } else if (source == this.brightnessSlider) {
            this.brightEdit.setText(Integer.toString(this.brightnessSlider.getValue()));
            this.resetColor();
        }
        if (this.hasChooser) {
            this.getColorSelectionModel().setSelectedColor(new Color(this.chooserColor.getRed(), this.chooserColor.getGreen(), this.chooserColor.getBlue()));
        }
    }

    protected void buildChooser() {
    }

    public String getDisplayName() {
        return "Xoetrope Color Wheel";
    }

    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorWheelIcon");
    }

    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    public Dimension getPreferredSize() {
        return new Dimension(255, 328);
    }

    public void updateChooser() {
        if (this.hasChooser) {
            Color selected = this.getColorFromModel();
            ModelColor selectedModelColor = new ModelColor(selected.getRed(), selected.getGreen(), selected.getBlue());
            this.setSelectedColors(new ModelColor[]{selectedModelColor});
            this.setColor(selected);
        }
    }

    public void installChooserPanel(JColorChooser enclosingChooser) {
        this.hasChooser = enclosingChooser != null;
        super.installChooserPanel(enclosingChooser);
        this.setDisplayScheme(true);
    }

    public static void setLabelBundle(ResourceBundle labelBundle) {
        ColorWheelPanel.labelBundle = labelBundle;
    }

    private static String getLabel(String labelName, String defaultValue) {
        if (labelBundle == null) {
            return defaultValue;
        }
        try {
            return labelBundle.getString(labelName);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    static /* synthetic */ GeneralPath[] access$202(ColorWheelPanel x0, GeneralPath[] x1) {
        x0.paths = x1;
        return x1;
    }

    private class ColorDocumentListener
    implements DocumentListener {
        private JTextField originator;
        private static final String MARKER = "Xoetrope.XUI.ColorWheel.DocumentEvent";

        public ColorDocumentListener(JTextField originator) {
            this.originator = originator;
        }

        public void insertUpdate(DocumentEvent evt) {
            this.synchronize(evt);
        }

        public void removeUpdate(DocumentEvent evt) {
            this.synchronize(evt);
        }

        public void changedUpdate(DocumentEvent evt) {
            this.synchronize(evt);
        }

        public void synchronize(DocumentEvent evt) {
            boolean _hasAllValues = true;
            if (ColorWheelPanel.this.hueEdit.getText().length() == 0) {
                _hasAllValues = false;
            }
            if (ColorWheelPanel.this.brightEdit.getText().length() == 0) {
                _hasAllValues = false;
            }
            if (ColorWheelPanel.this.satEdit.getText().length() == 0) {
                _hasAllValues = false;
            }
            final boolean hasAllValues = _hasAllValues;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ColorWheelPanel.this.useWebColors.setEnabled(hasAllValues);
                    ColorWheelPanel.this.decimalRGB.setEnabled(hasAllValues);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (hasAllValues && ColorDocumentListener.this.originator.hasFocus()) {
                        if (Boolean.TRUE.equals(ColorDocumentListener.this.originator.getClientProperty(ColorDocumentListener.MARKER))) {
                            ColorDocumentListener.this.originator.putClientProperty(ColorDocumentListener.MARKER, null);
                        } else {
                            ColorDocumentListener.this.originator.putClientProperty(ColorDocumentListener.MARKER, Boolean.TRUE);
                            ColorWheelPanel.this.resetColor();
                        }
                    }
                    if (ColorWheelPanel.this.displayScheme) {
                        ColorWheelPanel.this.imagePicker.repaint();
                    }
                }
            });
        }
    }

    class ColorWheel
    extends JLabel {
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintWheel((Graphics2D)g);
            if (ColorWheelPanel.this.displayScheme) {
                int selIdx = ColorWheelPanel.this.colorScheme;
                int numColours = Math.min(selIdx + 1, 4);
                for (int i = 0; i < numColours; ++i) {
                    double r = (ColorWheelPanel.this.selectedIttenColours[i].H - 90.0) / 360.0 * 2.0 * Math.PI;
                    double x = Math.round(111.0 + 110.0 * Math.cos(r));
                    double y = Math.round(111.0 + 110.0 * Math.sin(r));
                    g.setColor(Color.gray);
                    g.fillOval((int)x, (int)y, 4, 4);
                    g.setColor(Color.darkGray);
                    g.drawOval((int)x, (int)y, 4, 4);
                }
            }
        }

        public void paintWheel(Graphics2D g2d) {
            if (ColorWheelPanel.this.paths == null) {
                ColorWheelPanel.access$202(ColorWheelPanel.this, new GeneralPath[168]);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ModelColor[][] baseColors = ModelColor.getBaseColors();
            int idx = 0;
            double width = this.getWidth() - 1;
            double center = width / 2.0;
            ColorWheelPanel.this.ringThickness = width / 18.0;
            double fontHeight = ColorWheelPanel.this.ringThickness / 2.0;
            double inset = ColorWheelPanel.this.ringThickness / 2.0;
            g2d.setColor(new Color(228, 228, 228));
            Arc2D.Double innerArc = new Arc2D.Double(inset, inset, width - inset - inset, width - inset - inset, 0.0, 360.0, 0);
            Arc2D.Double outerArc = new Arc2D.Double(0.0, 0.0, width, width, 360.0, -360.0, 0);
            GeneralPath gp = new GeneralPath();
            gp.append(innerArc, true);
            gp.append(outerArc, true);
            gp.closePath();
            g2d.fill(gp);
            g2d.setColor(Color.black);
            g2d.setStroke(new BasicStroke(0.3f));
            g2d.draw(outerArc);
            g2d.setColor(new Color(255, 253, 220));
            innerArc = new Arc2D.Double(center - ColorWheelPanel.this.ringThickness / 2.0, center - ColorWheelPanel.this.ringThickness / 2.0, ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness, -30.0, 180.0, 0);
            outerArc = new Arc2D.Double(center - ColorWheelPanel.this.ringThickness, center - ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness * 2.0, ColorWheelPanel.this.ringThickness * 2.0, 150.0, -180.0, 0);
            gp = new GeneralPath();
            gp.append(innerArc, true);
            gp.append(outerArc, true);
            gp.closePath();
            g2d.fill(gp);
            g2d.setColor(new Color(202, 230, 252));
            innerArc = new Arc2D.Double(center - ColorWheelPanel.this.ringThickness / 2.0, center - ColorWheelPanel.this.ringThickness / 2.0, ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness, 150.0, 180.0, 0);
            outerArc = new Arc2D.Double(center - ColorWheelPanel.this.ringThickness, center - ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness * 2.0, ColorWheelPanel.this.ringThickness * 2.0, 330.0, -180.0, 0);
            gp = new GeneralPath();
            gp.append(innerArc, true);
            gp.append(outerArc, true);
            gp.closePath();
            g2d.fill(gp);
            g2d.setColor(Color.black);
            AffineTransform identityTransform = g2d.getTransform();
            AffineTransform at = (AffineTransform)identityTransform.clone();
            at.translate(center, center);
            at.rotate(0.5235987755982988);
            g2d.setTransform(at);
            gp = new GeneralPath();
            gp.moveTo((float)(-ColorWheelPanel.this.ringThickness / 2.0), 0.0f);
            gp.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), 0.0f);
            gp.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), (float)(-fontHeight));
            gp.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.4), (float)(-fontHeight + ColorWheelPanel.this.ringThickness * 0.2));
            gp.moveTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), (float)(-fontHeight));
            gp.lineTo((float)(-ColorWheelPanel.this.ringThickness), (float)(-fontHeight + ColorWheelPanel.this.ringThickness * 0.2));
            g2d.draw(gp);
            gp = new GeneralPath();
            gp.moveTo((float)(ColorWheelPanel.this.ringThickness / 2.0), 0.0f);
            gp.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.2), 0.0f);
            gp.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.2), (float)fontHeight);
            gp.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.4), (float)(fontHeight - ColorWheelPanel.this.ringThickness * 0.2));
            gp.moveTo((float)(ColorWheelPanel.this.ringThickness * 1.2), (float)fontHeight);
            gp.lineTo((float)ColorWheelPanel.this.ringThickness, (float)(fontHeight - ColorWheelPanel.this.ringThickness * 0.2));
            g2d.draw(gp);
            double r1 = center;
            double r2 = r1 - fontHeight;
            double r3 = r1 - ColorWheelPanel.this.ringThickness / 2.3;
            double r4 = r1 + ColorWheelPanel.this.ringThickness / 2.7;
            double inc = 0.2617993877991494;
            double fullArc = Math.PI * 2;
            g2d.setColor(Color.black);
            for (int i = 0; i < 24; ++i) {
                double angle = (double)i * inc;
                double sin = Math.sin(angle);
                double cos = Math.cos(angle);
                gp = new GeneralPath();
                if (width > 200.0 && i % 2 == 0) {
                    AttributedString as = new AttributedString("" + (i * 15 + 90) % 360 + "\u00b0");
                    as.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                    as.addAttribute(TextAttribute.SIZE, Float.valueOf((float)fontHeight));
                    as.addAttribute(TextAttribute.FOREGROUND, Color.black);
                    at = (AffineTransform)identityTransform.clone();
                    at.translate(center + fontHeight / 5.0 + r3 * cos, center + r3 * sin);
                    at.rotate(angle + 1.5707963267948966);
                    g2d.setTransform(at);
                    g2d.drawString(as.getIterator(), 0.0f, 0.0f);
                    continue;
                }
                g2d.setTransform(identityTransform);
                gp.moveTo((float)(center + r1 * cos), (float)(center + r1 * sin));
                gp.lineTo((float)(center + r2 * cos), (float)(center + r2 * sin));
                g2d.draw(gp);
            }
            boolean pathIdx = false;
            for (int i = 0; i < 7; ++i) {
                double outerX = inset + (double)(7 - (i + 1)) * ColorWheelPanel.this.ringThickness;
                double outerW = width - outerX - outerX;
                double innerX = outerX + ColorWheelPanel.this.ringThickness;
                double innerW = outerW - 2.0 * ColorWheelPanel.this.ringThickness;
                for (int j = 0; j < 24; ++j) {
                    ModelColor modelColor = baseColors[j][i];
                    Color c = new Color(modelColor.getRed(), modelColor.getGreen(), modelColor.getBlue());
                    g2d.setColor(c);
                    double startAngle = (82.5 - (double)j * 15.0 + 360.0) % 360.0;
                    double delta1 = j % 2 == 0 ? arcDelta[i] : -arcDelta[i];
                    double delta2 = j % 2 == 0 ? arcDelta[i + 1] : -arcDelta[i + 1];
                    innerArc = new Arc2D.Double(innerX, innerX, innerW, innerW, startAngle + delta1, 15.0 - 2.0 * delta1, 0);
                    outerArc = new Arc2D.Double(outerX, outerX, outerW, outerW, startAngle + 15.0 - delta2, -15.0 + 2.0 * delta2, 0);
                    gp = new GeneralPath();
                    gp.append(innerArc, true);
                    gp.append(outerArc, true);
                    gp.closePath();
                    g2d.fill(gp);
                    ((ColorWheelPanel)ColorWheelPanel.this).paths[idx++] = gp;
                }
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (width > 200.0) {
                double angle = -1.0471975511965979;
                double angle2 = angle - 0.055;
                double sin = Math.sin(angle2);
                double cos = Math.cos(angle2);
                AttributedString as = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.warm", "WARM"));
                as.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                as.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.5)));
                as.addAttribute(TextAttribute.FOREGROUND, new Color(92, 0, 0));
                at = (AffineTransform)identityTransform.clone();
                at.translate(center + fontHeight / 5.0 + r4 * cos, center + r4 * sin);
                at.rotate(angle + 1.5707963267948966 + 0.05);
                g2d.setTransform(at);
                g2d.drawString(as.getIterator(), 0.0f, 0.0f);
                sin = Math.sin(angle += Math.PI);
                cos = Math.cos(angle);
                as = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.cold", "COLD"));
                as.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                as.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.5)));
                as.addAttribute(TextAttribute.FOREGROUND, new Color(0, 0, 92));
                at = (AffineTransform)identityTransform.clone();
                at.translate(center + fontHeight / 5.0 + r4 * cos, center + r4 * sin);
                at.rotate(angle + 1.5707963267948966 + 0.05);
                g2d.setTransform(at);
                g2d.drawString(as.getIterator(), 0.0f, 0.0f);
                angle = Math.PI;
                sin = Math.sin(angle);
                cos = Math.cos(angle);
                as = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.saturation", "Saturation"));
                as.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                as.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.3)));
                as.addAttribute(TextAttribute.FOREGROUND, Color.black);
                at = (AffineTransform)identityTransform.clone();
                at.translate(width - fontHeight, width);
                at.rotate(angle + 1.5707963267948966);
                g2d.setTransform(at);
                g2d.drawString(as.getIterator(), 0.0f, 0.0f);
                String brightnessText = ColorWheelPanel.getLabel("Xoetrope.brightness", "Brightness");
                as = new AttributedString(brightnessText);
                as.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                as.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.3)));
                as.addAttribute(TextAttribute.FOREGROUND, Color.black);
                at = (AffineTransform)identityTransform.clone();
                at.translate(width - fontHeight, ColorWheelPanel.this.ringThickness * (double)brightnessText.length() / 2.3);
                at.rotate(angle + 1.5707963267948966);
                g2d.setTransform(at);
                g2d.drawString(as.getIterator(), 0.0f, 0.0f);
            }
            g2d.setTransform(identityTransform);
            if (ColorWheelPanel.this.showRollovers) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (ColorWheelPanel.this.rolloverPath != null) {
                    g2d.setColor(ColorWheelPanel.this.rolloverColor);
                    g2d.setStroke(new BasicStroke(1.5f));
                    g2d.draw(ColorWheelPanel.this.rolloverPath);
                }
                if (ColorWheelPanel.this.selectedPath != null) {
                    g2d.setColor(ColorWheelPanel.this.selectedColor);
                    g2d.setStroke(new BasicStroke(1.0f));
                    g2d.draw(ColorWheelPanel.this.selectedPath);
                }
            }
        }
    }
}

