/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public abstract class ShiftColorScheme
implements ColorScheme {
    private double shiftFactor;
    private Color shiftColor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public ShiftColorScheme(ColorScheme origScheme, Color shiftColor, double shiftFactor) {
        this.shiftColor = shiftColor;
        this.shiftFactor = shiftFactor;
        this.origScheme = origScheme;
        this.foregroundColor = origScheme.getForegroundColor();
        this.mainUltraDarkColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getUltraDarkColor(), this.shiftFactor);
        this.mainDarkColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getDarkColor(), this.shiftFactor);
        this.mainMidColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getMidColor(), this.shiftFactor);
        this.mainLightColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getLightColor(), this.shiftFactor);
        this.mainExtraLightColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getExtraLightColor(), this.shiftFactor);
        this.mainUltraLightColor = SubstanceColorUtilities.getInterpolatedColor(this.shiftColor, origScheme.getUltraLightColor(), this.shiftFactor);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }
}

