/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.SwingUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    Control control;
    AccessibleContext accessibleContext;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector textListeners = new Vector();

    Accessible(Control control) {
        this.control = control;
        this.accessibleContext = control.handle.getAccessibleContext();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.addElement(accessibleTextListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.removeElement(accessibleTextListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void selectionChanged() {
    }

    public void textCaretMoved(int n2) {
    }

    public void textChanged(int n2, int n3, int n4) {
    }

    public void textSelectionChanged() {
    }

    public void setFocus(int n2) {
    }

    public void internal_dispose_Accessible() {
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread() || SwingUtilities.isEventDispatchThread();
    }
}

