/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CLabel
extends Canvas {
    private static final int GAP = 5;
    private static final int INDENT = 3;
    private static final String ELLIPSIS = "...";
    private int align = 16384;
    private int hIndent = 3;
    private int vIndent = 3;
    private String text;
    private Image image;
    private String appToolTipText;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
    private Color background;
    private static int DRAW_FLAGS = 15;

    public CLabel(Composite composite, int n2) {
        super(composite, CLabel.checkStyle(n2));
        if ((n2 & 0x1020000) == 0) {
            n2 |= 0x4000;
        }
        if ((n2 & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((n2 & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((n2 & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CLabel.this.onPaint(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CLabel.this.onDispose(event);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 128) {
                    CLabel.this.onMnemonic(event);
                }
            }
        });
        this.initAccessible();
    }

    private static int checkStyle(int n2) {
        if ((n2 & 0x800) != 0) {
            n2 |= 4;
        }
        int n3 = 100663340;
        n2 &= n3;
        return n2 |= 0x20080000;
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        Point point = this.getTotalSize(this.image, this.text);
        point.x = n2 == -1 ? (point.x += 2 * this.hIndent) : n2;
        point.y = n3 == -1 ? (point.y += 2 * this.vIndent) : n3;
        return point;
    }

    private void drawBevelRect(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        gC.setForeground(color2);
        gC.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        gC.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        gC.setForeground(color);
        gC.drawLine(n2, n3, n2 + n4 - 1, n3);
        gC.drawLine(n2, n3, n2, n3 + n5 - 1);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    public Image getImage() {
        return this.image;
    }

    private Point getTotalSize(Image image, String string) {
        Object object;
        Point point = new Point(0, 0);
        if (image != null) {
            object = image.getBounds();
            point.x += ((Rectangle)object).width;
            point.y += ((Rectangle)object).height;
        }
        object = new GC(this);
        if (string != null && string.length() > 0) {
            Point point2 = ((GC)object).textExtent(string, DRAW_FLAGS);
            point.x += point2.x;
            point.y = Math.max(point.y, point2.y);
            if (image != null) {
                point.x += 5;
            }
        } else {
            point.y = Math.max(point.y, ((GC)object).getFontMetrics().getHeight());
        }
        ((GC)object).dispose();
        return point;
    }

    public int getStyle() {
        int n2 = super.getStyle();
        switch (this.align) {
            case 131072: {
                n2 |= 0x20000;
                break;
            }
            case 0x1000000: {
                n2 |= 0x1000000;
                break;
            }
            case 16384: {
                n2 |= 0x4000;
            }
        }
        return n2;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e2) {
                e2.result = CLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e2) {
                e2.result = CLabel.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e2) {
                char mnemonic = CLabel.this._findMnemonic(CLabel.this.text);
                if (mnemonic != '\u0000') {
                    e2.result = "Alt+" + mnemonic;
                }
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e2) {
                e2.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e2) {
                Rectangle rect = CLabel.this.getDisplay().map((Control)CLabel.this.getParent(), null, CLabel.this.getBounds());
                e2.x = rect.x;
                e2.y = rect.y;
                e2.width = rect.width;
                e2.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e2) {
                e2.detail = 0;
            }

            public void getRole(AccessibleControlEvent e2) {
                e2.detail = 41;
            }

            public void getState(AccessibleControlEvent e2) {
                e2.detail = 64;
            }
        });
    }

    void onDispose(DisposeEvent disposeEvent) {
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    void onMnemonic(TraverseEvent traverseEvent) {
        char c2 = this._findMnemonic(this.text);
        if (c2 == '\u0000') {
            return;
        }
        if (Character.toLowerCase(traverseEvent.character) != c2) {
            return;
        }
        for (Composite composite = this.getParent(); composite != null; composite = composite.getParent()) {
            int n2;
            Control[] controlArray = composite.getChildren();
            for (n2 = 0; n2 < controlArray.length && controlArray[n2] != this; ++n2) {
            }
            if (++n2 >= controlArray.length || !controlArray[n2].setFocus()) continue;
            traverseEvent.doit = true;
            traverseEvent.detail = 0;
        }
    }

    void onPaint(PaintEvent paintEvent) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[] stringArray;
        GC gC;
        Point point;
        Image image;
        Rectangle rectangle;
        block35: {
            Object object;
            rectangle = this.getClientArea();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = false;
            String string = this.text;
            image = this.image;
            int n7 = Math.max(0, rectangle.width - 2 * this.hIndent);
            point = this.getTotalSize(image, string);
            if (point.x > n7) {
                image = null;
                point = this.getTotalSize(image, string);
                if (point.x > n7) {
                    bl = true;
                }
            }
            gC = paintEvent.gc;
            String[] stringArray2 = stringArray = this.text == null ? null : this.splitString(this.text);
            if (bl) {
                point.x = 0;
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    object = gC.textExtent(stringArray[n6], DRAW_FLAGS);
                    if (((Point)object).x > n7) {
                        stringArray[n6] = this.shortenText(gC, stringArray[n6], n7);
                        point.x = Math.max(point.x, this.getTotalSize(null, (String)stringArray[n6]).x);
                        continue;
                    }
                    point.x = Math.max(point.x, ((Point)object).x);
                }
                if (this.appToolTipText == null) {
                    super.setToolTipText(this.text);
                }
            } else {
                super.setToolTipText(this.appToolTipText);
            }
            n6 = rectangle.x + this.hIndent;
            if (this.align == 0x1000000) {
                n6 = (rectangle.width - point.x) / 2;
            }
            if (this.align == 131072) {
                n6 = rectangle.width - this.hIndent - point.x;
            }
            try {
                if (this.backgroundImage != null) {
                    object = this.backgroundImage.getBounds();
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                    for (n5 = 0; n5 < rectangle.width; n5 += ((Rectangle)object).width) {
                        for (int i2 = 0; i2 < rectangle.height; i2 += ((Rectangle)object).height) {
                            gC.drawImage(this.backgroundImage, n5, i2);
                        }
                    }
                } else if (this.gradientColors != null) {
                    object = gC.getBackground();
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gC.setBackground(this.gradientColors[0]);
                        }
                        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
                    } else {
                        Color color = gC.getForeground();
                        Object object2 = this.gradientColors[0];
                        if (object2 == null) {
                            object2 = object;
                        }
                        n4 = 0;
                        for (n3 = 0; n3 < this.gradientPercents.length; ++n3) {
                            gC.setForeground((Color)object2);
                            object2 = this.gradientColors[n3 + 1];
                            if (object2 == null) {
                                object2 = object;
                            }
                            gC.setBackground((Color)object2);
                            if (this.gradientVertical) {
                                n2 = this.gradientPercents[n3] * rectangle.height / 100 - n4;
                                gC.fillGradientRectangle(0, n4, rectangle.width, n2, true);
                                n4 += n2;
                                continue;
                            }
                            n2 = this.gradientPercents[n3] * rectangle.width / 100 - n4;
                            gC.fillGradientRectangle(n4, 0, n2, rectangle.height, false);
                            n4 += n2;
                        }
                        if (this.gradientVertical && n4 < rectangle.height) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(0, n4, rectangle.width, rectangle.height - n4);
                        }
                        if (!this.gradientVertical && n4 < rectangle.width) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(n4, 0, rectangle.width - n4, rectangle.height);
                        }
                        gC.setForeground(color);
                    }
                    gC.setBackground((Color)object);
                } else if (this.background != null || (this.getStyle() & 0x20000000) == 0) {
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                }
            }
            catch (SWTException sWTException) {
                if ((this.getStyle() & 0x20000000) != 0) break block35;
                gC.setBackground(this.getBackground());
                gC.fillRectangle(rectangle);
            }
        }
        int n8 = this.getStyle();
        if ((n8 & 4) != 0 || (n8 & 8) != 0) {
            this.paintBorder(gC, rectangle);
        }
        if (image != null) {
            Rectangle rectangle2 = image.getBounds();
            gC.drawImage(image, 0, 0, rectangle2.width, rectangle2.height, n6, (rectangle.height - rectangle2.height) / 2, rectangle2.width, rectangle2.height);
            n6 += rectangle2.width + 5;
            point.x -= rectangle2.width + 5;
        }
        if (stringArray != null) {
            n5 = gC.getFontMetrics().getHeight();
            int n9 = stringArray.length * n5;
            n4 = Math.max(this.vIndent, rectangle.y + (rectangle.height - n9) / 2);
            gC.setForeground(this.getForeground());
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                n2 = n6;
                if (stringArray.length > 1) {
                    int n10;
                    if (this.align == 0x1000000) {
                        n10 = gC.textExtent((String)stringArray[n3], (int)CLabel.DRAW_FLAGS).x;
                        n2 = n6 + Math.max(0, (point.x - n10) / 2);
                    }
                    if (this.align == 131072) {
                        n10 = gC.textExtent((String)stringArray[n3], (int)CLabel.DRAW_FLAGS).x;
                        n2 = Math.max(n6, rectangle.x + rectangle.width - this.hIndent - n10);
                    }
                }
                gC.drawText(stringArray[n3], n2, n4, DRAW_FLAGS);
                n4 += n5;
            }
        }
    }

    private void paintBorder(GC gC, Rectangle rectangle) {
        Display display = this.getDisplay();
        Color color = null;
        Color color2 = null;
        int n2 = this.getStyle();
        if ((n2 & 4) != 0) {
            color = display.getSystemColor(18);
            color2 = display.getSystemColor(20);
        }
        if ((n2 & 8) != 0) {
            color = display.getSystemColor(19);
            color2 = display.getSystemColor(18);
        }
        if (color != null && color2 != null) {
            gC.setLineWidth(1);
            this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color, color2);
        }
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if (n2 != 16384 && n2 != 131072 && n2 != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != n2) {
            this.align = n2;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && (color == null ? this.background == null : color.equals(this.background))) {
            return;
        }
        this.background = color;
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] < 0 || nArray[i2] > 100) {
                    SWT.error(5);
                }
                if (i2 <= 0 || nArray[i2] >= nArray[i2 - 1]) continue;
                SWT.error(5);
            }
        }
        Color color = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                int n3;
                n2 = 0;
                for (n3 = 0; n3 < this.gradientColors.length; ++n3) {
                    int n4 = n2 = this.gradientColors[n3] == colorArray[n3] || this.gradientColors[n3] == null && colorArray[n3] == color || this.gradientColors[n3] == color && colorArray[n3] == null ? 1 : 0;
                    if (n2 == 0) break;
                }
                if (n2 != 0) {
                    for (n3 = 0; n3 < this.gradientPercents.length; ++n3) {
                        int n5 = n2 = this.gradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                    }
                }
                if (n2 != 0 && this.gradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                this.gradientColors[n2] = colorArray[n2] != null ? colorArray[n2] : color;
            }
            this.gradientPercents = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.gradientPercents[n2] = nArray[n2];
            }
            this.gradientVertical = bl;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.text)) {
            this.text = string;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    protected String shortenText(GC gC, String string, int n2) {
        int n3;
        if (string == null) {
            return null;
        }
        int n4 = gC.textExtent((String)ELLIPSIS, (int)CLabel.DRAW_FLAGS).x;
        int n5 = string.length();
        int n6 = n3 = n5 / 2;
        for (int i2 = n3 + 1; n6 >= 0 && i2 < n5; --n6, ++i2) {
            String string2 = string.substring(0, n6);
            String string3 = string.substring(i2, n5);
            int n7 = gC.textExtent((String)string2, (int)CLabel.DRAW_FLAGS).x;
            int n8 = gC.textExtent((String)string3, (int)CLabel.DRAW_FLAGS).x;
            if (n7 + n4 + n8 >= n2) continue;
            string = string2 + ELLIPSIS + string3;
            break;
        }
        return string;
    }

    private String[] splitString(String string) {
        int n2;
        String[] stringArray = new String[1];
        int n3 = 0;
        do {
            if ((n2 = string.indexOf(10, n3)) == -1) {
                stringArray[stringArray.length - 1] = string.substring(n3);
                continue;
            }
            boolean bl = n2 > 0 && string.charAt(n2 - 1) == '\r';
            stringArray[stringArray.length - 1] = string.substring(n3, n2 - (bl ? 1 : 0));
            n3 = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        } while (n2 != -1);
        return stringArray;
    }

    static /* synthetic */ String access$000(CLabel cLabel) {
        return cLabel.text;
    }
}

