/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Image bgImage;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    static Color borderColor;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showChevron = false;
    Menu showMenu;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 1;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 1;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int highlight_margin = 0;
    int highlight_header = 0;
    int[] curve;
    int curveWidth = 0;
    int curveIndent = 0;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 18;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_FILL;
    static final int CHEVRON_CHILD_ID = 0;
    static final int MINIMIZE_CHILD_ID = 1;
    static final int MAXIMIZE_CHILD_ID = 2;
    static final int EXTRA_CHILD_ID_COUNT = 3;

    public CTabFolder(Composite composite, int n2) {
        super(composite, CTabFolder.checkStyle(composite, n2));
        super.setLayout(new CTabFolderLayout());
        int n3 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n3 & 0x400) != 0;
        this.showClose = (n3 & 0x40) != 0;
        this.single = (n3 & 4) != 0;
        this.borderRight = (n2 & 0x800) != 0 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (n2 & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (n2 & 0x800000) != 0 ? 0 : 2;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        borderColor = display.getSystemColor(18);
        this.updateTabHeight(false);
        this.initAccessible();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], this.listener);
        }
    }

    static int checkStyle(Composite composite, int n2) {
        int n3 = 109053126;
        if (((n2 &= n3) & 0x80) != 0) {
            n2 &= 0xFFFFFBFF;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        n2 |= 0x100000;
        String string = SWT.getPlatform();
        if ("carbon".equals(string) || "gtk".equals(string)) {
            return n2;
        }
        if ((n2 & 0x4000000) != 0) {
            return n2;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n2 & 0x2000000) == 0) {
            return n2;
        }
        return n2 | 0x40000;
    }

    static void fillRegion(GC gC, Region region) {
        Region region2 = new Region();
        gC.getClipping(region2);
        region.intersect(region2);
        gC.setClipping(region);
        gC.fillRectangle(region.getBounds());
        gC.setClipping(region2);
        region2.dispose();
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void antialias(int[] nArray, RGB rGB, RGB rGB2, RGB rGB3, GC gC) {
        Color color;
        int n2;
        int n3;
        int n4;
        RGB rGB4;
        int n5;
        int n6;
        if (this.simple || "carbon".equals(SWT.getPlatform())) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (rGB3 != null) {
            int n7 = 0;
            n6 = 1;
            n5 = this.onBottom ? 0 : this.getSize().y;
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length / 2; ++i2) {
                if (n6 != 0 && n7 + 3 < nArray.length) {
                    n6 = this.onBottom ? (n5 <= nArray[n7 + 3] ? 1 : 0) : (n5 >= nArray[n7 + 3] ? 1 : 0);
                    n5 = nArray[n7 + 1];
                }
                nArray2[n7] = nArray[n7++] + (n6 != 0 ? -1 : 1);
                nArray2[n7] = nArray[n7++];
            }
            RGB rGB5 = rGB;
            rGB4 = rGB3;
            n4 = rGB5.red + 2 * (rGB4.red - rGB5.red) / 3;
            n3 = rGB5.green + 2 * (rGB4.green - rGB5.green) / 3;
            n2 = rGB5.blue + 2 * (rGB4.blue - rGB5.blue) / 3;
            color = new Color(this.getDisplay(), n4, n3, n2);
            gC.setForeground(color);
            gC.drawPolyline(nArray2);
            color.dispose();
        }
        if (rGB2 != null) {
            int[] nArray3 = new int[nArray.length];
            n6 = 0;
            n5 = 1;
            int n8 = this.onBottom ? 0 : this.getSize().y;
            for (int i3 = 0; i3 < nArray.length / 2; ++i3) {
                if (n5 != 0 && n6 + 3 < nArray.length) {
                    n5 = this.onBottom ? (n8 <= nArray[n6 + 3] ? 1 : 0) : (n8 >= nArray[n6 + 3] ? 1 : 0);
                    n8 = nArray[n6 + 1];
                }
                nArray3[n6] = nArray[n6++] + (n5 != 0 ? 1 : -1);
                nArray3[n6] = nArray[n6++];
            }
            RGB rGB6 = rGB;
            rGB4 = rGB2;
            n4 = rGB6.red + 2 * (rGB4.red - rGB6.red) / 3;
            n3 = rGB6.green + 2 * (rGB4.green - rGB6.green) / 3;
            n2 = rGB6.blue + 2 * (rGB4.blue - rGB6.blue) / 3;
            color = new Color(this.getDisplay(), n4, n3, n2);
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
            color.dispose();
        }
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        int n6 = n2 - this.marginWidth - this.highlight_margin - this.borderLeft;
        int n7 = n4 + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            int n8 = this.onBottom ? n3 - this.borderTop : n3 - this.highlight_header - this.tabHeight - this.borderTop;
            int n9 = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
            return new Rectangle(n6, n8, n7, n9);
        }
        int n10 = this.onBottom ? n3 - this.marginHeight - this.highlight_margin - this.borderTop : n3 - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
        int n11 = n5 + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        return new Rectangle(n6, n10, n7, n11);
    }

    void createItem(CTabItem cTabItem, int n2) {
        if (0 > n2 || n2 > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        cTabItemArray[n2] = cTabItem;
        System.arraycopy(this.items, n2, cTabItemArray, n2 + 1, this.items.length - n2);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n2) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n3 = 0;
        int n4 = this.priority.length;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (!this.mru && this.priority[i2] == n2) {
                n4 = n3++;
            }
            nArray[n3++] = this.priority[i2] >= n2 ? this.priority[i2] + 1 : this.priority[i2];
        }
        nArray[n4] = n2;
        this.priority = nArray;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n2 = this.indexOf(cTabItem);
        if (n2 == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            this.setButtonBounds();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        System.arraycopy(this.items, n2 + 1, cTabItemArray, n2, this.items.length - n2 - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n3 = 0;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (this.priority[i2] == n2) continue;
            nArray[n3++] = this.priority[i2] > n2 ? this.priority[i2] - 1 : this.priority[i2];
        }
        this.priority = nArray;
        if (this.selectedIndex == n2) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n4 = this.mru ? this.priority[0] : Math.max(0, n2 - 1);
            this.setSelection(n4, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n2) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    void drawBackground(GC gC, int[] nArray, boolean bl) {
        Color color = bl ? this.selectionBackground : this.getBackground();
        Image image = bl ? this.selectionBgImage : this.bgImage;
        Color[] colorArray = bl ? this.selectionGradientColors : this.gradientColors;
        int[] nArray2 = bl ? this.selectionGradientPercents : this.gradientPercents;
        boolean bl2 = bl ? this.selectionGradientVertical : this.gradientVertical;
        Point point = this.getSize();
        int n2 = point.x;
        int n3 = this.tabHeight + this.highlight_header;
        int n4 = 0;
        if (this.borderLeft > 0) {
            ++n4;
            n2 -= 2;
        }
        int n5 = this.onBottom ? point.y - this.borderBottom - n3 : this.borderTop;
        this.drawBackground(gC, nArray, n4, n5, n2, n3, color, image, colorArray, nArray2, bl2);
    }

    void drawBackground(GC gC, int[] nArray, int n2, int n3, int n4, int n5, Color color, Image image, Color[] colorArray, int[] nArray2, boolean bl) {
        Region region = new Region();
        gC.getClipping(region);
        Region region2 = new Region();
        region2.add(nArray);
        region2.intersect(region);
        gC.setClipping(region2);
        if (image != null) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
            Rectangle rectangle = image.getBounds();
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n3, n4, n5);
        } else if (colorArray != null) {
            if (colorArray.length == 1) {
                Color color2 = colorArray[0] != null ? colorArray[0] : color;
                gC.setBackground(color2);
                gC.fillRectangle(n2, n3, n4, n5);
            } else if (bl) {
                if (this.onBottom) {
                    Color color3;
                    int n6 = 0;
                    if (nArray2[nArray2.length - 1] < 100) {
                        n6 = nArray2[nArray2.length - 1] * n5 / 100;
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n3, n4, n6);
                    }
                    if ((color3 = colorArray[colorArray.length - 1]) == null) {
                        color3 = color;
                    }
                    for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
                        gC.setForeground(color3);
                        color3 = colorArray[i2];
                        if (color3 == null) {
                            color3 = color;
                        }
                        gC.setBackground(color3);
                        int n7 = nArray2[i2] * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n6, n4, n7, true);
                        n6 += n7;
                    }
                } else {
                    Color color4 = colorArray[0];
                    if (color4 == null) {
                        color4 = color;
                    }
                    int n8 = 0;
                    for (int i3 = 0; i3 < nArray2.length; ++i3) {
                        gC.setForeground(color4);
                        color4 = colorArray[i3 + 1];
                        if (color4 == null) {
                            color4 = color;
                        }
                        gC.setBackground(color4);
                        int n9 = nArray2[i3] * n5 / 100;
                        gC.fillGradientRectangle(n2, n3 + n8, n4, n9, true);
                        n8 += n9;
                    }
                    if (n8 < n5) {
                        gC.setBackground(color);
                        gC.fillRectangle(n2, n8, n4, n5 - n8 + 1);
                    }
                }
            } else {
                n3 = 0;
                n5 = this.getSize().y;
                Color color5 = colorArray[0];
                if (color5 == null) {
                    color5 = color;
                }
                int n10 = 0;
                for (int i4 = 0; i4 < nArray2.length; ++i4) {
                    gC.setForeground(color5);
                    color5 = colorArray[i4 + 1];
                    if (color5 == null) {
                        color5 = color;
                    }
                    gC.setBackground(color5);
                    int n11 = nArray2[i4] * n4 / 100 - n10;
                    gC.fillGradientRectangle(n2 + n10, n3, n11, n5, false);
                    n10 += n11;
                }
                if (n10 < n4) {
                    gC.setBackground(color);
                    gC.fillRectangle(n2 + n10, n3, n4 - n10, n5);
                }
            }
        } else if ((this.getStyle() & 0x40000) != 0 || !color.equals(this.getBackground())) {
            gC.setBackground(color);
            gC.fillRectangle(n2, n3, n4, n5);
        }
        gC.setClipping(region);
        region.dispose();
        region2.dispose();
    }

    void drawBody(Event event) {
        int n2;
        int n3;
        int n4;
        GC gC = event.gc;
        Point point = this.getSize();
        if (!this.minimized) {
            n4 = point.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            n3 = point.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int[] nArray = null;
                if (this.onBottom) {
                    n2 = this.borderLeft;
                    int n5 = this.borderTop;
                    int n6 = point.x - this.borderRight;
                    int n7 = point.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    nArray = new int[]{n2, n5, n6, n5, n6, n7, n6 - this.highlight_margin, n7, n6 - this.highlight_margin, n5 + this.highlight_margin, n2 + this.highlight_margin, n5 + this.highlight_margin, n2 + this.highlight_margin, n7, n2, n7};
                } else {
                    n2 = this.borderLeft;
                    int n8 = this.borderTop + this.tabHeight + this.highlight_header;
                    int n9 = point.x - this.borderRight;
                    int n10 = point.y - this.borderBottom;
                    nArray = new int[]{n2, n8, n2 + this.highlight_margin, n8, n2 + this.highlight_margin, n10 - this.highlight_margin, n9 - this.highlight_margin, n10 - this.highlight_margin, n9 - this.highlight_margin, n8, n9, n8, n9, n10, n2, n10};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gC, nArray, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gC, nArray, false);
                } else {
                    gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gC.fillPolygon(nArray);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gC.setBackground(this.getBackground());
                gC.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, n4, n3);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && point.y > (n4 = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gC.setBackground(this.getParent().getBackground());
            gC.fillRectangle(0, n4, point.x, point.y - n4);
        }
        if (this.borderLeft > 0) {
            gC.setForeground(borderColor);
            n4 = this.borderLeft - 1;
            n3 = point.x - this.borderRight;
            int n11 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            n2 = this.onBottom ? point.y - this.tabHeight - this.borderBottom - 1 : point.y - this.borderBottom;
            gC.drawLine(n4, n11, n4, n2);
            gC.drawLine(n3, n11, n3, n2);
            if (this.onBottom) {
                gC.drawLine(n4, n11, n3, n11);
            } else {
                gC.drawLine(n4, n2, n3, n2);
            }
        }
    }

    void drawChevron(GC gC) {
        int n2;
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        Point point = display.getDPI();
        int n3 = 720 / point.y;
        FontData fontData = this.getFont().getFontData()[0];
        fontData.setHeight(n3);
        Font font = new Font((Device)display, fontData);
        int n4 = font.getFontData()[0].getHeight() * point.y / 72;
        int n5 = Math.max(2, (this.chevronRect.height - n4 - 4) / 2);
        int n6 = this.chevronRect.x + 2;
        int n7 = this.chevronRect.y + n5;
        if (this.single) {
            n2 = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
        } else {
            int n8;
            for (n8 = 0; n8 < this.priority.length && this.items[this.priority[n8]].showing; ++n8) {
            }
            n2 = this.items.length - n8;
        }
        String string = n2 > 99 ? "99+" : String.valueOf(n2);
        switch (this.chevronImageState) {
            case 1: {
                Color color = this.single ? this.getSelectionForeground() : this.getForeground();
                gC.setForeground(color);
                gC.setFont(font);
                gC.drawLine(n6, n7, n6 + 2, n7 + 2);
                gC.drawLine(n6 + 2, n7 + 2, n6, n7 + 4);
                gC.drawLine(n6 + 1, n7, n6 + 3, n7 + 2);
                gC.drawLine(n6 + 3, n7 + 2, n6 + 1, n7 + 4);
                gC.drawLine(n6 + 4, n7, n6 + 6, n7 + 2);
                gC.drawLine(n6 + 6, n7 + 2, n6 + 5, n7 + 4);
                gC.drawLine(n6 + 5, n7, n6 + 7, n7 + 2);
                gC.drawLine(n6 + 7, n7 + 2, n6 + 4, n7 + 4);
                gC.drawString(string, n6 + 7, n7 + 3, true);
                break;
            }
            case 2: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n6, n7, n6 + 2, n7 + 2);
                gC.drawLine(n6 + 2, n7 + 2, n6, n7 + 4);
                gC.drawLine(n6 + 1, n7, n6 + 3, n7 + 2);
                gC.drawLine(n6 + 3, n7 + 2, n6 + 1, n7 + 4);
                gC.drawLine(n6 + 4, n7, n6 + 6, n7 + 2);
                gC.drawLine(n6 + 6, n7 + 2, n6 + 5, n7 + 4);
                gC.drawLine(n6 + 5, n7, n6 + 7, n7 + 2);
                gC.drawLine(n6 + 7, n7 + 2, n6 + 4, n7 + 4);
                gC.drawString(string, n6 + 7, n7 + 3, true);
                break;
            }
            case 3: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n6 + 1, n7 + 1, n6 + 3, n7 + 3);
                gC.drawLine(n6 + 3, n7 + 3, n6 + 1, n7 + 5);
                gC.drawLine(n6 + 2, n7 + 1, n6 + 4, n7 + 3);
                gC.drawLine(n6 + 4, n7 + 3, n6 + 2, n7 + 5);
                gC.drawLine(n6 + 5, n7 + 1, n6 + 7, n7 + 3);
                gC.drawLine(n6 + 7, n7 + 3, n6 + 6, n7 + 5);
                gC.drawLine(n6 + 6, n7 + 1, n6 + 8, n7 + 3);
                gC.drawLine(n6 + 8, n7 + 3, n6 + 5, n7 + 5);
                gC.drawString(string, n6 + 8, n7 + 4, true);
            }
        }
        font.dispose();
    }

    void drawMaximize(GC gC) {
        if (this.maxRect.width == 0 || this.maxRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n2 = this.maxRect.x + 4;
        int n3 = this.maxRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.maxImageState) {
            case 1: {
                if (!this.maximized) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawLine(n2 + 2, n3 + 3, n2 + 9, n3 + 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawMinimize(GC gC) {
        if (this.minRect.width == 0 || this.minRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n2 = this.minRect.x + 4;
        int n3 = this.minRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.minImageState) {
            case 1: {
                if (!this.minimized) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 3);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawTabArea(Event event) {
        int n2;
        int n3;
        Object object;
        int[] nArray;
        GC gC = event.gc;
        Point point = this.getSize();
        int[] nArray2 = null;
        if (this.tabHeight == 0) {
            int n4;
            int n5 = this.borderLeft - 1;
            int n6 = point.x - this.borderRight;
            int n7 = this.onBottom ? point.y - this.borderBottom - this.highlight_header - 1 : this.borderTop + this.highlight_header;
            int n8 = n4 = this.onBottom ? point.y - this.borderBottom : this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            nArray2 = new int[]{n5, n7, n5, --n4, n6, n4, n6, n7};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gC, nArray2, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gC, nArray2, false);
            } else {
                gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gC.fillPolygon(nArray2);
            }
            if (this.borderLeft > 0) {
                gC.setForeground(borderColor);
                gC.drawPolyline(nArray2);
            }
            return;
        }
        int n9 = Math.max(0, this.borderLeft - 1);
        int n10 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop;
        int n11 = point.x - this.borderLeft - this.borderRight + 1;
        int n12 = this.tabHeight - 1;
        if (this.onBottom) {
            nArray = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
            object = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n3 = 0;
            nArray2[n3++] = n9;
            nArray2[n3++] = n10 - this.highlight_header;
            for (n2 = 0; n2 < nArray.length / 2; ++n2) {
                nArray2[n3++] = n9 + nArray[2 * n2];
                nArray2[n3++] = n10 + n12 + nArray[2 * n2 + 1];
                if (this.borderLeft != 0) continue;
                int n13 = n3 - 1;
                nArray2[n13] = nArray2[n13] + 1;
            }
            for (n2 = 0; n2 < ((int[])object).length / 2; ++n2) {
                nArray2[n3++] = n9 + n11 + object[2 * n2];
                nArray2[n3++] = n10 + n12 + object[2 * n2 + 1];
                if (this.borderLeft != 0) continue;
                int n14 = n3 - 1;
                nArray2[n14] = nArray2[n14] + 1;
            }
            nArray2[n3++] = n9 + n11;
            nArray2[n3++] = n10 - this.highlight_header;
        } else {
            nArray = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
            object = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n3 = 0;
            nArray2[n3++] = n9;
            nArray2[n3++] = n10 + n12 + this.highlight_header + 1;
            for (n2 = 0; n2 < nArray.length / 2; ++n2) {
                nArray2[n3++] = n9 + nArray[2 * n2];
                nArray2[n3++] = n10 + nArray[2 * n2 + 1];
            }
            for (n2 = 0; n2 < ((int[])object).length / 2; ++n2) {
                nArray2[n3++] = n9 + n11 + object[2 * n2];
                nArray2[n3++] = n10 + object[2 * n2 + 1];
            }
            nArray2[n3++] = n9 + n11;
            nArray2[n3++] = n10 + n12 + this.highlight_header + 1;
        }
        boolean bl = this.single && this.selectedIndex != -1;
        this.drawBackground(gC, nArray2, bl);
        object = new Region();
        ((Region)object).add(new Rectangle(n9, n10, n11 + 1, n12 + 1));
        ((Region)object).subtract(nArray2);
        gC.setBackground(this.getParent().getBackground());
        CTabFolder.fillRegion(gC, (Region)object);
        ((Region)object).dispose();
        if (!this.single) {
            for (n3 = 0; n3 < this.items.length; ++n3) {
                if (n3 == this.selectedIndex || !event.getBounds().intersects(this.items[n3].getBounds())) continue;
                this.items[n3].onPaint(gC, false);
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem cTabItem = this.items[this.selectedIndex];
            cTabItem.onPaint(gC, true);
        } else {
            n3 = this.borderLeft;
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            int n15 = point.x - this.borderRight;
            gC.setForeground(borderColor);
            gC.drawLine(n3, n2, n15, n2);
        }
        this.drawChevron(gC);
        this.drawMinimize(gC);
        this.drawMaximize(gC);
        if (this.borderLeft > 0) {
            RGB rGB = this.getParent().getBackground().getRGB();
            this.antialias(nArray2, borderColor.getRGB(), null, rGB, gC);
            gC.setForeground(borderColor);
            gC.drawPolyline(nArray2);
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.minimized) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point point = this.getSize();
        int n2 = point.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
        int n3 = point.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
        return new Rectangle(this.xClient, this.yClient, n2, n3 -= this.tabHeight);
    }

    public CTabItem getItem(int n2) {
        if (n2 < 0 || n2 >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n2];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        Point point2 = this.getSize();
        if (point2.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        if (this.showChevron && this.chevronRect.contains(point)) {
            return null;
        }
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            CTabItem cTabItem = this.items[this.priority[i2]];
            Rectangle rectangle = cTabItem.getBounds();
            if (!rectangle.contains(point)) continue;
            return cTabItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return string.substring(0, n2 - 1) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    int getRightItemEdge() {
        int n2 = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            n2 -= 18;
        }
        if (this.showMax) {
            n2 -= 18;
        }
        if (this.showChevron) {
            n2 -= 27;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point point = this.topRight.computeSize(-1, -1);
            n2 -= point.x + 3;
        }
        return Math.max(0, n2);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xFFFFFB7F;
        n2 |= this.onBottom ? 1024 : 128;
        n2 &= 0xFFFFFFF9;
        n2 |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            n2 |= 0x800;
        }
        return n2;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] != cTabItem) continue;
            return i2;
        }
        return -1;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e2) {
                String name = null;
                int childID = e2.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    name = CTabFolder.this.stripMnemonic(CTabFolder.this.items[childID].getText());
                } else if (childID == CTabFolder.this.items.length + 0) {
                    name = SWT.getMessage("SWT_ShowList");
                } else if (childID == CTabFolder.this.items.length + 1) {
                    name = CTabFolder.this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
                } else if (childID == CTabFolder.this.items.length + 2) {
                    name = CTabFolder.this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
                }
                e2.result = name;
            }

            public void getHelp(AccessibleEvent e2) {
                String help = null;
                int childID = e2.childID;
                if (childID == -1) {
                    help = CTabFolder.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    help = CTabFolder.this.items[childID].getToolTipText();
                }
                e2.result = help;
            }

            public void getKeyboardShortcut(AccessibleEvent e2) {
                char mnemonic;
                String text;
                String shortcut = null;
                int childID = e2.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (text = CTabFolder.this.items[childID].getText()) != null && (mnemonic = CTabFolder.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e2.result = shortcut;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e2) {
                Point testPoint = CTabFolder.this.toControl(e2.x, e2.y);
                int childID = -2;
                int i2 = 0;
                while (i2 < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[i2].getBounds().contains(testPoint)) {
                        childID = i2;
                        break;
                    }
                    ++i2;
                }
                if (childID == -2) {
                    if (CTabFolder.this.showChevron && CTabFolder.this.chevronRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 0;
                    } else if (CTabFolder.this.showMin && CTabFolder.this.minRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 1;
                    } else if (CTabFolder.this.showMax && CTabFolder.this.maxRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 2;
                    } else {
                        Rectangle location = CTabFolder.this.getBounds();
                        location.height -= CTabFolder.this.getClientArea().height;
                        if (location.contains(testPoint)) {
                            childID = -1;
                        }
                    }
                }
                e2.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e2) {
                Rectangle location = null;
                int childID = e2.childID;
                if (childID == -1) {
                    location = CTabFolder.this.getBounds();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    location = CTabFolder.this.items[childID].getBounds();
                } else if (CTabFolder.this.showChevron && childID == CTabFolder.this.items.length + 0) {
                    location = CTabFolder.this.chevronRect;
                } else if (CTabFolder.this.showMin && childID == CTabFolder.this.items.length + 1) {
                    location = CTabFolder.this.minRect;
                } else if (CTabFolder.this.showMax && childID == CTabFolder.this.items.length + 2) {
                    location = CTabFolder.this.maxRect;
                }
                if (location != null) {
                    Point pt = CTabFolder.this.toDisplay(location.x, location.y);
                    e2.x = pt.x;
                    e2.y = pt.y;
                    e2.width = location.width;
                    e2.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e2) {
                e2.detail = CTabFolder.this.items.length + 3;
            }

            public void getDefaultAction(AccessibleControlEvent e2) {
                String action = null;
                int childID = e2.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    action = SWT.getMessage("SWT_Switch");
                }
                if (childID >= CTabFolder.this.items.length && childID < CTabFolder.this.items.length + 3) {
                    action = SWT.getMessage("SWT_Press");
                }
                e2.result = action;
            }

            public void getFocus(AccessibleControlEvent e2) {
                int childID = -2;
                if (CTabFolder.this.isFocusControl()) {
                    childID = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                e2.childID = childID;
            }

            public void getRole(AccessibleControlEvent e2) {
                int role = 0;
                int childID = e2.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    role = 37;
                } else if (childID >= CTabFolder.this.items.length && childID < CTabFolder.this.items.length + 3) {
                    role = 43;
                }
                e2.detail = role;
            }

            public void getSelection(AccessibleControlEvent e2) {
                e2.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent e2) {
                int state = 0;
                int childID = e2.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                } else if (childID == CTabFolder.this.items.length + 0) {
                    state = CTabFolder.this.showChevron ? 0 : 32768;
                } else if (childID == CTabFolder.this.items.length + 1) {
                    state = CTabFolder.this.showMin ? 0 : 32768;
                } else if (childID == CTabFolder.this.items.length + 2) {
                    state = CTabFolder.this.showMax ? 0 : 32768;
                }
                e2.detail = state;
            }

            public void getChildren(AccessibleControlEvent e2) {
                int childIdCount = CTabFolder.this.items.length + 3;
                Object[] children = new Object[childIdCount];
                int i2 = 0;
                while (i2 < childIdCount) {
                    children[i2] = new Integer(i2);
                    ++i2;
                }
                e2.children = children;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n2;
                int n3;
                int n4 = this.items.length;
                if (n4 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n5 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n6 = n3 = event.keyCode == n5 ? -1 : 1;
                if (!this.mru) {
                    n2 = this.selectedIndex + n3;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n7 = 0;
                    int n8 = -1;
                    for (int i2 = 0; i2 < this.items.length; ++i2) {
                        if (!this.items[i2].showing) continue;
                        if (i2 == this.selectedIndex) {
                            n8 = n7;
                        }
                        nArray[n7++] = i2;
                    }
                    if (n8 + n3 >= 0 && n8 + n3 < n7) {
                        n2 = nArray[n8 + n3];
                    } else {
                        if (this.showChevron) {
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = this.chevronRect.x;
                            cTabFolderEvent.y = this.chevronRect.y;
                            cTabFolderEvent.width = this.chevronRect.width;
                            cTabFolderEvent.height = this.chevronRect.height;
                            cTabFolderEvent.doit = true;
                            for (int i3 = 0; i3 < this.folderListeners.length; ++i3) {
                                this.folderListeners[i3].showList(cTabFolderEvent);
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(this.chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (n2 < 0 || n2 >= n4) {
                    return;
                }
                this.setSelection(n2, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n2 = this.items.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.items[i2] == null) continue;
            this.items[i2].dispose();
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
    }

    void onDragDetect(Event event) {
        boolean bl = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            bl = true;
        } else {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                if (!this.items[i2].closeRect.contains(event.x, event.y)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event) {
        char c2 = event.character;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            char c3;
            if (this.items[i2] == null || (c3 = this._findMnemonic(this.items[i2].getText())) == '\u0000' || Character.toLowerCase(c2) != c3) continue;
            this.setSelection(i2, true);
            return true;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        int n2 = event.x;
        int n3 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                if (this.minImageState != 1) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    CTabItem cTabItem = this.items[i2];
                    if (i2 != this.selectedIndex && cTabItem.closeImageState != 0) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (i2 != this.selectedIndex || cTabItem.closeImageState == 1) continue;
                    cTabItem.closeImageState = 1;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 3: {
                if (this.minRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.minImageState = 3;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.maxImageState = 3;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.chevronImageState = this.chevronImageState != 2 ? 2 : 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i3 = 0; i3 < this.items.length; ++i3) {
                        Rectangle rectangle = this.items[i3].getBounds();
                        if (!rectangle.contains(n2, n3)) continue;
                        cTabItem = this.items[i3];
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n2, n3)) {
                    if (event.button != 1) {
                        return;
                    }
                    cTabItem.closeImageState = 3;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n4 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    this.setSelection(n4, true);
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (this.minRect.contains(n2, n3)) {
                    bl2 = true;
                    if (this.minImageState != 3 && this.minImageState != 2) {
                        this.minImageState = 2;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(n2, n3)) {
                    bl3 = true;
                    if (this.maxImageState != 3 && this.maxImageState != 2) {
                        this.maxImageState = 2;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(n2, n3)) {
                    bl4 = true;
                    if (this.chevronImageState != 3 && this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 1 && !bl2) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1 && !bl3) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1 && !bl4) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i4 = 0; i4 < this.items.length; ++i4) {
                    CTabItem cTabItem = this.items[i4];
                    bl = false;
                    if (cTabItem.getBounds().contains(n2, n3)) {
                        bl = true;
                        if (cTabItem.closeRect.contains(n2, n3)) {
                            if (cTabItem.closeImageState != 3 && cTabItem.closeImageState != 2) {
                                cTabItem.closeImageState = 2;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 1) {
                            cTabItem.closeImageState = 1;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                    }
                    if (i4 != this.selectedIndex && cTabItem.closeImageState != 0 && !bl) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (i4 != this.selectedIndex || cTabItem.closeImageState == 1 || bl) continue;
                    cTabItem.closeImageState = 1;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 4: {
                Object object;
                int n5;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(n2, n3)) {
                    boolean bl;
                    boolean bl5 = bl = this.chevronImageState == 3;
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = this.chevronRect.x;
                    cTabFolderEvent.y = this.chevronRect.y;
                    cTabFolderEvent.width = this.chevronRect.width;
                    cTabFolderEvent.height = this.chevronRect.height;
                    cTabFolderEvent.doit = true;
                    for (int i5 = 0; i5 < this.folderListeners.length; ++i5) {
                        this.folderListeners[i5].showList(cTabFolderEvent);
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    return;
                }
                if (this.minRect.contains(n2, n3)) {
                    boolean bl = this.minImageState == 3;
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    for (int i6 = 0; i6 < this.folderListeners.length; ++i6) {
                        if (this.minimized) {
                            this.folderListeners[i6].restore(cTabFolderEvent);
                            continue;
                        }
                        this.folderListeners[i6].minimize(cTabFolderEvent);
                    }
                    return;
                }
                if (this.maxRect.contains(n2, n3)) {
                    boolean bl = this.maxImageState == 3;
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    for (int i7 = 0; i7 < this.folderListeners.length; ++i7) {
                        if (this.maximized) {
                            this.folderListeners[i7].restore(cTabFolderEvent);
                            continue;
                        }
                        this.folderListeners[i7].maximize(cTabFolderEvent);
                    }
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i8 = 0; i8 < this.items.length; ++i8) {
                        serializable = this.items[i8].getBounds();
                        if (!serializable.contains(n2, n3)) continue;
                        cTabItem = this.items[i8];
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n2, n3)) break;
                boolean bl = cTabItem.closeImageState == 3;
                cTabItem.closeImageState = 2;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                for (n5 = 0; n5 < this.folderListeners.length; ++n5) {
                    object = this.folderListeners[n5];
                    object.close((CTabFolderEvent)serializable);
                }
                for (n5 = 0; n5 < this.tabListeners.length; ++n5) {
                    object = this.tabListeners[n5];
                    object.itemClosed((CTabFolderEvent)serializable);
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 3 && cTabItem2.closeImageState != 2) {
                                cTabItem2.closeImageState = 2;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 1) {
                            cTabItem2.closeImageState = 1;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    boolean onPageTraversal(Event event) {
        int n2 = this.items.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = this.selectedIndex;
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4;
            int n5 = n4 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n3 = (this.selectedIndex + n4 + n2) % n2;
            } else {
                int[] nArray = new int[this.items.length];
                int n6 = 0;
                int n7 = -1;
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    if (!this.items[i2].showing) continue;
                    if (i2 == this.selectedIndex) {
                        n7 = n6;
                    }
                    nArray[n6++] = i2;
                }
                if (n7 + n4 >= 0 && n7 + n4 < n6) {
                    n3 = nArray[n7 + n4];
                } else {
                    if (this.showChevron) {
                        CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                        cTabFolderEvent.widget = this;
                        cTabFolderEvent.time = event.time;
                        cTabFolderEvent.x = this.chevronRect.x;
                        cTabFolderEvent.y = this.chevronRect.y;
                        cTabFolderEvent.width = this.chevronRect.width;
                        cTabFolderEvent.height = this.chevronRect.height;
                        cTabFolderEvent.doit = true;
                        for (int i3 = 0; i3 < this.folderListeners.length; ++i3) {
                            this.folderListeners[i3].showList(cTabFolderEvent);
                        }
                        if (cTabFolderEvent.doit && !this.isDisposed()) {
                            this.showList(this.chevronRect);
                        }
                    }
                    return true;
                }
            }
        }
        this.setSelection(n3, true);
        return true;
    }

    void onPaint(Event event) {
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        this.drawBody(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.drawTabArea(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize() {
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n2 = Math.min(point.x, this.oldSize.x);
            if (point.x != this.oldSize.x) {
                n2 -= this.borderRight + this.highlight_margin;
            }
            if (!this.simple) {
                n2 -= 5;
            }
            int n3 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n3 -= this.borderBottom + this.highlight_margin;
            }
            int n4 = Math.max(point.x, this.oldSize.x);
            int n5 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n3, n4, n5 - n3, false);
            this.redraw(n2, 0, n4 - n2, n5, false);
        }
        this.oldSize = point;
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        if (this.onBottom) {
            this.redraw(0, point.y - this.borderBottom - this.tabHeight - this.highlight_header - 1, point.x, this.borderBottom + this.tabHeight + this.highlight_header + 1, false);
        } else {
            this.redraw(0, 0, point.x, this.borderTop + this.tabHeight + this.highlight_header + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.folderListeners.length; ++i2) {
            if (cTabFolder2Listener != this.folderListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n2);
        System.arraycopy(this.folderListeners, n2 + 1, cTabFolder2ListenerArray, n2, this.folderListeners.length - n2 - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.tabListeners.length; ++i2) {
            if (cTabFolderListener != this.tabListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n2);
        System.arraycopy(this.tabListeners, n2 + 1, cTabFolderListenerArray, n2, this.tabListeners.length - n2 - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 <= 0 || nArray[n2] >= nArray[n2 - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.bgImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                int n3;
                n2 = 0;
                for (n3 = 0; n3 < this.gradientColors.length && (n2 = this.gradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.gradientColors[n3].equals(colorArray[n3]) ? 1 : 0)) != 0; ++n3) {
                }
                if (n2 != 0) {
                    for (n3 = 0; n3 < this.gradientPercents.length; ++n3) {
                        int n4 = n2 = this.gradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                    }
                }
                if (n2 != 0 && this.gradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.bgImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground((Color)null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                this.gradientColors[n2] = colorArray[n2];
            }
            this.gradientPercents = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.gradientPercents[n2] = nArray[n2];
            }
            this.gradientVertical = bl;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    void setBackground(Image image) {
        this.checkWidget();
        if (image == this.bgImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.bgImage = image;
        this.redraw();
    }

    public void setBorderVisible(boolean bl) {
        this.checkWidget();
        if (this.borderLeft == 1 == bl) {
            return;
        }
        this.borderRight = bl ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds() {
        int n2;
        int n3;
        int n4;
        Point point = this.getSize();
        int n5 = this.maxRect.x;
        int n6 = this.maxRect.y;
        int n7 = this.maxRect.width;
        int n8 = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = point.x - this.borderRight - 18 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.maxRect.width = 18;
            this.maxRect.height = 18;
        }
        if (n5 != this.maxRect.x || n7 != this.maxRect.width || n6 != this.maxRect.y || n8 != this.maxRect.height) {
            n4 = Math.min(n5, this.maxRect.x);
            n3 = Math.max(n5 + n7, this.maxRect.x + this.maxRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n4, n2, n3 - n4, this.tabHeight, false);
        }
        n5 = this.minRect.x;
        n6 = this.minRect.y;
        n7 = this.minRect.width;
        n8 = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = point.x - this.borderRight - this.maxRect.width - 18 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.minRect.width = 18;
            this.minRect.height = 18;
        }
        if (n5 != this.minRect.x || n7 != this.minRect.width || n6 != this.minRect.y || n8 != this.minRect.height) {
            n4 = Math.min(n5, this.minRect.x);
            n3 = Math.max(n5 + n7, this.minRect.x + this.minRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n4, n2, n3 - n4, this.tabHeight, false);
        }
        n5 = this.topRightRect.x;
        n6 = this.topRightRect.y;
        n7 = this.topRightRect.width;
        n8 = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    n4 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n4 -= 2;
                    }
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = n4 - this.topRightRect.x;
                        } else {
                            CTabItem cTabItem = this.items[this.selectedIndex];
                            if (cTabItem.x + cTabItem.width + 7 + 27 >= n4) break;
                            this.topRightRect.x = cTabItem.x + cTabItem.width + 7 + 27;
                            this.topRightRect.width = n4 - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            CTabItem cTabItem = this.items[this.items.length - 1];
                            this.topRightRect.x = cTabItem.x + cTabItem.width;
                            if (!this.simple && this.items.length - 1 == this.selectedIndex) {
                                this.topRightRect.x += this.curveWidth - this.curveIndent;
                            }
                        }
                        this.topRightRect.width = Math.max(0, n4 - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point point2 = this.topRight.computeSize(-1, this.tabHeight, false);
                    n3 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n3 -= 2;
                    }
                    this.topRightRect.x = n3 - point2.x;
                    this.topRightRect.width = point2.x;
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (n5 != this.topRightRect.x || n7 != this.topRightRect.width || n6 != this.topRightRect.y || n8 != this.topRightRect.height) {
            int n9 = Math.min(n5, this.topRightRect.x);
            int n10 = Math.max(n5 + n7, this.topRightRect.x + this.topRightRect.width);
            n2 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n9, n2, n10 - n9, this.tabHeight, false);
        }
        n5 = this.chevronRect.x;
        n6 = this.chevronRect.y;
        n7 = this.chevronRect.width;
        n8 = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = 27;
                this.chevronRect.height = 18;
                int n11 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem cTabItem = this.items[this.selectedIndex];
                    int n12 = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        n12 -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(cTabItem.x + cTabItem.width + 3, n12);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 27;
            this.chevronRect.height = 18;
            int n13 = 0;
            int n14 = -1;
            while (n13 < this.priority.length && this.items[this.priority[n13]].showing) {
                n14 = Math.max(n14, this.priority[n13++]);
            }
            if (n14 == -1) {
                n14 = this.firstIndex;
            }
            CTabItem cTabItem = this.items[n14];
            int n15 = cTabItem.x + cTabItem.width + 3;
            if (!this.simple && n14 == this.selectedIndex) {
                n15 += this.curveWidth - 2 * this.curveIndent;
            }
            this.chevronRect.x = Math.min(n15, this.getRightItemEdge());
            int n16 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (n5 != this.chevronRect.x || n7 != this.chevronRect.width || n6 != this.chevronRect.y || n8 != this.chevronRect.height) {
            int n17 = Math.min(n5, this.chevronRect.x);
            int n18 = Math.max(n5 + n7, this.chevronRect.x + this.chevronRect.width);
            int n19 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n17, n19, n18 - n17, this.tabHeight, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl) {
        this.checkWidget();
    }

    public void setInsertMark(int n2, boolean bl) {
        this.checkWidget();
        if (n2 < -1 || n2 >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        int n2;
        boolean bl = false;
        if (this.items.length == 0) {
            return false;
        }
        Point point = this.getSize();
        int n3 = n2 = this.onBottom ? Math.max(this.borderBottom, point.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int n4 = this.getDisplay().getBounds().width + 10;
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                CTabItem cTabItem = this.items[i2];
                if (i2 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n5 = cTabItem.x;
                    int n6 = cTabItem.y;
                    cTabItem.x = this.borderLeft;
                    cTabItem.y = n2;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = this.borderLeft + 4;
                        int n7 = cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    }
                    if (cTabItem.x == n5 && cTabItem.y == n6) continue;
                    bl = true;
                    continue;
                }
                cTabItem.x = n4;
                cTabItem.showing = false;
            }
        } else {
            int n8;
            int n9 = this.getRightItemEdge();
            int n10 = n9 - this.borderLeft;
            int n11 = 0;
            for (n8 = 0; n8 < this.priority.length; ++n8) {
                CTabItem cTabItem = this.items[this.priority[n8]];
                boolean bl2 = n8 == 0 ? true : (cTabItem.showing = cTabItem.width > 0 && (n11 += cTabItem.width) <= n10);
                if (this.simple || this.priority[n8] != this.selectedIndex) continue;
                n11 += this.curveWidth - 2 * this.curveIndent;
            }
            n8 = 0;
            int n12 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            for (int i3 = 0; i3 < this.items.length; ++i3) {
                CTabItem cTabItem = this.items[i3];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n12) {
                        bl = true;
                    }
                    cTabItem.x = n12;
                    continue;
                }
                this.firstIndex = Math.min(this.firstIndex, i3);
                if (cTabItem.x != n8 || cTabItem.y != n2) {
                    bl = true;
                }
                cTabItem.x = n8;
                cTabItem.y = n2;
                if (i3 == this.selectedIndex) {
                    int n13 = Math.min(cTabItem.x + cTabItem.width, n9);
                    cTabItem.closeRect.x = n13 - 4 - 18;
                } else {
                    cTabItem.closeRect.x = cTabItem.x + cTabItem.width - 4 - 18;
                }
                cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                n8 += cTabItem.width;
                if (this.simple || i3 != this.selectedIndex) continue;
                n8 += this.curveWidth - 2 * this.curveIndent;
            }
        }
        return bl;
    }

    boolean setItemSize() {
        int n2;
        int[] nArray;
        int n3;
        boolean bl = false;
        if (this.isDisposed()) {
            return bl;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                GC gC = new GC(this);
                int n4 = cTabItem.preferredWidth(gC, true, false);
                gC.dispose();
                n4 = Math.min(n4, this.getRightItemEdge() - this.borderLeft);
                if (cTabItem.height != this.tabHeight || cTabItem.width != n4) {
                    bl = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n4;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.width = 18;
                        cTabItem.closeRect.height = 18;
                    }
                }
            }
            return bl;
        }
        if (this.items.length == 0) {
            return bl;
        }
        GC gC = new GC(this);
        int n5 = point.x - this.borderLeft - this.borderRight - 3;
        if (this.showMin) {
            n5 -= 18;
        }
        if (this.showMax) {
            n5 -= 18;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point point2 = this.topRight.computeSize(-1, -1, false);
            n5 -= point2.x + 3;
        }
        if (!this.simple) {
            n5 -= this.curveWidth - 2 * this.curveIndent;
        }
        n5 = Math.max(0, n5);
        int n6 = 0;
        int[] nArray2 = new int[this.items.length];
        for (n3 = 0; n3 < this.priority.length; ++n3) {
            int n7 = this.priority[n3];
            nArray2[n7] = this.items[n7].preferredWidth(gC, n7 == this.selectedIndex, true);
            if ((n6 += nArray2[n7]) > n5) break;
        }
        if (n6 > n5) {
            boolean bl2 = this.showChevron = this.items.length > 1;
            if (this.showChevron) {
                n5 -= 27;
            }
            nArray = nArray2;
            int n8 = n3 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n5 < nArray[n3]) {
                nArray[n3] = Math.max(0, n5);
            }
        } else {
            n3 = 0;
            int[] nArray3 = new int[this.items.length];
            for (n2 = 0; n2 < this.items.length; ++n2) {
                nArray3[n2] = this.items[n2].preferredWidth(gC, n2 == this.selectedIndex, false);
                n3 += nArray3[n2];
            }
            if (n3 <= n5) {
                nArray = nArray3;
            } else {
                int n9;
                n2 = (n5 - n6) / this.items.length;
                while (true) {
                    n9 = 0;
                    int n10 = 0;
                    for (int i2 = 0; i2 < this.items.length; ++i2) {
                        if (nArray3[i2] > nArray2[i2] + n2) {
                            n10 += nArray2[i2] + n2;
                            ++n9;
                            continue;
                        }
                        n10 += nArray3[i2];
                    }
                    if (n10 >= n5) {
                        --n2;
                        break;
                    }
                    if (n9 == 0 || n5 - n10 < n9) break;
                    ++n2;
                }
                nArray = new int[this.items.length];
                for (n9 = 0; n9 < this.items.length; ++n9) {
                    nArray[n9] = Math.min(nArray3[n9], nArray2[n9] + n2);
                }
            }
        }
        gC.dispose();
        for (n3 = 0; n3 < this.items.length; ++n3) {
            CTabItem cTabItem = this.items[n3];
            n2 = nArray[n3];
            if (cTabItem.height == this.tabHeight && cTabItem.width == n2) continue;
            bl = true;
            cTabItem.shortenedText = null;
            cTabItem.shortenedTextWidth = 0;
            cTabItem.height = this.tabHeight;
            cTabItem.width = n2;
            cTabItem.closeRect.height = 0;
            cTabItem.closeRect.width = 0;
            if (!this.showClose && !cTabItem.showClose || n3 != this.selectedIndex && !this.showUnselectedClose) continue;
            cTabItem.closeRect.width = 18;
            cTabItem.closeRect.height = 18;
        }
        return bl;
    }

    public void setMaximizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMax == bl) {
            return;
        }
        this.showMax = bl;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        if (this.maximized == bl) {
            return;
        }
        if (bl && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMin == bl) {
            return;
        }
        this.showMin = bl;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        if (bl && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            SWT.error(6);
        }
        if (this.minChars == n2) {
            return;
        }
        this.minChars = n2;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean bl) {
        this.checkWidget();
        if (this.mru == bl) {
            return;
        }
        this.mru = bl;
        if (!this.mru) {
            int n2 = this.firstIndex;
            int n3 = 0;
            int n4 = this.firstIndex;
            while (n4 < this.items.length) {
                this.priority[n3++] = n4++;
            }
            n4 = 0;
            while (n4 < n2) {
                this.priority[n3++] = n4++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n2 = this.indexOf(cTabItem);
        this.setSelection(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n2];
        if (this.selectedIndex == n2) {
            this.showItem(cTabItem);
            return;
        }
        int n3 = this.selectedIndex;
        this.selectedIndex = n2;
        if (n3 != -1) {
            this.items[n3].closeImageState = 0;
        }
        cTabItem.closeImageState = 1;
        cTabItem.showing = false;
        Control control = cTabItem.control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (n3 != -1 && (control = this.items[n3].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n2, boolean bl) {
        int n3 = this.selectedIndex;
        this.setSelection(n2);
        if (bl && this.selectedIndex != n3 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 <= 0 || nArray[n2] >= nArray[n2 - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == colorArray.length) {
                int n3;
                n2 = 0;
                for (n3 = 0; n3 < this.selectionGradientColors.length && (n2 = this.selectionGradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.selectionGradientColors[n3].equals(colorArray[n3]) ? 1 : 0)) != 0; ++n3) {
                }
                if (n2 != 0) {
                    for (n3 = 0; n3 < this.selectionGradientPercents.length; ++n3) {
                        int n4 = n2 = this.selectionGradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                    }
                }
                if (n2 != 0 && this.selectionGradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
        } else {
            this.selectionGradientColors = new Color[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                this.selectionGradientColors[n2] = colorArray[n2];
            }
            this.selectionGradientPercents = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.selectionGradientPercents[n2] = nArray[n2];
            }
            this.selectionGradientVertical = bl;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
        }
        this.selectionBgImage = image;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean bl) {
        this.checkWidget();
        if (this.simple != bl) {
            this.simple = bl;
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean bl) {
        this.checkWidget();
        if (this.single != bl) {
            this.single = bl;
            if (!bl) {
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    if (i2 == this.selectedIndex || this.items[i2].closeImageState != 1) continue;
                    this.items[i2].closeImageState = 0;
                }
            }
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n2;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int n2) {
        this.checkWidget();
        if (n2 != 128 && n2 != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n2 == 1024)) {
            this.onBottom = n2 == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n2) {
        this.checkWidget();
        if (n2 != 131072 && n2 != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = n2;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedClose == bl) {
            return;
        }
        this.showUnselectedClose = bl;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedImage == bl) {
            return;
        }
        this.showUnselectedImage = bl;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem cTabItem) {
        int n2;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n3 = -1;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (this.priority[i2] != n2) continue;
            n3 = i2;
            break;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n3);
            System.arraycopy(this.priority, n3 + 1, nArray, n3 + 1, this.priority.length - n3 - 1);
            nArray[0] = n2;
            this.priority = nArray;
        }
        if (cTabItem.isShowing()) {
            return;
        }
        this.updateItems(n2);
        this.redrawTabs();
    }

    void showList(Rectangle rectangle) {
        Object object;
        int n2;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            for (n2 = 0; n2 < menuItemArray.length; ++n2) {
                menuItemArray[n2].dispose();
            }
        }
        for (n2 = 0; n2 < this.items.length; ++n2) {
            CTabItem cTabItem = this.items[n2];
            if (cTabItem.showing) continue;
            object = new MenuItem(this.showMenu, 0);
            ((MenuItem)object).setText(cTabItem.getText());
            ((MenuItem)object).setImage(cTabItem.getImage());
            ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
            ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e2) {
                    MenuItem menuItem = (MenuItem)e2.widget;
                    int index = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                    CTabFolder.this.setSelection(index, true);
                }
            });
        }
        n2 = rectangle.x;
        int n3 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n2, n3);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n2, int n3) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n2, n3);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n2) {
        int n3;
        int n4;
        if (!this.single && !this.mru && n2 != -1) {
            int n5;
            n4 = n2;
            if (this.priority[0] < n2) {
                int n6;
                n3 = this.getRightItemEdge() - this.borderLeft;
                if (!this.simple) {
                    n3 -= this.curveWidth - 2 * this.curveIndent;
                }
                n5 = 0;
                int[] nArray = new int[this.items.length];
                GC gC = new GC(this);
                for (n6 = this.priority[0]; n6 <= n2; ++n6) {
                    nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                    if ((n5 += nArray[n6]) > n3) break;
                }
                if (n5 > n3) {
                    n5 = 0;
                    n6 = n2;
                    while (n6 >= 0) {
                        if (nArray[n6] == 0) {
                            nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                        }
                        if ((n5 += nArray[n6]) <= n3) {
                            n4 = n6--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n4 = this.priority[0];
                    for (n6 = n2 + 1; n6 < this.items.length; ++n6) {
                        nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                        if ((n5 += nArray[n6]) >= n3) break;
                    }
                    if (n5 < n3) {
                        n6 = this.priority[0] - 1;
                        while (n6 >= 0) {
                            if (nArray[n6] == 0) {
                                nArray[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
                            }
                            if ((n5 += nArray[n6]) <= n3) {
                                n4 = n6--;
                                continue;
                            }
                            break;
                        }
                    }
                }
                gC.dispose();
            }
            if (n4 != this.priority[0]) {
                n3 = 0;
                n5 = n4;
                while (n5 < this.items.length) {
                    this.priority[n3++] = n5++;
                }
                n5 = 0;
                while (n5 < n4) {
                    this.priority[n3++] = n5++;
                }
            }
        }
        n4 = this.showChevron;
        n3 = this.setItemSize();
        n3 |= this.setItemLocation();
        this.setButtonBounds();
        if ((n3 |= this.showChevron != n4 ? 1 : 0) != 0 && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        return n3 != 0;
    }

    boolean updateTabHeight(boolean bl) {
        int n2;
        int n3 = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            n2 = 0;
            GC gC = new GC(this);
            if (this.items.length == 0) {
                n2 = gC.textExtent((String)"Default", (int)9).y + 2 + 2;
            } else {
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    n2 = Math.max(n2, this.items[i2].preferredHeight(gC));
                }
            }
            gC.dispose();
            this.tabHeight = n2;
        }
        if (!bl && this.tabHeight == n3) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            n2 = this.tabHeight - 12;
            this.curve = new int[]{0, 13 + n2, 0, 12 + n2, 2, 12 + n2, 3, 11 + n2, 5, 11 + n2, 6, 10 + n2, 7, 10 + n2, 9, 8 + n2, 10, 8 + n2, 11, 7 + n2, 11 + n2, 7, 12 + n2, 6, 13 + n2, 6, 15 + n2, 4, 16 + n2, 4, 17 + n2, 3, 19 + n2, 3, 20 + n2, 2, 22 + n2, 2, 23 + n2, 1};
            this.curveWidth = 26 + n2;
            this.curveIndent = this.curveWidth / 3;
        } else {
            n2 = this.tabHeight - 12;
            this.curve = new int[]{0, 0, 0, 1, 2, 1, 3, 2, 5, 2, 6, 3, 7, 3, 9, 5, 10, 5, 11, 6, 11 + n2, 6 + n2, 12 + n2, 7 + n2, 13 + n2, 7 + n2, 15 + n2, 9 + n2, 16 + n2, 9 + n2, 17 + n2, 10 + n2, 19 + n2, 10 + n2, 20 + n2, 11 + n2, 22 + n2, 11 + n2, 23 + n2, 12 + n2};
            this.curveWidth = 26 + n2;
            this.curveIndent = this.curveWidth / 3;
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int n2, int n3) {
        if (this.showMin && this.minRect.contains(n2, n3)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(n2, n3)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(n2, n3)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem cTabItem = this.getItem(new Point(n2, n3));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n2, n3)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }

    static {
        TOP_LEFT_CORNER = new int[]{0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0};
        TOP_RIGHT_CORNER = new int[]{-6, 0, -5, 1, -4, 1, -1, 4, -1, 5, 0, 6};
        BOTTOM_LEFT_CORNER = new int[]{0, -6, 1, -5, 1, -4, 4, -1, 5, -1, 6, 0};
        BOTTOM_RIGHT_CORNER = new int[]{-6, 0, -5, -1, -4, -1, -1, -4, -1, -5, 0, -6};
        SIMPLE_TOP_LEFT_CORNER = new int[]{0, 2, 1, 1, 2, 0};
        SIMPLE_TOP_RIGHT_CORNER = new int[]{-2, 0, -1, 1, 0, 2};
        SIMPLE_BOTTOM_LEFT_CORNER = new int[]{0, -2, 1, -1, 2, 0};
        SIMPLE_BOTTOM_RIGHT_CORNER = new int[]{-2, 0, -1, -1, 0, -2};
        CLOSE_FILL = new RGB(252, 160, 160);
    }
}

