/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.NoDragAndDropEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragAndDropEffect effect;
    int dataEffect = 0;
    static final String DRAGSOURCEID = "DragSource";
    Image dragCursor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int n2) {
        super(control, DragSource.checkStyle(n2));
        int n3;
        Object object;
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Transferable(this){
            final /* synthetic */ SWTDragGestureListener this$1;
            private final /* synthetic */ DataFlavor[] val$flavors;
            private final /* synthetic */ Transferable[] val$transferables;
            {
                this.this$1 = sWTDragGestureListener;
                this.val$flavors = dataFlavorArray;
                this.val$transferables = transferableArray;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                int i2 = 0;
                while (i2 < this.val$flavors.length) {
                    if (this.val$flavors[i2].equals(flavor)) {
                        try {
                            return this.val$transferables[i2].getTransferData(flavor);
                        }
                        catch (IOException iOException) {
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return (DataFlavor[])this.val$flavors.clone();
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                int i2 = 0;
                while (i2 < this.val$flavors.length) {
                    if (this.val$flavors[i2].equals(flavor)) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, (Listener)((Object)new java.awt.dnd.DragSourceListener(this){
            int action;
            final /* synthetic */ SWTDragGestureListener this$1;
            {
                this.this$1 = sWTDragGestureListener;
            }

            public void dragEnter(DragSourceDragEvent e2) {
                Utils.modifiersEx = e2.getGestureModifiersEx();
                Utils.storeModifiersEx(Utils.modifiersEx);
                this.action = e2.getDropAction();
            }

            public void dragOver(DragSourceDragEvent e2) {
                Utils.modifiersEx = e2.getGestureModifiersEx();
                Utils.storeModifiersEx(Utils.modifiersEx);
                this.action = e2.getDropAction();
            }

            public void dropActionChanged(DragSourceDragEvent e2) {
                Utils.modifiersEx = e2.getGestureModifiersEx();
                Utils.storeModifiersEx(Utils.modifiersEx);
                this.action = e2.getDropAction();
            }

            public void dragExit(DragSourceEvent e2) {
            }

            public void dragDropEnd(DragSourceDropEvent e2) {
                Utils.isLocalDragAndDropInProgress = false;
                DNDEvent event = new DNDEvent();
                event.widget = this.this$1.DragSource.this;
                event.time = Utils.getCurrentTime();
                event.doit = e2.getDropSuccess() || this.action == 0;
                event.detail = Utils.convertDnDActionsToSWT(e2.getDropAction());
                this.this$1.DragSource.this.notifyListeners(2000, event);
                ((SWTDragGestureListener)this.this$1).DragSource.this.dataEffect = 0;
            }
        }));
        boolean bl = true;
        try {
            System.setProperty("awt.dnd.drag.threshold", "0");
            object = (class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = DragSource.class$((String)"java.awt.Toolkit")) : class$java$awt$Toolkit).getDeclaredMethod("setDesktopProperty", class$java$lang$String == null ? (class$java$lang$String = DragSource.class$((String)"java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = DragSource.class$((String)"java.lang.Object")) : class$java$lang$Object);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)Toolkit.getDefaultToolkit(), "DnD.gestureMotionThreshold", new Integer(0));
            ((Method)object).setAccessible(false);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        object = ((CControl)((Object)control.handle)).getSwingComponent();
        MouseListener[] mouseListenerArray = ((Component)object).getMouseListeners();
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            ((Component)object).removeMouseListener(mouseListenerArray[i2]);
        }
        MouseMotionListener[] mouseMotionListenerArray = ((Component)object).getMouseMotionListeners();
        for (n3 = 0; n3 < mouseMotionListenerArray.length; ++n3) {
            ((Component)object).removeMouseMotionListener(mouseMotionListenerArray[n3]);
        }
        if (bl) {
            java.awt.dnd.DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(((CControl)((Object)control.handle)).getSwingComponent(), Utils.convertDnDActionsToSwing(n2), new SWTDragGestureListener());
        } else {
            new SWTDragGestureRecognizer(java.awt.dnd.DragSource.getDefaultDragSource(), (Component)object, Utils.convertDnDActionsToSwing(n2), new SWTDragGestureListener());
        }
        for (n3 = 0; n3 < mouseListenerArray.length; ++n3) {
            ((Component)object).addMouseListener(mouseListenerArray[n3]);
        }
        for (n3 = 0; n3 < mouseMotionListenerArray.length; ++n3) {
            ((Component)object).addMouseMotionListener(mouseMotionListenerArray[n3]);
        }
        this.effect = new NoDragAndDropEffect(control);
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$((String)"org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }

    static /* synthetic */ void access$000(DragSource dragSource) {
        dragSource.onDispose();
    }

    class SWTDragGestureListener
    implements DragGestureListener {
        SWTDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e2) {
            if (DragSource.this.isDisposed()) {
                return;
            }
            Point dragOrigin = e2.getDragOrigin();
            DNDEvent event = new DNDEvent();
            event.widget = DragSource.this;
            event.x = dragOrigin.x;
            event.y = dragOrigin.y;
            event.time = Utils.getCurrentTime();
            event.doit = true;
            DragSource.this.notifyListeners(2008, event);
            if (!event.doit || DragSource.this.transferAgents == null || DragSource.this.transferAgents.length == 0) {
                return;
            }
            TransferData transferData = new TransferData();
            event = new DNDEvent();
            event.widget = DragSource.this;
            event.time = Utils.getCurrentTime();
            event.dataType = transferData;
            DragSource.this.notifyListeners(2001, event);
            ArrayList<Transferable> transferableList = new ArrayList<Transferable>();
            ArrayList<DataFlavor> flavorList = new ArrayList<DataFlavor>();
            int i2 = 0;
            while (i2 < DragSource.this.transferAgents.length) {
                transferData = new TransferData();
                Transfer transfer = DragSource.this.transferAgents[i2];
                transferData.dataFlavor = transfer.getDataFlavor();
                transfer.javaToNative(event.data, transferData);
                flavorList.add(transferData.dataFlavor);
                transferableList.add(transferData.transferable);
                ++i2;
            }
            Transferable[] transferables = transferableList.toArray(new Transferable[0]);
            DataFlavor[] flavors = flavorList.toArray(new DataFlavor[0]);
            Transferable transferable = new /* invalid duplicate definition of identical inner class */;
            Display display = DragSource.this.control.getDisplay();
            ImageData imageData = DragSource.this.effect.getDragSourceImage(dragOrigin.x, dragOrigin.y);
            DragSource.this.dragCursor = null;
            if (imageData != null) {
                DragSource.this.dragCursor = new Image((Device)display, imageData);
            }
            Utils.isLocalDragAndDropInProgress = true;
            e2.getDragSource().startDrag(e2, null, transferable, new /* invalid duplicate definition of identical inner class */);
        }
    }

    class SWTDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        protected SWTDragGestureRecognizer(java.awt.dnd.DragSource dragsource, Component component, int actions, DragGestureListener draggesturelistener) {
            super(dragsource, component, actions, draggesturelistener);
        }

        public void mouseClicked(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
            this.events.clear();
            if (this.getDragAction(e2) != 0) {
                this.appendEvent(e2);
            }
        }

        public void mouseReleased(MouseEvent e2) {
            this.events.clear();
        }

        public void mouseEntered(MouseEvent e2) {
            this.events.clear();
        }

        public void mouseExited(MouseEvent e2) {
            int dragAction;
            if (!this.events.isEmpty() && (dragAction = this.getDragAction(e2)) == 0) {
                this.events.clear();
            }
        }

        public void mouseDragged(MouseEvent e2) {
            if (!this.events.isEmpty()) {
                int dragAction = this.getDragAction(e2);
                if (dragAction == 0) {
                    return;
                }
                this.fireDragGestureRecognized(dragAction, ((MouseEvent)this.getTriggerEvent()).getPoint());
            }
        }

        public void mouseMoved(MouseEvent mouseevent) {
        }

        protected int getDragAction(MouseEvent e2) {
            int modifiers = e2.getModifiersEx();
            if ((modifiers & 0x400) == 0) {
                return 0;
            }
            int dropAction = 0;
            int sourceActions = this.getSourceActions();
            switch (modifiers & 0xC0) {
                case 128: {
                    dropAction = 1;
                    break;
                }
                case 64: {
                    dropAction = 2;
                    break;
                }
                case 192: {
                    dropAction = 0x40000000;
                    break;
                }
                default: {
                    if ((sourceActions & 1) != 0) {
                        dropAction = 1;
                        break;
                    }
                    if ((sourceActions & 2) != 0) {
                        dropAction = 2;
                        break;
                    }
                    if ((sourceActions & 0x40000000) == 0) break;
                    dropAction = 0x40000000;
                }
            }
            return dropAction & sourceActions;
        }
    }
}

