/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(new File(stringArray[i2]));
        }
        transferData.transferable = new Transferable(){

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return fileList;
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return FileTransfer.this.getDataFlavor().equals(flavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{FileTransfer.this.getDataFlavor()};
            }
        };
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.transferable == null) {
            return null;
        }
        List list = (List)super.nativeToJava(transferData);
        File[] fileArray = list.toArray(new File[0]);
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = fileArray[i2].getAbsolutePath();
        }
        return stringArray;
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null && stringArray[i2].length() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }

    protected DataFlavor getDataFlavor() {
        return DataFlavor.javaFileListFlavor;
    }
}

