/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class RTFTransfer
extends Transfer {
    private static RTFTransfer _instance = new RTFTransfer();
    static DataFlavor RTF_FLAVOR = new DataFlavor("text/rtf", "RTF Text");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.transferable = new Transferable(){

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return new ByteArrayInputStream(((String)object).getBytes());
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return RTFTransfer.this.getDataFlavor().equals(flavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{RTFTransfer.this.getDataFlavor()};
            }
        };
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.transferable == null) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader((ByteArrayInputStream)super.nativeToJava(transferData));
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[128];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }

    public TransferData[] getSupportedTypes() {
        TransferData transferData = new TransferData();
        transferData.dataFlavor = RTF_FLAVOR;
        return new TransferData[]{transferData};
    }

    protected DataFlavor getDataFlavor() {
        return RTF_FLAVOR;
    }
}

