/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalScrollButton;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;

public class ArrowButton
extends BasicArrowButton {
    protected BasicArrowButton arrowButton;

    public ArrowButton(int n2) {
        super(n2);
        this.setBorder(LookAndFeelUtils.getButtonBorder());
        this.createArrowButton();
    }

    public void paint(Graphics graphics) {
        if (this.arrowButton != null) {
            Dimension dimension = this.getSize();
            this.arrowButton.setSize(dimension);
            this.arrowButton.paint(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void setDirection(int n2) {
        if (n2 == this.getDirection()) {
            return;
        }
        super.setDirection(n2);
        this.createArrowButton();
        this.repaint();
    }

    protected void createArrowButton() {
        Boolean bl = Utils.isUsingDefaultArrowButtons();
        if (bl != null && bl.booleanValue()) {
            return;
        }
        this.arrowButton = null;
        this.setPreferredSize(null);
        JScrollBar jScrollBar = new JScrollBar();
        Component[] componentArray = jScrollBar.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (!(component instanceof BasicArrowButton)) continue;
            if (bl == null && component instanceof MetalScrollButton) {
                return;
            }
            this.arrowButton = (BasicArrowButton)component;
            this.arrowButton.setDirection(this.direction);
            this.arrowButton.setModel(this.getModel());
            int n2 = jScrollBar.getPreferredSize().width;
            this.setPreferredSize(new Dimension(n2, n2));
            return;
        }
    }
}

