/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.swt.internal.swing.CCombo;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class CComboSimple
extends JPanel
implements CCombo {
    protected Combo handle;
    protected JTextField textField;
    protected JScrollPane scrollPane;
    protected JList list;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;
    protected int textLimit = Combo.LIMIT;

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CComboSimple(Combo combo, int n2) {
        super(new BorderLayout(0, 0));
        this.textField = new JTextField(7){

            public Color getBackground() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.background != null ? CComboSimple.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.foreground != null ? CComboSimple.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.font != null ? CComboSimple.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (CComboSimple.this == null || CComboSimple.this.userAttributeHandler == null) {
                    return super.getCursor();
                }
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                Composite parent = CComboSimple.this.handle;
                while (parent != null && parent.handle != null) {
                    Cursor cursor = ((CControl)((Object)parent.handle)).getUserAttributeHandler().cursor;
                    if (cursor != null) {
                        return cursor;
                    }
                    parent = parent.getParent();
                }
                return super.getCursor();
            }

            public boolean isOpaque() {
                return CComboSimple.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CComboSimple.this.backgroundImageIcon);
                super.paintComponent(g2);
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.textField);
        this.add((Component)this.textField, "North");
        this.scrollPane = new JScrollPane();
        this.list = new JList(new DefaultListModel()){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension preferredSize = this.getPreferredSize();
                preferredSize.width += CComboSimple.this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
                preferredSize.height += CComboSimple.this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
                return preferredSize;
            }

            public Color getBackground() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.background != null ? CComboSimple.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.foreground != null ? CComboSimple.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.font != null ? CComboSimple.this.userAttributeHandler.font : super.getFont();
            }

            public boolean isOpaque() {
                return CComboSimple.this.backgroundImageIcon == null && super.isOpaque();
            }
        };
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public boolean isOpaque() {
                return CComboSimple.this.list.isOpaque() && super.isOpaque();
            }
        });
        JViewport jViewport = new JViewport(){

            public boolean isOpaque() {
                return CComboSimple.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CComboSimple.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CComboSimple.this != null && CComboSimple.this.userAttributeHandler != null && CComboSimple.this.userAttributeHandler.background != null ? CComboSimple.this.userAttributeHandler.background : super.getBackground();
            }
        };
        this.scrollPane.setViewport(jViewport);
        jViewport.setView(this.list);
        this.list.setSelectionMode(0);
        this.add((Component)this.scrollPane, "Center");
        this.handle = combo;
        this.init(n2);
    }

    protected void init(int n2) {
        Utils.installMouseListener(this.list, this.handle);
        Utils.installKeyListener(this.list, this.handle);
        Utils.installFocusListener(this.list, this.handle);
        Utils.installComponentListener(this.list, this.handle);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                Object item = CComboSimple.this.list.getSelectedValue();
                if (item != null) {
                    CComboSimple.this.textField.setText(String.valueOf(item));
                }
            }
        });
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CComboSimple.this.handle.processEvent(e2);
            }
        });
        ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(new DocumentFilter(){

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (CComboSimple.this.getEditorText().length() - length + text.length() > CComboSimple.this.getEditorTextLimit()) {
                    return;
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.list.setEnabled(bl);
    }

    public JScrollBar getHorizontalScrollBar() {
        return null;
    }

    public JScrollBar getVerticalScrollBar() {
        return null;
    }

    public Container getClientArea() {
        return this;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.textField.setOpaque(true);
                this.list.setOpaque(true);
                this.scrollPane.setOpaque(true);
                this.scrollPane.getViewport().setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.textField.setOpaque(false);
                this.list.setOpaque(false);
                this.scrollPane.setOpaque(false);
                this.scrollPane.getViewport().setOpaque(false);
            }
        }
    }

    public void addItem(Object object) {
        ((DefaultListModel)this.list.getModel()).addElement(object);
    }

    public Object getItemAt(int n2) {
        return this.list.getModel().getElementAt(n2);
    }

    public void removeItemAt(int n2) {
        ((DefaultListModel)this.list.getModel()).remove(n2);
    }

    public void removeAllItems() {
        ((DefaultListModel)this.list.getModel()).removeAllElements();
    }

    public void insertElementAt(Object object, int n2) {
        ((DefaultListModel)this.list.getModel()).add(n2, object);
    }

    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int n2) {
        Object e2 = this.list.getModel().getElementAt(n2);
        if (e2 != null) {
            this.list.setSelectedIndex(n2);
        }
    }

    public int getMaximumRowCount() {
        return this.list.getVisibleRowCount();
    }

    public void setMaximumRowCount(int n2) {
    }

    public String getEditorText() {
        return this.textField.getText();
    }

    public void setEditorText(String string) {
        this.textField.setText(string);
    }

    public void copyEditor() {
        this.textField.copy();
    }

    public void cutEditor() {
        this.textField.cut();
    }

    public void pasteEditor() {
        this.textField.paste();
    }

    public void setEditorCaretPosition(int n2) {
        this.textField.setCaretPosition(n2);
    }

    public int getEditorSelectionStart() {
        return this.textField.getSelectionStart();
    }

    public void setEditorSelectionStart(int n2) {
        this.textField.setSelectionStart(n2);
    }

    public int getEditorSelectionEnd() {
        return this.textField.getSelectionEnd();
    }

    public void setEditorSelectionEnd(int n2) {
        this.textField.setSelectionEnd(n2);
    }

    public void clearEditorSelection() {
        this.textField.setSelectionStart(this.textField.getSelectionEnd());
    }

    public void setEditorTextLimit(int n2) {
        this.textLimit = n2;
        String string = this.getEditorText();
        if (string.length() > n2) {
            this.setEditorText(string.substring(0, n2));
        }
    }

    public int getEditorTextLimit() {
        return this.textLimit;
    }

    public Dimension getEditorSize() {
        return this.textField.getSize();
    }

    public boolean isPopupVisible() {
        return false;
    }
}

