/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CLabel;
import org.eclipse.swt.internal.swing.JMultiLineLabel;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

class CLabelImplementation
extends JMultiLineLabel
implements CLabel {
    protected Label handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CLabelImplementation(Label label, int n2) {
        this.handle = label;
        LookAndFeelUtils.applyLabelStyle(this);
        this.userAttributeHandler = new CControl.UserAttributeHandler(this){

            public void setForeground(Color foreground) {
                super.setForeground(foreground);
                CLabelImplementation.this.adjustStyles();
            }

            public void setFont(Font font) {
                super.setFont(font);
                CLabelImplementation.this.adjustStyles();
            }
        };
        this.init(n2);
    }

    protected void init(int n2) {
        this.setFocusable(false);
        this.setWrapping((n2 & 0x40) != 0);
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        }
        if ((n2 & 0x20000) != 0) {
            this.setAlignment(4);
        } else if ((n2 & 0x1000000) != 0) {
            this.setAlignment(0);
        } else {
            this.setAlignment(2);
        }
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public boolean isOpaque() {
        return this.backgroundImageIcon == null && (this.userAttributeHandler != null && this.userAttributeHandler.background != null || super.isOpaque());
    }

    protected void paintComponent(Graphics graphics) {
        Utils.paintTiledImage(this, graphics, this.backgroundImageIcon);
        super.paintComponent(graphics);
    }

    public Container getClientArea() {
        return this;
    }

    public void setAlignment(int n2) {
        this.setHorizontalAlignment(n2);
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
    }
}

