/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.eclipse.swt.internal.swing.CButton;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CShell;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.ComponentBorderResizer;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.UnmanagedScrollPane;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class CShellFrame
extends JFrame
implements CShell {
    protected Container contentPane;
    protected JScrollPane scrollPane;
    protected Shell handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected boolean areActivationEventsBlocked;
    protected boolean isPaintActive = true;
    protected ImageIcon backgroundImageIcon;
    protected CShell.ModalityHandler modalityHandler = new CShell.ModalityHandler(this);
    protected boolean isModallyBlocked;
    protected boolean isEnabled = true;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public void setActivationEventsBlocked(boolean bl) {
        this.areActivationEventsBlocked = bl;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.areActivationEventsBlocked) {
            switch (aWTEvent.getID()) {
                case 205: 
                case 206: {
                    return;
                }
            }
        }
        super.processEvent(aWTEvent);
    }

    public CShellFrame(Shell shell, int n2) {
        this.handle = shell;
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.setLocationByPlatform(true);
        }
        this.init(n2);
    }

    protected void init(int n2) {
        JComponent jComponent;
        boolean bl;
        boolean bl2;
        this.resetFocusableState();
        this.setDefaultCloseOperation(0);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setSize(rectangle.width * 3 / 4, rectangle.height * 3 / 4);
        boolean bl3 = bl2 = (n2 & 0x10) != 0;
        if (!bl2) {
            this.setResizable(false);
        }
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.setAlwaysOnTop((n2 & 0x4000) != 0);
        }
        boolean bl4 = bl = (n2 & 0x20) != 0;
        if (bl) {
            if (JFrame.isDefaultLookAndFeelDecorated()) {
                this.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(1);
            } else {
                this.setUndecorated(!bl);
            }
        } else {
            jComponent = this.getRootPane();
            if (JFrame.isDefaultLookAndFeelDecorated()) {
                ((JRootPane)jComponent).setWindowDecorationStyle(0);
            }
            this.setUndecorated(!bl);
            if (bl2 || (n2 & 0x800) != 0) {
                jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.GRAY)));
                if (bl2) {
                    ComponentBorderResizer.handle(this, jComponent);
                }
            } else if (!bl && (n2 & 8) == 0) {
                jComponent.setBorder(LookAndFeelUtils.getDefaultWindowBorder());
            }
        }
        this.contentPane = this.getContentPane();
        jComponent = new JPanel(null){
            protected Graphics graphics;

            public Color getBackground() {
                return CShellFrame.this != null && CShellFrame.this.userAttributeHandler != null && CShellFrame.this.userAttributeHandler.background != null ? CShellFrame.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CShellFrame.this != null && CShellFrame.this.userAttributeHandler != null && CShellFrame.this.userAttributeHandler.foreground != null ? CShellFrame.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CShellFrame.this != null && CShellFrame.this.userAttributeHandler != null && CShellFrame.this.userAttributeHandler.font != null ? CShellFrame.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CShellFrame.this != null && CShellFrame.this.userAttributeHandler != null && CShellFrame.this.userAttributeHandler.cursor != null ? CShellFrame.this.userAttributeHandler.cursor : super.getCursor();
            }

            public Graphics getGraphics() {
                Graphics g2 = this.graphics != null ? this.graphics.create() : super.getGraphics();
                return g2;
            }

            public boolean isOptimizedDrawingEnabled() {
                return this.getComponentCount() < 2 || Utils.isFlatLayout(CShellFrame.this.handle);
            }

            protected void paintComponent(Graphics g2) {
                this.graphics = g2;
                this.putClientProperty("SWTSwingGraphics2DClientProperty", g2);
                super.paintComponent(g2);
                Utils.paintTiledImage(this, g2, CShellFrame.this.backgroundImageIcon);
                CShellFrame.this.handle.processEvent(new PaintEvent(this, 800, null));
                this.putClientProperty("SWTSwingGraphics2DClientProperty", null);
                this.graphics = null;
            }

            protected void addImpl(Component comp, Object constraints, int index) {
                CShellFrame.this.isPaintActive = true;
                super.addImpl(comp, constraints, index);
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(jComponent);
        if ((n2 & 0x300) != 0) {
            UnmanagedScrollPane unmanagedScrollPane = new UnmanagedScrollPane((n2 & 0x200) != 0 ? 22 : 21, (n2 & 0x100) != 0 ? 32 : 31);
            this.scrollPane = unmanagedScrollPane;
            unmanagedScrollPane.setBorder(null);
            this.contentPane.add((Component)unmanagedScrollPane, "Center");
            unmanagedScrollPane.getViewport().setView(jComponent);
        } else {
            this.contentPane.add((Component)jComponent, "Center");
        }
        this.contentPane = jComponent;
        this.contentPane.setFocusable(true);
        Utils.installMouseListener(this.contentPane, this.handle);
        Utils.installKeyListener(this.contentPane, this.handle);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void componentShown(ComponentEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void componentMoved(ComponentEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }
        });
        this.contentPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e2) {
            }

            public void windowClosing(WindowEvent e2) {
                if (!CShellFrame.this.isModallyBlocked()) {
                    CShellFrame.this.handle.processEvent(e2);
                }
            }

            public void windowActivated(WindowEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void windowDeactivated(WindowEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void windowClosed(WindowEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void windowIconified(WindowEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }

            public void windowDeiconified(WindowEvent e2) {
                CShellFrame.this.handle.processEvent(e2);
            }
        });
    }

    public void paint(Graphics graphics) {
        if (this.isPaintActive) {
            super.paint(graphics);
        }
    }

    protected void resetFocusableState() {
        this.setFocusableWindowState((this.handle.getStyle() & 0x20) != 0);
    }

    protected static void adjustLocation(Window window, Window window2) {
        if (window2 == null) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = window2.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        Point point = window.getLocation();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i2];
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration2.getBounds();
            if (!rectangle.contains(point)) continue;
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            window.setLocation(rectangle2.x + point.x - rectangle.x, rectangle2.y + point.y - rectangle.y);
            break;
        }
    }

    public void show() {
        if (!this.isVisible()) {
            Window window;
            this.isPaintActive = true;
            boolean bl = SwingUtilities.isEventDispatchThread();
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CShellFrame.this.isPaintActive = true;
                    }
                });
            }
            if ((window = this.getOwner()) instanceof CShell && !this.getFocusableWindowState()) {
                this.setActivationEventsBlocked(true);
                ((CShell)((Object)window)).setActivationEventsBlocked(true);
            }
            super.show();
            if (Compatibility.IS_JAVA_5_OR_GREATER && this.isLocationByPlatform()) {
                CShellFrame.adjustLocation(this, window);
            }
            if (!this.getFocusableWindowState() && (this.handle.getStyle() & 0x80000) == 0) {
                new Thread(){

                    public void run() {
                        try {
                            6.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (!6.access$0(this.this$1).getFocusableWindowState()) {
                                    6.access$0(this.this$1).setFocusableWindowState(true);
                                }
                            }
                        });
                    }

                    static /* synthetic */ CShellFrame access$0(6 var0) {
                        return var0.CShellFrame.this;
                    }
                }.start();
            }
            this.getModalityHandler().setEnabled(true);
            if (bl) {
                this.paint(this.getGraphics());
                Utils.paintComponentImmediately(this);
                this.isPaintActive = false;
            }
        }
    }

    public void hide() {
        if (this.isVisible()) {
            this.getModalityHandler().setEnabled(false);
            super.hide();
            this.resetFocusableState();
        }
    }

    public void forceActive() {
        this.toFront();
        this.requestFocus();
    }

    public Container getClientArea() {
        return this.contentPane;
    }

    public String getToolTipText() {
        return ((JComponent)this.contentPane).getToolTipText();
    }

    public void setToolTipText(String string) {
        ((JComponent)this.contentPane).setToolTipText(string);
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getHorizontalScrollBar();
    }

    public void setDefaultButton(CButton cButton) {
        if (cButton instanceof JButton) {
            this.getRootPane().setDefaultButton((JButton)((Object)cButton));
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
    }

    public CShell.ModalityHandler getModalityHandler() {
        return this.modalityHandler;
    }

    public boolean isFocusable() {
        return this.getFocusableWindowState() && super.isFocusable();
    }

    public boolean getFocusableWindowState() {
        return super.getFocusableWindowState() && !this.isModallyBlocked();
    }

    public void setFocusableWindowState(boolean bl) {
        Window window;
        if (bl && (window = this.getOwner()) instanceof CShell) {
            this.setActivationEventsBlocked(false);
            ((CShell)((Object)window)).setActivationEventsBlocked(false);
        }
        super.setFocusableWindowState(bl);
    }

    public void setIconImages(List list) {
        if (Compatibility.IS_JAVA_6_OR_GREATER) {
            super.setIconImages(list);
        } else if (!list.isEmpty()) {
            super.setIconImage((Image)list.get(0));
        }
    }

    public void setModallyBlocked(boolean bl) {
        this.isModallyBlocked = bl;
        super.setEnabled(!bl && this.isEnabled);
    }

    public boolean isModallyBlocked() {
        return this.isModallyBlocked;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        super.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Cursor getCursor() {
        return Utils.globalCursor != null ? Utils.globalCursor : super.getCursor();
    }
}

