/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CTable;
import org.eclipse.swt.internal.swing.CTableColumn;
import org.eclipse.swt.internal.swing.CTableImplementation;
import org.eclipse.swt.internal.swing.CTableItem;
import org.eclipse.swt.internal.swing.JStateCheckBox;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

class CTableImplementation
extends JScrollPane
implements CTable {
    protected Table handle;
    protected JTable table;
    protected boolean isCheckType;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected boolean isGridVisible;
    protected int rowCount;
    protected ImageIcon backgroundImageIcon;
    protected boolean isAdjustingColumnOrder;

    public Container getSwingComponent() {
        return this.table;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CTableImplementation(Table table, int n2) {
        this.handle = table;
        JViewport jViewport = new JViewport(){

            public boolean isOpaque() {
                return CTableImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CTableImplementation.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CTableImplementation.this != null && CTableImplementation.this.userAttributeHandler != null && CTableImplementation.this.userAttributeHandler.background != null ? CTableImplementation.this.userAttributeHandler.background : super.getBackground();
            }
        };
        this.setViewport(jViewport);
        this.table = new JTable(new CTableModel(table)){
            final JTable table;
            protected TableCellRenderer renderer;
            protected Graphics graphics;
            {
                CTableImplementation.this.setBackground(super.getBackground());
                this.table = this;
                this.renderer = new DefaultTableCellRenderer(this){
                    protected boolean isInitialized;
                    protected boolean isDefaultOpaque;
                    protected boolean isSelectionOpaque;
                    protected Color defaultForeground;
                    protected Color defaultBackground;
                    protected Font defaultFont;
                    protected Color selectionForeground;
                    protected Color selectionBackground;
                    protected Font selectionFont;
                    protected CTableItem.TableItemObject tableItemObject;
                    protected int row;
                    protected int column;
                    protected boolean ignoreDrawForeground;
                    protected boolean ignoreDrawBackground;
                    protected boolean ignoreDrawSelection;
                    protected boolean ignoreDrawFocused;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c2;
                        if (value instanceof CTableItem.TableItemObject) {
                            this.tableItemObject = (CTableItem.TableItemObject)value;
                            CTable.CellPaintEvent event = new CTable.CellPaintEvent(table, 1);
                            event.row = row;
                            event.column = column;
                            event.tableItem = this.tableItemObject.getTableItem();
                            event.ignoreDrawSelection = !isSelected;
                            event.ignoreDrawFocused = !hasFocus;
                            (this.this$1).CTableImplementation.this.handle.processEvent(event);
                            this.ignoreDrawForeground = event.ignoreDrawForeground;
                            this.ignoreDrawBackground = event.ignoreDrawBackground;
                            this.ignoreDrawSelection = event.ignoreDrawSelection;
                            this.ignoreDrawFocused = event.ignoreDrawFocused;
                            isSelected = !event.ignoreDrawSelection;
                            hasFocus = !event.ignoreDrawFocused;
                            this.row = row;
                            this.column = column;
                        } else {
                            this.tableItemObject = null;
                        }
                        if (!this.isInitialized) {
                            c2 = super.getTableCellRendererComponent((this.this$1).CTableImplementation.this.table, "", true, false, 0, 0);
                            if (c2 instanceof JComponent) {
                                this.isSelectionOpaque = ((JComponent)c2).isOpaque();
                            }
                            this.selectionForeground = c2.isForegroundSet() ? c2.getForeground() : null;
                            this.selectionBackground = c2.isBackgroundSet() ? c2.getBackground() : null;
                            this.selectionFont = c2.getFont();
                            c2.setForeground(null);
                            c2.setBackground(null);
                        }
                        if (!this.isInitialized) {
                            c2 = super.getTableCellRendererComponent((this.this$1).CTableImplementation.this.table, "", false, false, 0, 0);
                            if (c2 instanceof JComponent) {
                                this.isDefaultOpaque = ((JComponent)c2).isOpaque();
                            }
                            this.defaultForeground = c2.isForegroundSet() ? c2.getForeground() : null;
                            this.defaultBackground = c2.isBackgroundSet() ? c2.getBackground() : null;
                            this.defaultFont = c2.getFont();
                            this.isInitialized = true;
                        }
                        c2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (value != null) {
                            CTableItem.TableItemObject tableItemObject = (CTableItem.TableItemObject)value;
                            Color userForeground = (this.this$1).CTableImplementation.this.userAttributeHandler.foreground;
                            c2.setForeground(isSelected ? this.selectionForeground : (userForeground != null ? userForeground : this.defaultForeground));
                            Color userBackground = (this.this$1).CTableImplementation.this.userAttributeHandler.background;
                            c2.setBackground(isSelected ? this.selectionBackground : (userBackground != null ? userBackground : this.defaultBackground));
                            Font userFont = (this.this$1).CTableImplementation.this.userAttributeHandler.font;
                            c2.setFont(isSelected ? this.selectionFont : (userFont != null ? userFont : this.defaultFont));
                            if (c2 instanceof JComponent) {
                                ((JComponent)c2).setOpaque(isSelected ? this.isSelectionOpaque : this.isDefaultOpaque && table.isOpaque());
                            }
                            if (tableItemObject != null) {
                                Font font;
                                if (c2 instanceof JLabel) {
                                    TableColumn tableColumn = table.getColumnModel().getColumn(table.convertColumnIndexToView(column));
                                    JLabel label = (JLabel)c2;
                                    if (tableColumn instanceof CTableColumn) {
                                        CTableColumn cTableColumn = (CTableColumn)((Object)tableColumn);
                                        label.setHorizontalAlignment(cTableColumn.getAlignment());
                                    }
                                    label.setIcon(tableItemObject.getIcon());
                                }
                                CTableItem cTableItem = tableItemObject.getTableItem();
                                Color foreground = tableItemObject.getForeground();
                                if (foreground != null) {
                                    c2.setForeground(foreground);
                                } else {
                                    foreground = cTableItem.getForeground();
                                    if (foreground != null) {
                                        c2.setForeground(foreground);
                                    }
                                }
                                if (!isSelected) {
                                    Color background = tableItemObject.getBackground();
                                    if (background != null) {
                                        if (c2 instanceof JComponent) {
                                            ((JComponent)c2).setOpaque(true);
                                        }
                                        c2.setBackground(background);
                                    } else {
                                        background = cTableItem.getBackground();
                                        if (background != null) {
                                            if (c2 instanceof JComponent) {
                                                ((JComponent)c2).setOpaque(true);
                                            }
                                            c2.setBackground(background);
                                        }
                                    }
                                }
                                if ((font = tableItemObject.getFont()) != null) {
                                    c2.setFont(font);
                                } else {
                                    font = cTableItem.getFont();
                                    if (font != null) {
                                        c2.setFont(font);
                                    }
                                }
                            }
                        }
                        if (!(this.this$1).CTableImplementation.this.isCheckType || column != table.convertColumnIndexToView(0)) {
                            return c2;
                        }
                        CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer(c2);
                        if (this.tableItemObject != null) {
                            checkBoxCellRenderer.getStateCheckBox().setSelected(this.tableItemObject.isChecked());
                        }
                        return checkBoxCellRenderer;
                    }

                    protected void paintComponent(Graphics g2) {
                        if (this.ignoreDrawForeground) {
                            this.setText(null);
                        }
                        if (this.ignoreDrawBackground) {
                            this.setOpaque(false);
                        }
                        super.paintComponent(g2);
                        if (this.tableItemObject != null) {
                            CTable.CellPaintEvent event = new CTable.CellPaintEvent(this.this$1.table, 2);
                            event.row = this.row;
                            event.column = this.column;
                            event.tableItem = this.tableItemObject.getTableItem();
                            event.ignoreDrawForeground = this.ignoreDrawForeground;
                            event.ignoreDrawBackground = this.ignoreDrawBackground;
                            event.ignoreDrawSelection = this.ignoreDrawSelection;
                            event.ignoreDrawFocused = this.ignoreDrawFocused;
                            (this.this$1).CTableImplementation.this.handle.processEvent(event);
                        }
                    }
                };
            }

            public boolean isCellSelected(int row, int column) {
                return super.isCellSelected(row, column) || this.isRowSelected(row);
            }

            public boolean getScrollableTracksViewportWidth() {
                if (CTableImplementation.this.handle.isDisposed()) {
                    return false;
                }
                return CTableImplementation.this.handle.getColumnCount() == 0 && this.getPreferredSize().width < this.getParent().getWidth();
            }

            public boolean getScrollableTracksViewportHeight() {
                if (CTableImplementation.this.handle.isDisposed()) {
                    return false;
                }
                return this.getPreferredSize().height < this.getParent().getHeight();
            }

            public Dimension getPreferredScrollableViewportSize() {
                if (CTableImplementation.this.handle.getColumnCount() != 0) {
                    return this.getPreferredSize();
                }
                int columnCount = this.getColumnCount();
                int width = 0;
                int i2 = 0;
                while (i2 < columnCount) {
                    width += CTableImplementation.this.getPreferredColumnWidth(i2);
                    ++i2;
                }
                width += columnCount - 1;
                return new Dimension(width += columnCount, this.getPreferredSize().height);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                return this.renderer;
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this, this.columnModel){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getToolTipText(MouseEvent e2) {
                        int index = this.columnModel.getColumnIndexAtX(e2.getX());
                        if (index < 0) {
                            return null;
                        }
                        return ((CTableColumn)((Object)this.columnModel.getColumn(index))).getToolTipText();
                    }

                    public void paint(Graphics g2) {
                        org.eclipse.swt.widgets.TableColumn sortColumn;
                        super.paint(g2);
                        if ((this.this$1).CTableImplementation.this.handle.getSortDirection() != 0 && (sortColumn = (this.this$1).CTableImplementation.this.handle.getSortColumn()) != null) {
                            Rectangle bounds = this.this$1.getCellRect(-1, (this.this$1).CTableImplementation.this.table.convertColumnIndexToView((this.this$1).CTableImplementation.this.handle.indexOf(sortColumn)), false);
                            TableColumn draggedColumn = this.getDraggedColumn();
                            Shape clip = g2.getClip();
                            if (draggedColumn != null) {
                                int draggedDistance = this.getDraggedDistance();
                                if (((CTableColumn)((Object)draggedColumn)).getTableColumn() == sortColumn) {
                                    bounds.x += draggedDistance;
                                } else {
                                    Rectangle dragBounds = this.this$1.getCellRect(-1, (this.this$1).CTableImplementation.this.table.convertColumnIndexToView((this.this$1).CTableImplementation.this.handle.indexOf(((CTableColumn)((Object)draggedColumn)).getTableColumn())), true);
                                    dragBounds.x += draggedDistance;
                                    bounds.height = this.getHeight();
                                    if (bounds.x < dragBounds.x) {
                                        g2.clipRect(0, 0, dragBounds.x, bounds.height);
                                    } else {
                                        int x = dragBounds.x + dragBounds.width;
                                        g2.clipRect(x, 0, this.getWidth() - x, bounds.height);
                                    }
                                }
                            }
                            this.paintSortArrow(g2, bounds);
                            g2.setClip(clip);
                        }
                    }

                    protected void paintSortArrow(Graphics g2, Rectangle bounds) {
                        Color color = this.getBackground().darker();
                        boolean priority = false;
                        int height = Math.round((float)this.getHeight() / 1.5f);
                        int x = bounds.x + bounds.width;
                        int y = 1;
                        boolean descending = (this.this$1).CTableImplementation.this.handle.getSortDirection() == 1024;
                        int dx = (int)((double)(height / 2) * Math.pow(0.8, (double)priority));
                        if (bounds.width < dx * 3) {
                            return;
                        }
                        x -= dx * 2;
                        if (dx % 2 != 0) {
                            ++dx;
                        }
                        int dy = descending ? dx / 2 : -dx / 2;
                        y = y + 4 * height / 6 + (descending ? -dy : 0);
                        int shift = descending ? 1 : -1;
                        g2.translate(x, y);
                        g2.setColor(color);
                        int[] nArray = new int[4];
                        nArray[1] = dx / 2;
                        nArray[2] = dx;
                        int[] nArray2 = new int[4];
                        nArray2[1] = dy;
                        g2.fillPolygon(nArray, nArray2, 4);
                        g2.setColor(color.darker());
                        g2.drawLine(dx / 2, dy, 0, 0);
                        g2.drawLine(dx / 2, dy + shift, 0, shift);
                        g2.setColor(color.brighter());
                        g2.drawLine(dx / 2, dy, dx, 0);
                        g2.drawLine(dx / 2, dy + shift, dx, shift);
                        if (descending) {
                            g2.setColor(color.darker().darker());
                        } else {
                            g2.setColor(color.brighter());
                        }
                        g2.drawLine(dx, 0, 0, 0);
                        g2.setColor(color);
                        g2.translate(-x, -y);
                    }
                };
            }

            public Color getBackground() {
                return CTableImplementation.this != null && CTableImplementation.this.userAttributeHandler != null && CTableImplementation.this.userAttributeHandler.background != null ? CTableImplementation.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CTableImplementation.this != null && CTableImplementation.this.userAttributeHandler != null && CTableImplementation.this.userAttributeHandler.foreground != null ? CTableImplementation.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CTableImplementation.this != null && CTableImplementation.this.userAttributeHandler != null && CTableImplementation.this.userAttributeHandler.font != null ? CTableImplementation.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CTableImplementation.this != null && CTableImplementation.this.userAttributeHandler != null && CTableImplementation.this.userAttributeHandler.cursor != null ? CTableImplementation.this.userAttributeHandler.cursor : super.getCursor();
            }

            public Graphics getGraphics() {
                Graphics g2 = this.graphics != null ? this.graphics.create() : super.getGraphics();
                return g2;
            }

            public boolean isOpaque() {
                return CTableImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                this.graphics = g2;
                this.putClientProperty("SWTSwingGraphics2DClientProperty", g2);
                super.paintComponent(g2);
                CTableImplementation.this.handle.processEvent(new PaintEvent(this, 800, null));
                this.putClientProperty("SWTSwingGraphics2DClientProperty", null);
                this.graphics = null;
            }

            /*
             * Enabled aggressive block sorting
             */
            protected void processEvent(AWTEvent e2) {
                if (Utils.redispatchEvent(CTableImplementation.this.getSWTHandle(), e2)) {
                    return;
                }
                if (e2 instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e2;
                    if (CTableImplementation.this.isCheckType) {
                        Component tableCellRendererComponent;
                        Point location = me.getPoint();
                        int column = this.table.columnAtPoint(location);
                        int row = this.table.rowAtPoint(location);
                        if (row != -1 && column != -1 && (tableCellRendererComponent = this.table.getCellRenderer(row, column).getTableCellRendererComponent(this, this.table.getValueAt(row, column), this.table.isCellSelected(row, column), false, row, column)) instanceof CheckBoxCellRenderer) {
                            CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)tableCellRendererComponent;
                            Rectangle cellBounds = this.table.getCellRect(row, column, false);
                            checkBoxCellRenderer.setSize(cellBounds.width, cellBounds.height);
                            checkBoxCellRenderer.doLayout();
                            Component component = checkBoxCellRenderer.getComponentAt(location.x - cellBounds.x, location.y - cellBounds.y);
                            JStateCheckBox stateCheckBox = checkBoxCellRenderer.getStateCheckBox();
                            if (component == stateCheckBox) {
                                switch (me.getID()) {
                                    case 501: {
                                        CTableItem cTableItem = CTableImplementation.this.handle.getItem((int)row).handle;
                                        CTableItem.TableItemObject tableItemObject = cTableItem.getTableItemObject(0);
                                        boolean ischecked = !tableItemObject.isChecked();
                                        tableItemObject.getTableItem().setChecked(ischecked);
                                        this.table.repaint();
                                        CTableImplementation.this.handle.processEvent(new ItemEvent(stateCheckBox, 701, cTableItem, ischecked ? 1 : 2));
                                        return;
                                    }
                                    case 500: 
                                    case 502: 
                                    case 506: {
                                        return;
                                    }
                                }
                            }
                        }
                    }
                    switch (me.getID()) {
                        case 501: {
                            switch (me.getButton()) {
                                case 3: {
                                    ListSelectionModel selectionModel;
                                    int row = this.rowAtPoint(me.getPoint());
                                    if (row == -1 || (selectionModel = this.getSelectionModel()).isSelectedIndex(row)) break;
                                    selectionModel.setSelectionInterval(row, row);
                                }
                            }
                            break;
                        }
                    }
                }
                super.processEvent(e2);
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.table);
        this.table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.getColumnModel().addColumnModelListener((TableColumnModelListener)((Object)new /* invalid duplicate definition of identical inner class */));
        HeaderMouseListener headerMouseListener = new HeaderMouseListener(this, jTableHeader);
        jTableHeader.addMouseListener((MouseListener)headerMouseListener);
        jTableHeader.addMouseMotionListener((MouseMotionListener)headerMouseListener);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer((TableCellRenderer)((Object)new /* invalid duplicate definition of identical inner class */));
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = new TableColumn(0);
        tableColumnModel.addColumn(tableColumn);
        this.setFocusable(false);
        jViewport.setView(this.table);
        jViewport.setBackground(this.table.getBackground());
        this.setColumnHeader(this.createViewport());
        this.setHeaderVisible(false);
        this.init(n2);
    }

    protected void init(int n2) {
        boolean bl = this.isCheckType = (n2 & 0x20) != 0;
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((n2 & 0x10000) == 0) {
            this.table.setCellSelectionEnabled(true);
            this.table.getColumnModel().setSelectionModel((ListSelectionModel)((Object)new TableColumnModelListener(){

                public void columnAdded(TableColumnModelEvent e2) {
                }

                public void columnMarginChanged(ChangeEvent e2) {
                }

                public void columnMoved(TableColumnModelEvent e2) {
                    if (CTableImplementation.this.isAdjustingColumnOrder) {
                        return;
                    }
                    int toIndex = e2.getToIndex();
                    int fromIndex = e2.getFromIndex();
                    if (fromIndex != toIndex) {
                        TableColumnModel columnModel = CTableImplementation.this.getColumnModel();
                        CTableColumn cTableColumn = (CTableColumn)((Object)columnModel.getColumn(toIndex));
                        cTableColumn.getTableColumn().processEvent(e2);
                        cTableColumn = (CTableColumn)((Object)columnModel.getColumn(fromIndex));
                        cTableColumn.getTableColumn().processEvent(e2);
                    }
                }

                public void columnRemoved(TableColumnModelEvent e2) {
                }

                public void columnSelectionChanged(ListSelectionEvent e2) {
                }
            }));
        }
        this.setGridVisible(false);
        if ((n2 & 2) == 0) {
            this.table.setSelectionMode(0);
        }
        Utils.installMouseListener(this.table, this.handle);
        Utils.installKeyListener(this.table, this.handle);
        Utils.installFocusListener(this.table, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.table.getSelectionModel().addListSelectionListener((ListSelectionListener)((Object)new TableCellRenderer(this){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableColumn tableColumn;
                Component c2;
                if (value == null || "".equals(value)) {
                    value = " ";
                }
                if ((c2 = headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel && (tableColumn = CTableImplementation.this.table.getColumnModel().getColumn(column)) instanceof CTableColumn) {
                    JLabel label = (JLabel)c2;
                    CTableColumn cTableColumn = (CTableColumn)((Object)tableColumn);
                    label.setHorizontalAlignment(cTableColumn.getAlignment());
                    label.setIcon(cTableColumn.getIcon());
                }
                return c2;
            }
        }));
    }

    public Container getClientArea() {
        return this.table;
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setGridVisible(boolean bl) {
        this.isGridVisible = bl;
        this.table.setIntercellSpacing(bl ? new Dimension(1, 1) : new Dimension(0, 0));
        this.table.setShowHorizontalLines(bl);
        this.table.setShowVerticalLines(bl);
        this.repaint();
    }

    public boolean isGridVisible() {
        return this.isGridVisible;
    }

    public DefaultListSelectionModel getSelectionModel() {
        return (DefaultListSelectionModel)this.table.getSelectionModel();
    }

    public AbstractTableModel getModel() {
        return (AbstractTableModel)this.table.getModel();
    }

    public Rectangle getCellRect(int n2, int n3, boolean bl) {
        Rectangle rectangle = this.table.getCellRect(n2, n3, bl);
        if (this.isCheckType && n3 == 0) {
            Component component = this.getCellRenderer(n2, n3).getTableCellRendererComponent(this.table, this.getModel().getValueAt(n2, n3), false, false, n2, n3);
            component.setBounds(rectangle);
            component.validate();
            if (component instanceof CheckBoxCellRenderer) {
                CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)component;
                component = checkBoxCellRenderer.getComponent();
                int n4 = component.getBounds().x;
                rectangle.x += n4;
                rectangle.width -= n4;
            }
        }
        return rectangle;
    }

    public TableColumnModel getColumnModel() {
        return this.table.getColumnModel();
    }

    public void addItem(int n2) {
        ++this.rowCount;
        this.getModel().fireTableRowsInserted(n2, n2);
    }

    public void removeItem(int n2) {
        --this.rowCount;
        this.getModel().fireTableRowsDeleted(n2, n2);
    }

    public TableCellRenderer getCellRenderer(int n2, int n3) {
        return this.table.getCellRenderer(n2, n3);
    }

    public int getPreferredColumnWidth(int n2) {
        Component component;
        Object object;
        int n3 = this.handle.getItemCount();
        int n4 = Math.max(this.table.getColumnModel().getColumn(n2).getMinWidth(), 10);
        if ((this.handle.getStyle() & 0x10000000) != 0) {
            return n4;
        }
        TableModel tableModel = this.table.getModel();
        for (int i2 = 0; i2 < n3; ++i2) {
            object = this.table.getCellRenderer(i2, n2);
            component = object.getTableCellRendererComponent(this.table, tableModel.getValueAt(i2, n2), false, false, i2, n2);
            n4 = Math.max(n4, (int)component.getPreferredSize().getWidth());
        }
        JTableHeader jTableHeader = this.getTableHeader();
        object = jTableHeader.getColumnModel().getColumn(n2);
        component = jTableHeader.getDefaultRenderer().getTableCellRendererComponent(this.table, ((TableColumn)object).getHeaderValue(), false, false, -1, n2);
        n4 = Math.max(n4, (int)component.getPreferredSize().getWidth());
        return n4;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.getViewport().setOpaque(true);
                this.table.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.getViewport().setOpaque(false);
                this.table.setOpaque(false);
            }
        }
    }

    public void ensureRowVisible(int n2) {
        if (n2 < 0 || n2 >= this.table.getRowCount()) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n2, 0, true);
        rectangle.width = this.table.getWidth();
        rectangle.height = this.table.getRowHeight(n2);
        this.table.scrollRectToVisible(rectangle);
    }

    public void ensureColumnVisible(int n2) {
        if (n2 < 0 || n2 >= this.table.getColumnCount()) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < n2; ++i2) {
            rectangle.x += tableColumnModel.getColumn(i2).getPreferredWidth();
        }
        rectangle.width = tableColumnModel.getColumn(n2).getPreferredWidth();
        rectangle.height = this.table.getHeight();
        this.table.scrollRectToVisible(rectangle);
    }

    public void setHeaderVisible(boolean bl) {
        this.getColumnHeader().setVisible(bl);
        this.table.getTableHeader().setVisible(bl);
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public void setRowHeight(int n2) {
        this.table.setRowHeight(n2);
    }

    public int rowAtPoint(Point point) {
        point = SwingUtilities.convertPoint(this, point.x, point.y, this.table);
        return this.table.rowAtPoint(point);
    }

    public void setTopIndex(int n2) {
        int n3 = this.table.getRowCount();
        if (n3 == 0) {
            return;
        }
        this.ensureRowVisible(n3 - 1);
        if (n2 != 0) {
            this.ensureRowVisible(n2);
        }
    }

    public int getTopIndex() {
        return this.rowAtPoint(new Point(0, 0));
    }

    public void moveColumn(int n2, int n3) {
        this.table.moveColumn(n2, n3);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.table != null) {
            this.table.setFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.table != null) {
            this.table.setForeground(color);
        }
    }

    public boolean isFocusable() {
        return this.table.isFocusable();
    }

    public void requestFocus() {
        this.table.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.isAdjustingColumnOrder = true;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.table.moveColumn(this.table.convertColumnIndexToView(nArray[n2]), n2);
        }
        this.isAdjustingColumnOrder = false;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            CTableColumn cTableColumn = (CTableColumn)((Object)this.getColumnModel().getColumn(n2));
            cTableColumn.getTableColumn().processEvent(new TableColumnModelEvent(this.table.getColumnModel(), n2, nArray[n2]));
        }
    }

    public int[] getColumnOrder() {
        int[] nArray = new int[this.table.getColumnCount()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.table.convertColumnIndexToModel(i2);
        }
        return nArray;
    }

    public Rectangle getImageBounds(int n2, int n3) {
        Serializable serializable;
        Component component = this.getCellRenderer(n2, n3).getTableCellRendererComponent(this.table, this.getModel().getValueAt(n2, n3), false, false, n2, n3);
        Rectangle rectangle = this.table.getCellRect(n2, n3, false);
        component.setBounds(rectangle);
        component.validate();
        Rectangle rectangle2 = new Rectangle();
        if (component instanceof CheckBoxCellRenderer) {
            serializable = (CheckBoxCellRenderer)component;
            component = serializable.getComponent();
            rectangle2.x += component.getBounds().x;
        }
        if (component instanceof JLabel) {
            serializable = new Rectangle();
            JLabel jLabel = (JLabel)component;
            SwingUtilities.layoutCompoundLabel(jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), new Rectangle(), (Rectangle)serializable, new Rectangle(), jLabel.getIconTextGap());
            rectangle2.x += ((Rectangle)serializable).x;
            rectangle2.y += ((Rectangle)serializable).y;
            rectangle2.width = ((Rectangle)serializable).width;
            rectangle2.height = ((Rectangle)serializable).height;
        }
        rectangle2.x += rectangle.x;
        rectangle2.y += rectangle.y;
        return rectangle2;
    }

    public class CTableModel
    extends AbstractTableModel {
        protected Table table;

        protected CTableModel(Table table) {
            this.table = table;
        }

        public int getRowCount() {
            return CTableImplementation.this.rowCount;
        }

        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.table.getItem((int)rowIndex).handle.getTableItemObject(columnIndex);
        }
    }

    protected class CheckBoxCellRenderer
    extends JPanel {
        protected JStateCheckBox checkBox = new JStateCheckBox();
        protected Component component;

        public CheckBoxCellRenderer(Component component) {
            super(new BorderLayout(0, 0));
            this.component = component;
            this.setOpaque(false);
            this.checkBox.setOpaque(false);
            this.add((Component)this.checkBox, "West");
            this.add(component, "Center");
            this.addNotify();
        }

        public JStateCheckBox getStateCheckBox() {
            return this.checkBox;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

