/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.swt.internal.swing.JCoolBarItem;
import org.eclipse.swt.internal.swing.JCoolBarLayout;

public class JCoolBar
extends JPanel {
    protected static final int FLOATING_MARGIN = 10;
    protected boolean isLocked;
    protected Point mouseLocation;
    protected boolean isFloatable = false;
    protected static final Cursor GRIP_CURSOR = Cursor.getPredefinedCursor(11);
    protected static final JToolBar TOOL_BAR = new JToolBar();

    public JCoolBar() {
        this.setLayout(new JCoolBarLayout());
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean bl) {
        this.isLocked = bl;
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((JCoolBarItem)this.getComponent(i2)).setLocked(bl);
        }
    }

    public void setWrappedIndices(int[] nArray) {
        int n2;
        int n3 = this.getComponentCount();
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            if (n4 < 0 || n4 >= n3) continue;
            blArray[n4] = true;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            ((JCoolBarItem)this.getComponent(n2)).setWrapped(blArray[n2]);
        }
        this.revalidate();
        this.repaint();
    }

    public int getRowCount() {
        int n2 = this.getItemCount() > 0 ? 1 : 0;
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (!this.getItem(i2).isWrapped()) continue;
            ++n2;
        }
        return n2;
    }

    public int getItemCount() {
        return this.getComponentCount();
    }

    public JCoolBarItem getItem(int n2) {
        return (JCoolBarItem)this.getComponent(n2);
    }

    protected int getItemIndex(JCoolBarItem jCoolBarItem) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (jCoolBarItem != this.getComponent(i2)) continue;
            return i2;
        }
        return -1;
    }

    protected void processItemMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.mouseLocation = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this);
                break;
            }
            case 506: {
                JCoolBarItem jCoolBarItem = (JCoolBarItem)mouseEvent.getComponent();
                Point point = SwingUtilities.convertPoint(jCoolBarItem, mouseEvent.getPoint(), this);
                Dimension dimension = this.getSize();
                int n2 = this.getItemIndex(jCoolBarItem);
                if (this.isFloatable && (point.x + 10 < 0 || point.y + 10 < 0 || point.x > dimension.width + 10 || point.y > dimension.height + 10)) {
                    Point point2 = jCoolBarItem.getLocation();
                    SwingUtilities.convertPointToScreen(point2, this);
                    SwingUtilities.convertPointToScreen(point, this);
                    SwingUtilities.convertPointToScreen(this.mouseLocation, this);
                    point = new Point(point2.x - this.mouseLocation.x + point.x, point2.y - this.mouseLocation.y + point.y);
                    this.setFloating(n2, point);
                    this.mouseLocation = null;
                    break;
                }
                int n3 = point.x - this.mouseLocation.x;
                if (point.y < jCoolBarItem.getY()) {
                    if (this.getLineItems(n2).length > 1) {
                        this.moveUp(n2);
                    } else {
                        this.mergeUp(n2);
                    }
                } else if (point.y > jCoolBarItem.getY() + jCoolBarItem.getHeight()) {
                    if (this.getLineItems(n2).length > 1) {
                        this.moveDown(n2);
                    } else {
                        this.mergeDown(n2);
                    }
                }
                n2 = this.getItemIndex(jCoolBarItem);
                boolean bl = this.getComponentOrientation().isLeftToRight();
                if (n3 < 0) {
                    if (bl) {
                        this.moveLeading(n2, -n3);
                    } else {
                        this.moveTrailing(n2, -n3);
                    }
                } else if (n3 > 0) {
                    if (bl) {
                        this.moveTrailing(n2, n3);
                    } else {
                        this.moveLeading(n2, n3);
                    }
                }
                this.mouseLocation = point;
                break;
            }
            case 502: {
                this.mouseLocation = null;
                JCoolBarItem jCoolBarItem = (JCoolBarItem)mouseEvent.getComponent();
                jCoolBarItem.setXSpacing(Math.max(0, jCoolBarItem.getXSpacing()));
                break;
            }
        }
    }

    protected JCoolBarItem[] getLineItems(int n2) {
        if (n2 < 0) {
            return new JCoolBarItem[0];
        }
        int n3 = this.getItemCount();
        if (n2 >= n3) {
            return new JCoolBarItem[0];
        }
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        if (n2 != 0 && !jCoolBarItem.isWrapped()) {
            return this.getLineItems(n2 - 1);
        }
        Vector<JCoolBarItem> vector = new Vector<JCoolBarItem>();
        for (int i2 = n2; i2 < n3; ++i2) {
            jCoolBarItem = this.getItem(i2);
            if (i2 != n2 && jCoolBarItem.isWrapped()) break;
            vector.add(jCoolBarItem);
        }
        return vector.toArray(new JCoolBarItem[0]);
    }

    public void setFloatable(boolean bl) {
        this.isFloatable = bl;
    }

    protected void setFloating(int n2, Point point) {
        if (this.isFloatable) {
            this.getItem(n2).setFloating(true, point);
        }
    }

    protected void moveUp(int n2) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        JCoolBarItem[] jCoolBarItemArray = this.getLineItems(n2);
        JCoolBarItem jCoolBarItem2 = jCoolBarItemArray[0];
        if (jCoolBarItem2 == jCoolBarItem) {
            jCoolBarItemArray[1].setWrapped(true);
        } else {
            int n3 = this.getItemIndex(jCoolBarItem2);
            this.remove(jCoolBarItem);
            this.add((Component)jCoolBarItem, n3);
            jCoolBarItem.setWrapped(true);
            jCoolBarItem2.setWrapped(true);
        }
        JCoolBarItem jCoolBarItem3 = jCoolBarItemArray[jCoolBarItemArray.length - 1];
        if (jCoolBarItem3 != jCoolBarItem) {
            JCoolBarItem jCoolBarItem4 = this.getItem(n2 + 1);
            jCoolBarItem4.setXSpacing(Math.max(0, jCoolBarItem.getXSpacing()));
        }
        int n4 = jCoolBarItem.getXSpacing();
        int n5 = bl ? jCoolBarItem.getX() : this.getWidth() - jCoolBarItem.getX() - jCoolBarItem.getWidth();
        if (n4 < 0) {
            n5 += n4;
        }
        jCoolBarItem.setXSpacing(n5);
        this.revalidate();
        this.repaint();
        this.setSize(new Dimension(this.getSize().width, this.getPreferredSize().height));
    }

    protected void mergeUp(int n2) {
        int n3;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        JCoolBarItem[] jCoolBarItemArray = this.getLineItems(n2 - 1);
        if (jCoolBarItemArray.length == 0) {
            return;
        }
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        JCoolBarItem jCoolBarItem2 = null;
        int n4 = 0;
        for (n3 = 0; n3 < jCoolBarItemArray.length; ++n3) {
            jCoolBarItem2 = jCoolBarItemArray[n3];
            if (bl ? jCoolBarItem2.getX() >= jCoolBarItem.getX() : jCoolBarItem2.getX() + jCoolBarItem2.getWidth() <= jCoolBarItem.getX() + jCoolBarItem.getWidth()) break;
            ++n4;
            jCoolBarItem2 = null;
        }
        if (n4 == jCoolBarItemArray.length) {
            jCoolBarItem.setWrapped(false);
        } else {
            this.remove(jCoolBarItem);
            this.add((Component)jCoolBarItem, n2 - jCoolBarItemArray.length + n4);
            if (n4 == 0) {
                jCoolBarItem.setWrapped(true);
                jCoolBarItemArray[0].setWrapped(false);
            } else {
                jCoolBarItem.setWrapped(false);
            }
        }
        if (n4 > 0) {
            JCoolBarItem jCoolBarItem3 = jCoolBarItemArray[n4 - 1];
            if (bl) {
                jCoolBarItem.setXSpacing(jCoolBarItem.getX() - jCoolBarItem3.getX() - jCoolBarItem3.getPreferredSize().width);
            } else {
                jCoolBarItem.setXSpacing(jCoolBarItem3.getX() + jCoolBarItem3.getWidth() - jCoolBarItem3.getPreferredSize().width - jCoolBarItem.getX() - jCoolBarItem.getWidth());
            }
        } else {
            n3 = jCoolBarItem.getXSpacing();
            int n5 = bl ? jCoolBarItem.getX() : this.getWidth() - jCoolBarItem.getX() - jCoolBarItem.getWidth();
            if (n3 < 0) {
                n5 += n3;
            }
            jCoolBarItem.setXSpacing(n5);
        }
        if (n4 < jCoolBarItemArray.length) {
            JCoolBarItem jCoolBarItem4 = jCoolBarItemArray[n4];
            if (bl) {
                jCoolBarItem2.setXSpacing(jCoolBarItem4.getX() - jCoolBarItem.getX() - jCoolBarItem.getPreferredSize().width);
            } else {
                jCoolBarItem2.setXSpacing(jCoolBarItem.getX() + jCoolBarItem.getWidth() - jCoolBarItem.getPreferredSize().width - jCoolBarItem4.getX() - jCoolBarItem4.getWidth());
            }
        }
        this.revalidate();
        this.repaint();
        this.setSize(new Dimension(this.getSize().width, this.getPreferredSize().height));
    }

    protected void moveDown(int n2) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        JCoolBarItem[] jCoolBarItemArray = this.getLineItems(n2);
        JCoolBarItem jCoolBarItem2 = jCoolBarItemArray[0];
        if (jCoolBarItem2 == jCoolBarItem) {
            jCoolBarItemArray[1].setWrapped(true);
        }
        jCoolBarItem.setWrapped(true);
        JCoolBarItem jCoolBarItem3 = jCoolBarItemArray[jCoolBarItemArray.length - 1];
        if (jCoolBarItem3 != jCoolBarItem) {
            JCoolBarItem jCoolBarItem4 = this.getItem(n2 + 1);
            jCoolBarItem4.setXSpacing(Math.max(0, jCoolBarItem.getXSpacing()));
        }
        int n3 = this.getItemIndex(jCoolBarItem3);
        this.remove(jCoolBarItem);
        this.add((Component)jCoolBarItem, n3);
        int n4 = jCoolBarItem.getXSpacing();
        int n5 = bl ? jCoolBarItem.getX() : this.getWidth() - jCoolBarItem.getX() - jCoolBarItem.getWidth();
        if (n4 < 0) {
            n5 += n4;
        }
        jCoolBarItem.setXSpacing(n5);
        this.revalidate();
        this.repaint();
        this.setSize(new Dimension(this.getSize().width, this.getPreferredSize().height));
    }

    protected void mergeDown(int n2) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        JCoolBarItem[] jCoolBarItemArray = this.getLineItems(n2 + 1);
        if (jCoolBarItemArray.length == 0) {
            return;
        }
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        JCoolBarItem jCoolBarItem2 = null;
        int n3 = 0;
        for (int i2 = 0; i2 < jCoolBarItemArray.length; ++i2) {
            jCoolBarItem2 = jCoolBarItemArray[i2];
            if (bl ? jCoolBarItem2.getX() >= jCoolBarItem.getX() : jCoolBarItem2.getX() + jCoolBarItem2.getWidth() <= jCoolBarItem.getX() + jCoolBarItem.getWidth()) break;
            ++n3;
            jCoolBarItem2 = null;
        }
        if (n3 == 0) {
            jCoolBarItem.setWrapped(true);
            jCoolBarItemArray[0].setWrapped(false);
        } else {
            this.remove(jCoolBarItem);
            this.add((Component)jCoolBarItem, n2 + n3);
            jCoolBarItem.setWrapped(false);
            JCoolBarItem jCoolBarItem3 = jCoolBarItemArray[n3 - 1];
            if (bl) {
                jCoolBarItem.setXSpacing(jCoolBarItem.getX() - jCoolBarItem3.getX() - jCoolBarItem3.getPreferredSize().width);
            } else {
                jCoolBarItem.setXSpacing(jCoolBarItem3.getX() + jCoolBarItem3.getWidth() - jCoolBarItem3.getPreferredSize().width - jCoolBarItem.getX() - jCoolBarItem.getWidth());
            }
        }
        if (n3 < jCoolBarItemArray.length) {
            JCoolBarItem jCoolBarItem4 = jCoolBarItemArray[n3];
            if (bl) {
                jCoolBarItem2.setXSpacing(jCoolBarItem4.getX() - jCoolBarItem.getX() - jCoolBarItem.getPreferredSize().width);
            } else {
                jCoolBarItem2.setXSpacing(jCoolBarItem.getX() + jCoolBarItem.getWidth() - jCoolBarItem.getPreferredSize().width - jCoolBarItem4.getX() - jCoolBarItem4.getWidth());
            }
        }
        this.revalidate();
        this.repaint();
        this.setSize(new Dimension(this.getSize().width, this.getPreferredSize().height));
    }

    protected void moveLeading(int n2, int n3) {
        int n4;
        int n5;
        JCoolBarItem jCoolBarItem;
        int n6;
        n3 = -n3;
        JCoolBarItem jCoolBarItem2 = this.getItem(n2);
        int n7 = jCoolBarItem2.getXSpacing();
        int n8 = n7 + n3;
        n3 += Math.max(0, n7);
        int n9 = 0;
        if (!jCoolBarItem2.isWrapped()) {
            for (n6 = n2 - 1; n3 < 0 && n6 >= 0; --n6) {
                jCoolBarItem = (JCoolBarItem)this.getComponent(n6);
                n5 = jCoolBarItem.getXSpacing();
                n4 = Math.min(-n3, n5);
                n3 += n4;
                n9 += n4;
                jCoolBarItem.setXSpacing(n5 - n4);
                n8 += n4;
                if (!jCoolBarItem.isWrapped()) continue;
                --n6;
                break;
            }
        }
        ++n6;
        if (n2 + 1 < this.getComponentCount() && !(jCoolBarItem = (JCoolBarItem)this.getComponent(n2 + 1)).isWrapped()) {
            jCoolBarItem.setXSpacing(jCoolBarItem.getXSpacing() - n8 + n7 + n9 + Math.min(0, n3));
        }
        if (n8 < 0) {
            jCoolBarItem2.setXSpacing(n8);
            this.revalidate();
            int n10 = jCoolBarItem2.getX();
            n5 = this.getComponentOrientation().isLeftToRight() ? 1 : 0;
            for (n4 = n6; n4 < n2; ++n4) {
                int n11;
                JCoolBarItem jCoolBarItem3 = (JCoolBarItem)this.getComponent(n4);
                if (n5 != 0) {
                    n11 = jCoolBarItem3.getX();
                    if (n11 < n10 + n8) continue;
                    this.remove(jCoolBarItem2);
                    this.add((Component)jCoolBarItem2, n4);
                    n8 += n10 - n11;
                    if (n4 != n6) break;
                    jCoolBarItem2.setWrapped(true);
                    jCoolBarItem3.setWrapped(false);
                    break;
                }
                n11 = jCoolBarItem3.getX();
                if (n11 + jCoolBarItem3.getWidth() > n10 + jCoolBarItem2.getWidth() - n8) continue;
                this.remove(jCoolBarItem2);
                this.add((Component)jCoolBarItem2, n4);
                n8 += n11 + jCoolBarItem3.getWidth() - n10 - jCoolBarItem2.getWidth();
                if (n4 != n6) break;
                jCoolBarItem2.setWrapped(true);
                jCoolBarItem3.setWrapped(false);
                break;
            }
        }
        jCoolBarItem2.setXSpacing(n8);
        this.revalidate();
        this.repaint();
    }

    protected void moveTrailing(int n2, int n3) {
        JCoolBarItem jCoolBarItem = this.getItem(n2);
        int n4 = jCoolBarItem.getXSpacing();
        int n5 = n4 + n3;
        int n6 = this.getComponentCount();
        if (n5 >= 0) {
            JCoolBarItem jCoolBarItem2;
            for (int i2 = n2 + 1; n3 > 0 && i2 < n6 && !(jCoolBarItem2 = (JCoolBarItem)this.getComponent(i2)).isWrapped(); ++i2) {
                int n7 = jCoolBarItem2.getXSpacing();
                int n8 = Math.min(n3, n7);
                n3 -= n8;
                if (n4 < 0) {
                    n8 -= -n4;
                }
                jCoolBarItem2.setXSpacing(n7 - n8);
            }
        }
        jCoolBarItem.setXSpacing(n5);
        this.revalidate();
        this.repaint();
    }

    public Cursor getCursor() {
        if (!this.isLocked && this.isDragging()) {
            return GRIP_CURSOR;
        }
        return super.getCursor();
    }

    protected boolean isDragging() {
        return this.mouseLocation != null;
    }

    public void updateUI() {
        TOOL_BAR.updateUI();
        super.updateUI();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n2 = this.getComponentCount();
        Dimension dimension = this.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCoolBarItem jCoolBarItem = (JCoolBarItem)this.getComponent(i2);
            if (i2 != 0 && !jCoolBarItem.isWrapped()) continue;
            Rectangle rectangle = jCoolBarItem.getBounds();
            graphics.translate(0, rectangle.y);
            TOOL_BAR.setSize(dimension.width, rectangle.height);
            TOOL_BAR.paint(graphics);
            graphics.translate(0, -rectangle.y);
        }
    }

    protected void addImpl(Component component, Object object, int n2) {
        JCoolBarItem jCoolBarItem = (JCoolBarItem)component;
        jCoolBarItem.setLocked(this.isLocked);
        jCoolBarItem.setFloating(false, null);
        super.addImpl(component, object, n2);
    }

    static {
        TOOL_BAR.setFloatable(false);
    }
}

