/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.internal.swing.Compatibility;

public class JTracker {
    public static final int SINGLE_LINE_APPEARANCE = 0;
    public static final int THICK_BORDER_APPEARANCE = 1;
    public static final int UP_MASK = 1;
    public static final int LEFT_MASK = 2;
    public static final int DOWN_MASK = 4;
    public static final int RIGHT_MASK = 8;
    protected Window[][] windowsArray = new Window[0][];
    protected Rectangle[] rectangles;
    protected boolean isResizeType;
    protected Point offset;
    protected Rectangle clipBounds;
    protected Window sharedOwnerWindow;
    protected boolean isCanceled;
    protected boolean isVisible;
    protected Point lastMouseLocation;
    protected int edgeReiszeMask;
    protected int appearance = 0;
    protected boolean isAdjusmentPending;
    protected boolean isAdjusting;
    protected boolean isGenericWindow;
    protected int constraints = 15;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$org$eclipse$swt$internal$swing$JTracker$TrackerListener;

    public JTracker(boolean bl) {
        this(null, bl);
    }

    public JTracker(Component component, boolean bl) {
        this.isResizeType = bl;
        if (component != null) {
            Rectangle rectangle;
            this.offset = component.getLocationOnScreen();
            this.clipBounds = new Rectangle(component.getSize());
            Graphics graphics = component.getGraphics();
            if (graphics != null && (rectangle = graphics.getClipBounds()) != null) {
                this.clipBounds = rectangle.intersection(this.clipBounds);
            }
            this.clipBounds.x += this.offset.x;
            this.clipBounds.y += this.offset.y;
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        Window[] windowArray;
        int n2;
        Rectangle[] rectangleArray2;
        if (rectangleArray != null) {
            rectangleArray2 = new Rectangle[rectangleArray.length];
            for (n2 = 0; n2 < rectangleArray.length; ++n2) {
                windowArray = new Rectangle(rectangleArray[n2]);
                if (this.offset != null) {
                    windowArray.x += this.offset.x;
                    windowArray.y += this.offset.y;
                }
                rectangleArray2[n2] = windowArray;
            }
            rectangleArray = rectangleArray2;
        }
        this.rectangles = rectangleArray;
        if (rectangleArray == null) {
            rectangleArray = new Rectangle[]{};
        }
        rectangleArray2 = new Window[rectangleArray.length][];
        for (n2 = rectangleArray.length; n2 < this.windowsArray.length; ++n2) {
            windowArray = this.windowsArray[n2];
            for (int i2 = 0; i2 < windowArray.length; ++i2) {
                Window window = windowArray[i2];
                if (window == null) continue;
                window.dispose();
            }
        }
        System.arraycopy(this.windowsArray, 0, rectangleArray2, 0, Math.min(this.windowsArray.length, rectangleArray.length));
        this.windowsArray = rectangleArray2;
        this.postAdjustWindows();
    }

    public Rectangle[] getRectangles() {
        if (this.rectangles == null) {
            return null;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle rectangle = new Rectangle(this.rectangles[i2]);
            if (this.offset != null) {
                rectangle.x -= this.offset.x;
                rectangle.y -= this.offset.y;
            }
            rectangleArray[i2] = rectangle;
        }
        return rectangleArray;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this.isCanceled = true;
            this.hide();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: {
                this.hide();
                break;
            }
            case 503: 
            case 506: {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                if (this.lastMouseLocation != null) {
                    int n2 = point.x - this.lastMouseLocation.x;
                    int n3 = point.y - this.lastMouseLocation.y;
                    this.lastMouseLocation = point;
                    this.processMouseMove(n2, n3);
                    break;
                }
                this.lastMouseLocation = point;
            }
        }
    }

    protected void processMouseMove(int n2, int n3) {
        Object object;
        if (this.isResizeType) {
            if (n2 != 0 && (this.edgeReiszeMask & 0xA) == 0) {
                if (n2 > 0) {
                    if ((this.constraints & 8) != 0) {
                        this.edgeReiszeMask |= 8;
                    }
                } else if ((this.constraints & 2) != 0) {
                    this.edgeReiszeMask |= 2;
                }
            }
            if (n3 != 0 && (this.edgeReiszeMask & 5) == 0) {
                if (n3 > 0) {
                    if ((this.constraints & 4) != 0) {
                        this.edgeReiszeMask |= 4;
                    }
                } else if ((this.constraints & 1) != 0) {
                    this.edgeReiszeMask |= 1;
                }
            }
        } else {
            if (n2 < 0) {
                if ((this.constraints & 2) == 0) {
                    n2 = 0;
                }
            } else if ((this.constraints & 8) == 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                if ((this.constraints & 1) == 0) {
                    n3 = 0;
                }
            } else if ((this.constraints & 4) == 0) {
                n3 = 0;
            }
        }
        if (n2 == 0 && n3 == 0 || this.isResizeType && this.edgeReiszeMask == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            object = this.rectangles[i2];
            if (this.isResizeType) {
                if ((this.edgeReiszeMask & 2) != 0) {
                    ((Rectangle)object).x += n2;
                    ((Rectangle)object).width -= n2;
                } else if ((this.edgeReiszeMask & 8) != 0) {
                    ((Rectangle)object).width += n2;
                }
                if ((this.edgeReiszeMask & 1) != 0) {
                    ((Rectangle)object).y += n3;
                    ((Rectangle)object).height -= n3;
                    continue;
                }
                if ((this.edgeReiszeMask & 4) == 0) continue;
                ((Rectangle)object).height += n3;
                continue;
            }
            if (n2 < 0 && (this.constraints & 2) != 0 || n2 > 0 && (this.constraints & 8) != 0) {
                ((Rectangle)object).x += n2;
            }
            if ((n3 >= 0 || (this.constraints & 1) == 0) && (n3 <= 0 || (this.constraints & 4) == 0)) continue;
            ((Rectangle)object).y += n3;
        }
        this.postAdjustWindows();
        Object[] objectArray = this.listenerList.getListenerList();
        object = null;
        for (int i3 = objectArray.length - 2; i3 >= 0; i3 -= 2) {
            if (objectArray[i3] != (class$org$eclipse$swt$internal$swing$JTracker$TrackerListener == null ? JTracker.class$((String)"org.eclipse.swt.internal.swing.JTracker$TrackerListener") : class$org$eclipse$swt$internal$swing$JTracker$TrackerListener)) continue;
            if (object == null) {
                object = new TrackerEvent(this.lastMouseLocation.x, this.lastMouseLocation.y);
            }
            if (this.isResizeType) {
                ((TrackerListener)objectArray[i3 + 1]).trackerResized((TrackerEvent)object);
                continue;
            }
            ((TrackerListener)objectArray[i3 + 1]).trackerMoved((TrackerEvent)object);
        }
    }

    public void setAppearance(int n2) {
        this.appearance = n2;
        this.postAdjustWindows();
    }

    protected void postAdjustWindows() {
        if (this.isAdjusmentPending) {
            return;
        }
        this.isAdjusmentPending = true;
        new Thread(){

            public void run() {
                try {
                    1.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        this.this$1.JTracker.this.adjustWindows();
                    }
                });
            }
        }.start();
    }

    protected void adjustWindows() {
        this.isAdjusmentPending = false;
        if (!this.isVisible || this.rectangles.length == 0) {
            return;
        }
        int n2 = this.appearance == 1 ? 3 : 1;
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Window[] windowArray;
            Rectangle rectangle = this.rectangles[i2];
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (rectangle2.width < 0) {
                rectangle2.width = -rectangle2.width;
                rectangle2.x -= rectangle2.width;
            }
            if (rectangle2.height < 0) {
                rectangle2.height = -rectangle2.height;
                rectangle2.y -= rectangle2.height;
            }
            if ((windowArray = this.windowsArray[i2]) == null) {
                windowArray = new Window[4];
                this.windowsArray[i2] = windowArray;
            }
            for (int i3 = 0; i3 < 4; ++i3) {
                Window window = windowArray[i3];
                if (window == null) {
                    window = this.createTrackerWindow(this.sharedOwnerWindow);
                    if (Compatibility.IS_JAVA_5_OR_GREATER) {
                        window.setAlwaysOnTop(true);
                    }
                    windowArray[i3] = window;
                }
                Rectangle rectangle3 = null;
                switch (i3) {
                    case 0: {
                        rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, n2);
                        break;
                    }
                    case 1: {
                        rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, n2, rectangle2.height);
                        break;
                    }
                    case 2: {
                        rectangle3 = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height - n2, rectangle2.width, n2);
                        break;
                    }
                    case 3: {
                        rectangle3 = new Rectangle(rectangle2.x + rectangle2.width - n2, rectangle2.y, n2, rectangle2.height);
                    }
                }
                if (this.clipBounds != null) {
                    rectangle3 = rectangle3.intersection(this.clipBounds);
                }
                if (rectangle3.width <= 0 || rectangle3.height <= 0) {
                    window.setVisible(false);
                } else {
                    if (!window.getBounds().equals(rectangle3)) {
                        window.setBounds(rectangle3);
                    }
                    if (window.isVisible() != this.isVisible) {
                        window.setVisible(this.isVisible);
                    }
                }
                this.sharedOwnerWindow.setCursor(null);
            }
        }
    }

    protected TrackerWindow createTrackerWindow(Window window) {
        return new TrackerWindow(window);
    }

    public boolean show() {
        this.isGenericWindow = false;
        this.sharedOwnerWindow = this.createSharedOwnerWindow();
        this.isCanceled = false;
        this.isVisible = true;
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.lastMouseLocation = MouseInfo.getPointerInfo().getLocation();
        }
        this.adjustWindows();
        while (this.isVisible) {
            try {
                AWTEvent aWTEvent = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
                Object object = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (object instanceof Component) {
                    boolean bl = false;
                    if (aWTEvent instanceof MouseEvent) {
                        this.processMouseEvent((MouseEvent)aWTEvent);
                        bl = !this.isVisible;
                    } else if (aWTEvent instanceof KeyEvent) {
                        this.processKeyEvent((KeyEvent)aWTEvent);
                        bl = !this.isVisible;
                    } else {
                        bl = true;
                    }
                    if (!bl) continue;
                    ((Component)object).dispatchEvent(aWTEvent);
                    if (Compatibility.IS_JAVA_5_OR_GREATER || !this.isGenericWindow) continue;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                if (!(object instanceof MenuComponent)) continue;
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return !this.isCanceled;
    }

    public void hide() {
        this.isVisible = false;
        this.lastMouseLocation = null;
        for (int i2 = 0; i2 < this.windowsArray.length; ++i2) {
            Window[] windowArray = this.windowsArray[i2];
            if (windowArray == null) continue;
            for (int i3 = 0; i3 < windowArray.length; ++i3) {
                Window window = windowArray[i3];
                if (window == null) continue;
                window.dispose();
            }
        }
        this.releaseSharedOwnerWindow(this.sharedOwnerWindow);
        this.sharedOwnerWindow = null;
    }

    public Point getLastMouseLocation() {
        return this.lastMouseLocation;
    }

    protected Window getSharedOwnerWindow() {
        return this.sharedOwnerWindow;
    }

    protected Window createSharedOwnerWindow() {
        this.isGenericWindow = true;
        return new JFrame();
    }

    protected void releaseSharedOwnerWindow(Window window) {
        window.dispose();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setConstraints(int n2) {
        if (n2 == 0) {
            n2 = 15;
        }
        this.constraints = n2;
    }

    public void addTrackerListener(TrackerListener trackerListener) {
        this.listenerList.add(class$org$eclipse$swt$internal$swing$JTracker$TrackerListener == null ? (class$org$eclipse$swt$internal$swing$JTracker$TrackerListener = JTracker.class$((String)"org.eclipse.swt.internal.swing.JTracker$TrackerListener")) : class$org$eclipse$swt$internal$swing$JTracker$TrackerListener, trackerListener);
    }

    public void removeTrackerListener(TrackerListener trackerListener) {
        this.listenerList.remove(class$org$eclipse$swt$internal$swing$JTracker$TrackerListener == null ? (class$org$eclipse$swt$internal$swing$JTracker$TrackerListener = JTracker.class$((String)"org.eclipse.swt.internal.swing.JTracker$TrackerListener")) : class$org$eclipse$swt$internal$swing$JTracker$TrackerListener, trackerListener);
    }

    public TrackerListener[] getTrackerListeners() {
        return (TrackerListener[])this.listenerList.getListeners(class$org$eclipse$swt$internal$swing$JTracker$TrackerListener == null ? (class$org$eclipse$swt$internal$swing$JTracker$TrackerListener = JTracker.class$((String)"org.eclipse.swt.internal.swing.JTracker$TrackerListener")) : class$org$eclipse$swt$internal$swing$JTracker$TrackerListener);
    }

    protected class TrackerWindow
    extends Window {
        public TrackerWindow(Window ownerWindow) {
            super(ownerWindow);
            this.setBackground(Color.BLACK);
        }

        public void update(Graphics g2) {
            this.paint(g2);
        }

        public void paint(Graphics g2) {
            super.paint(g2);
            Rectangle bounds = this.getBounds();
            switch (JTracker.this.appearance) {
                case 1: {
                    Color background = JTracker.this.sharedOwnerWindow.getBackground();
                    int i2 = 0;
                    while (i2 < bounds.width) {
                        int j2 = 0;
                        while (j2 < bounds.height) {
                            if ((i2 + j2 + bounds.x + bounds.y) % 2 == 0) {
                                g2.setColor(Color.BLACK);
                                g2.drawLine(i2, j2, i2, j2);
                            } else {
                                g2.setColor(background);
                                g2.drawLine(i2, j2, i2, j2);
                            }
                            ++j2;
                        }
                        ++i2;
                    }
                    break;
                }
                case 0: {
                    g2.setColor(Color.BLACK);
                    if (bounds.width == 1) {
                        g2.drawLine(0, 0, 0, bounds.height - 1);
                        break;
                    }
                    g2.drawLine(0, 0, bounds.width - 1, 0);
                }
            }
        }

        public boolean getFocusableWindowState() {
            return false;
        }

        public boolean contains(int x, int y) {
            return false;
        }
    }

    public static interface TrackerListener
    extends EventListener {
        public void trackerMoved(TrackerEvent var1);

        public void trackerResized(TrackerEvent var1);
    }

    public static class TrackerEvent {
        protected int x;
        protected int y;

        TrackerEvent(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

