/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.CAUUID;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IMoniker;
import org.eclipse.swt.internal.ole.win32.IOleCommandTarget;
import org.eclipse.swt.internal.ole.win32.IOleDocument;
import org.eclipse.swt.internal.ole.win32.IOleDocumentView;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceObject;
import org.eclipse.swt.internal.ole.win32.IOleLink;
import org.eclipse.swt.internal.ole.win32.IOleObject;
import org.eclipse.swt.internal.ole.win32.IPersist;
import org.eclipse.swt.internal.ole.win32.IPersistStorage;
import org.eclipse.swt.internal.ole.win32.ISpecifyPropertyPages;
import org.eclipse.swt.internal.ole.win32.IStorage;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.IViewObject2;
import org.eclipse.swt.internal.ole.win32.OLECMD;
import org.eclipse.swt.internal.ole.win32.OLEINPLACEFRAMEINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class OleClientSite
extends Composite {
    private COMObject iUnknown;
    private COMObject iOleClientSite;
    private COMObject iAdviseSink;
    private COMObject iOleInPlaceSite;
    private COMObject iOleDocumentSite;
    protected GUID appClsid;
    private GUID objClsid;
    private int refCount;
    protected OleFrame frame;
    protected IUnknown objIUnknown;
    protected IOleObject objIOleObject;
    protected IViewObject2 objIViewObject2;
    protected IOleInPlaceObject objIOleInPlaceObject;
    protected IOleCommandTarget objIOleCommandTarget;
    protected IOleDocumentView objDocumentView;
    protected IStorage tempStorage;
    private int aspect;
    private int type;
    private boolean isStatic;
    private RECT borderWidths = new RECT();
    private RECT indent = new RECT();
    private boolean inUpdate = false;
    private boolean inInit = true;
    private boolean inDispose = false;
    private static final String WORDPROGID = "Word.Document";
    private Listener listener;
    static final int STATE_NONE = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_INPLACEACTIVE = 2;
    static final int STATE_UIACTIVE = 3;
    static final int STATE_ACTIVE = 4;
    int state = 0;

    protected OleClientSite(Composite composite, int n2) {
        super(composite, n2);
        this.createCOMInterfaces();
        while (composite != null) {
            if (composite instanceof OleFrame) {
                this.frame = (OleFrame)composite;
                break;
            }
            composite = composite.getParent();
        }
        if (this.frame == null) {
            OLE.error((int)5);
        }
        this.frame.AddRef();
        this.aspect = 1;
        this.type = 1;
        this.isStatic = false;
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.frame.addListener(11, this.listener);
        this.frame.addListener(10, this.listener);
        this.addListener(12, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(9, this.listener);
        this.addListener(31, this.listener);
        this.addListener(1, this.listener);
    }

    public OleClientSite(Composite composite, int n2, File file) {
        this(composite, n2);
        try {
            if (file == null || file.isDirectory() || !file.exists()) {
                OLE.error((int)5);
            }
            this.appClsid = new GUID();
            char[] cArray = (file.getAbsolutePath() + "\u0000").toCharArray();
            int n3 = COM.GetClassFile((char[])cArray, (GUID)this.appClsid);
            if (n3 != 0) {
                OLE.error((int)1004, (int)n3);
            }
            if (this.getProgramID() == null) {
                OLE.error((int)1004, (int)n3);
            }
            this.tempStorage = this.createTempStorage();
            int[] nArray = new int[1];
            n3 = COM.OleCreateFromFile((GUID)this.appClsid, (char[])cArray, (GUID)COM.IIDIUnknown, (int)1, null, (int)0, (int)this.tempStorage.getAddress(), (int[])nArray);
            if (n3 != 0) {
                OLE.error((int)1001, (int)n3);
            }
            this.objIUnknown = new IUnknown(nArray[0]);
            this.addObjectReferences();
            if (COM.OleRun((int)this.objIUnknown.getAddress()) == 0) {
                this.state = 1;
            }
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    public OleClientSite(Composite composite, int n2, String string) {
        this(composite, n2);
        try {
            this.appClsid = this.getClassID(string);
            if (this.appClsid == null) {
                OLE.error((int)1004);
            }
            this.tempStorage = this.createTempStorage();
            int[] nArray = new int[1];
            int n3 = COM.OleCreate((GUID)this.appClsid, (GUID)COM.IIDIUnknown, (int)1, null, (int)0, (int)this.tempStorage.getAddress(), (int[])nArray);
            if (n3 != 0) {
                OLE.error((int)1001, (int)n3);
            }
            this.objIUnknown = new IUnknown(nArray[0]);
            this.addObjectReferences();
            if (COM.OleRun((int)this.objIUnknown.getAddress()) == 0) {
                this.state = 1;
            }
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    public OleClientSite(Composite composite, int n2, String string, File file) {
        this(composite, n2);
        try {
            if (file == null || file.isDirectory() || !file.exists()) {
                OLE.error((int)5);
            }
            this.appClsid = this.getClassID(string);
            char[] cArray = (file.getAbsolutePath() + "\u0000").toCharArray();
            GUID gUID = new GUID();
            COM.GetClassFile((char[])cArray, (GUID)gUID);
            if (COM.IsEqualGUID((GUID)this.appClsid, (GUID)gUID)) {
                this.tempStorage = this.createTempStorage();
                int[] nArray = new int[1];
                int n3 = COM.OleCreateFromFile((GUID)this.appClsid, (char[])cArray, (GUID)COM.IIDIUnknown, (int)1, null, (int)0, (int)this.tempStorage.getAddress(), (int[])nArray);
                if (n3 != 0) {
                    OLE.error((int)1001, (int)n3);
                }
                this.objIUnknown = new IUnknown(nArray[0]);
            } else {
                int[] nArray;
                int n4;
                int[] nArray2;
                int n5;
                IStorage iStorage = null;
                if (COM.StgIsStorageFile((char[])cArray) == 0) {
                    n5 = 65552;
                    nArray2 = new int[1];
                    n4 = COM.StgOpenStorage((char[])cArray, (int)0, (int)n5, (int)0, (int)0, (int[])nArray2);
                    if (n4 != 0) {
                        OLE.error((int)1002, (int)n4);
                    }
                    iStorage = new IStorage(nArray2[0]);
                } else {
                    n5 = 4114;
                    nArray2 = new int[1];
                    n4 = COM.StgCreateDocfile(null, (int)(n5 | 0x4000000), (int)0, (int[])nArray2);
                    if (n4 != 0) {
                        OLE.error((int)1002, (int)n4);
                    }
                    iStorage = new IStorage(nArray2[0]);
                    String string2 = "CONTENTS";
                    GUID gUID2 = this.getClassID(WORDPROGID);
                    if (COM.IsEqualGUID((GUID)this.appClsid, (GUID)gUID2)) {
                        string2 = "WordDocument";
                    }
                    if ((n4 = iStorage.CreateStream(string2, n5, 0, 0, nArray2 = new int[1])) != 0) {
                        iStorage.Release();
                        OLE.error((int)1002, (int)n4);
                    }
                    IStream iStream = new IStream(nArray2[0]);
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n6 = 4096;
                        byte[] byArray = new byte[n6];
                        int n7 = 0;
                        while ((n7 = fileInputStream.read(byArray)) > 0) {
                            int n8 = COM.CoTaskMemAlloc((int)n7);
                            OS.MoveMemory((int)n8, (byte[])byArray, (int)n7);
                            n4 = iStream.Write(n8, n7, null);
                            COM.CoTaskMemFree((int)n8);
                            if (n4 == 0) continue;
                            fileInputStream.close();
                            iStream.Release();
                            iStorage.Release();
                            OLE.error((int)1002, (int)n4);
                        }
                        fileInputStream.close();
                        iStream.Commit(0);
                        iStream.Release();
                    }
                    catch (IOException iOException) {
                        iStream.Release();
                        iStorage.Release();
                        OLE.error((int)1002);
                    }
                }
                this.tempStorage = this.createTempStorage();
                int n9 = iStorage.CopyTo(0, null, null, this.tempStorage.getAddress());
                iStorage.Release();
                if (n9 != 0) {
                    OLE.error((int)1002, (int)n9);
                }
                if ((n9 = COM.CoCreateInstance((GUID)this.appClsid, (int)0, (int)3, (GUID)COM.IIDIUnknown, (int[])(nArray = new int[1]))) != 0) {
                    OLE.error((int)1001, (int)n9);
                }
                this.objIUnknown = new IUnknown(nArray[0]);
                nArray = new int[1];
                n9 = this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray);
                if (n9 != 0) {
                    OLE.error((int)1001, (int)n9);
                }
                IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
                n9 = iPersistStorage.Load(this.tempStorage.getAddress());
                iPersistStorage.Release();
                if (n9 != 0) {
                    OLE.error((int)1001, (int)n9);
                }
            }
            this.addObjectReferences();
            if (COM.OleRun((int)this.objIUnknown.getAddress()) == 0) {
                this.state = 1;
            }
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    protected void addObjectReferences() {
        int n2;
        Object object;
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIPersist, nArray) == 0) {
            IPersist iPersist = new IPersist(nArray[0]);
            object = new GUID();
            if (iPersist.GetClassID(object) == 0) {
                this.objClsid = object;
            }
            iPersist.Release();
        }
        if ((n2 = this.objIUnknown.QueryInterface(COM.IIDIViewObject2, nArray = new int[1])) != 0) {
            OLE.error((int)1003, (int)n2);
        }
        this.objIViewObject2 = new IViewObject2(nArray[0]);
        this.objIViewObject2.SetAdvise(this.aspect, 0, this.iAdviseSink.getAddress());
        nArray = new int[1];
        n2 = this.objIUnknown.QueryInterface(COM.IIDIOleObject, nArray);
        if (n2 != 0) {
            OLE.error((int)1003, (int)n2);
        }
        this.objIOleObject = new IOleObject(nArray[0]);
        this.objIOleObject.SetClientSite(this.iOleClientSite.getAddress());
        object = new int[1];
        this.objIOleObject.Advise(this.iAdviseSink.getAddress(), (int[])object);
        this.objIOleObject.SetHostNames("main", "main");
        COM.OleSetContainedObject((int)this.objIUnknown.getAddress(), (boolean)true);
        nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIOleLink, nArray) == 0) {
            IOleLink iOleLink = new IOleLink(nArray[0]);
            int[] nArray2 = new int[1];
            if (iOleLink.GetSourceMoniker(nArray2) == 0) {
                IMoniker iMoniker = new IMoniker(nArray2[0]);
                iMoniker.Release();
                this.type = 0;
                iOleLink.BindIfRunning();
            } else {
                this.isStatic = true;
            }
            iOleLink.Release();
        }
    }

    protected int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int CanInPlaceActivate() {
        if (this.aspect == 1 && this.type == 1) {
            return 0;
        }
        return 1;
    }

    private int ContextSensitiveHelp(int n2) {
        return 0;
    }

    protected void createCOMInterfaces() {
        this.iUnknown = new /* Unavailable Anonymous Inner Class!! */;
        this.iOleClientSite = new /* Unavailable Anonymous Inner Class!! */;
        this.iAdviseSink = new /* Unavailable Anonymous Inner Class!! */;
        this.iOleInPlaceSite = new /* Unavailable Anonymous Inner Class!! */;
        this.iOleDocumentSite = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected IStorage createTempStorage() {
        int n2 = 67108882;
        int[] nArray = new int[1];
        int n3 = COM.StgCreateDocfile(null, (int)n2, (int)0, (int[])nArray);
        if (n3 != 0) {
            OLE.error((int)1000, (int)n3);
        }
        return new IStorage(nArray[0]);
    }

    public void deactivateInPlaceClient() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.InPlaceDeactivate();
        }
    }

    private void deleteTempStorage() {
        if (this.tempStorage != null) {
            this.tempStorage.Release();
        }
        this.tempStorage = null;
    }

    protected void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleClientSite != null) {
            this.iOleClientSite.dispose();
        }
        this.iOleClientSite = null;
        if (this.iAdviseSink != null) {
            this.iAdviseSink.dispose();
        }
        this.iAdviseSink = null;
        if (this.iOleInPlaceSite != null) {
            this.iOleInPlaceSite.dispose();
        }
        this.iOleInPlaceSite = null;
        if (this.iOleDocumentSite != null) {
            this.iOleDocumentSite.dispose();
        }
        this.iOleDocumentSite = null;
    }

    public int doVerb(int n2) {
        if (this.state == 0 && COM.OleRun((int)this.objIUnknown.getAddress()) == 0) {
            this.state = 1;
        }
        if (this.state == 0 || this.isStatic) {
            return -2147467259;
        }
        int n3 = this.objIOleObject.DoVerb(n2, null, this.iOleClientSite.getAddress(), 0, this.handle, null);
        if (this.state != 1 && this.inInit) {
            this.updateStorage();
            this.inInit = false;
        }
        return n3;
    }

    public int exec(int n2, int n3, Variant variant, Variant variant2) {
        if (this.objIOleCommandTarget == null) {
            int[] nArray = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleCommandTarget, nArray) != 0) {
                return 1003;
            }
            this.objIOleCommandTarget = new IOleCommandTarget(nArray[0]);
        }
        int n4 = 0;
        if (variant != null) {
            n4 = OS.GlobalAlloc((int)64, (int)16);
            variant.getData(n4);
        }
        int n5 = 0;
        if (variant2 != null) {
            n5 = OS.GlobalAlloc((int)64, (int)16);
            variant2.getData(n5);
        }
        int n6 = this.objIOleCommandTarget.Exec(null, n2, n3, n4, n5);
        if (n4 != 0) {
            COM.VariantClear((int)n4);
            OS.GlobalFree((int)n4);
        }
        if (n5 != 0) {
            variant2.setData(n5);
            COM.VariantClear((int)n5);
            OS.GlobalFree((int)n5);
        }
        return n6;
    }

    IDispatch getAutomationObject() {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIDispatch, nArray) != 0) {
            return null;
        }
        return new IDispatch(nArray[0]);
    }

    protected GUID getClassID(String string) {
        int n2;
        GUID gUID = new GUID();
        char[] cArray = null;
        if (string != null) {
            n2 = string.length();
            cArray = new char[n2 + 1];
            string.getChars(0, n2, cArray, 0);
        }
        if (COM.CLSIDFromProgID(cArray, (GUID)gUID) != 0 && (n2 = COM.CLSIDFromString(cArray, (GUID)gUID)) != 0) {
            OLE.error((int)1004, (int)n2);
        }
        return gUID;
    }

    private int GetContainer(int n2) {
        if (n2 != 0) {
            COM.MoveMemory((int)n2, (int[])new int[]{0}, (int)4);
        }
        return -2147467262;
    }

    private SIZE getExtent() {
        SIZE sIZE = new SIZE();
        if (this.objIOleObject != null) {
            if (this.objIViewObject2 != null && !COM.OleIsRunning((int)this.objIOleObject.getAddress())) {
                this.objIViewObject2.GetExtent(this.aspect, -1, null, sIZE);
            } else {
                this.objIOleObject.GetExtent(this.aspect, sIZE);
            }
        }
        return this.xFormHimetricToPixels(sIZE);
    }

    public Rectangle getIndent() {
        return new Rectangle(this.indent.left, this.indent.right, this.indent.top, this.indent.bottom);
    }

    public String getProgramID() {
        int[] nArray;
        if (this.appClsid != null && COM.ProgIDFromCLSID((GUID)this.appClsid, (int[])(nArray = new int[1])) == 0) {
            int n2 = nArray[0];
            int n3 = OS.GlobalSize((int)n2);
            int n4 = OS.GlobalLock((int)n2);
            char[] cArray = new char[n3];
            COM.MoveMemory((char[])cArray, (int)n4, (int)n3);
            OS.GlobalUnlock((int)n2);
            OS.GlobalFree((int)n2);
            String string = new String(cArray);
            int n5 = string.indexOf("\u0000");
            return string.substring(0, n5);
        }
        return null;
    }

    int ActivateMe(int n2) {
        Object object;
        if (n2 == 0) {
            object = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleDocument, object) != 0) {
                return -2147467259;
            }
            IOleDocument iOleDocument = new IOleDocument(object[0]);
            if (iOleDocument.CreateView(this.iOleInPlaceSite.getAddress(), 0, 0, object) != 0) {
                return -2147467259;
            }
            iOleDocument.Release();
            this.objDocumentView = new IOleDocumentView(object[0]);
        } else {
            this.objDocumentView = new IOleDocumentView(n2);
            this.objDocumentView.AddRef();
            this.objDocumentView.SetInPlaceSite(this.iOleInPlaceSite.getAddress());
        }
        this.objDocumentView.UIActivate(1);
        object = this.getRect();
        this.objDocumentView.SetRect((RECT)object);
        this.objDocumentView.Show(1);
        return 0;
    }

    protected int GetWindow(int n2) {
        if (n2 == 0) {
            return -2147024809;
        }
        if (this.frame == null) {
            COM.MoveMemory((int)n2, (int[])new int[]{0}, (int)4);
            return -2147467263;
        }
        COM.MoveMemory((int)n2, (int[])new int[]{this.frame.handle}, (int)4);
        return 0;
    }

    RECT getRect() {
        Point point = this.getLocation();
        Rectangle rectangle = this.frame.getClientArea();
        RECT rECT = new RECT();
        rECT.left = point.x;
        rECT.top = point.y;
        rECT.right = point.x + rectangle.width - this.borderWidths.left - this.borderWidths.right;
        rECT.bottom = point.y + rectangle.height - this.borderWidths.top - this.borderWidths.bottom;
        return rECT;
    }

    private int GetWindowContext(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        if (this.frame == null || n2 == 0) {
            return -2147467263;
        }
        int n10 = this.frame.getIOleInPlaceFrame();
        COM.MoveMemory((int)n2, (int[])new int[]{n10}, (int)4);
        this.frame.AddRef();
        if (n3 != 0) {
            COM.MoveMemory((int)n3, (int[])new int[]{0}, (int)4);
        }
        RECT rECT = this.getRect();
        if (n4 != 0) {
            OS.MoveMemory((int)n4, (RECT)rECT, (int)16);
        }
        if (n5 != 0) {
            OS.MoveMemory((int)n5, (RECT)rECT, (int)16);
        }
        OLEINPLACEFRAMEINFO oLEINPLACEFRAMEINFO = new OLEINPLACEFRAMEINFO();
        oLEINPLACEFRAMEINFO.cb = 20;
        oLEINPLACEFRAMEINFO.fMDIApp = 0;
        oLEINPLACEFRAMEINFO.hwndFrame = this.frame.handle;
        Shell shell = this.getShell();
        Menu menu = shell.getMenuBar();
        if (menu != null && !menu.isDisposed() && (n9 = OS.SendMessage((int)(n8 = shell.handle), (int)32768, (int)0, (int)0)) != 0 && (n7 = OS.SendMessage((int)n8, (int)32769, (int)0, (int)0)) != 0) {
            oLEINPLACEFRAMEINFO.cAccelEntries = n9;
            oLEINPLACEFRAMEINFO.haccel = n7;
        }
        COM.MoveMemory((int)n6, (OLEINPLACEFRAMEINFO)oLEINPLACEFRAMEINFO, (int)20);
        return 0;
    }

    public boolean isDirty() {
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIPersistFile, nArray) != 0) {
            return true;
        }
        IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
        int n2 = iPersistStorage.IsDirty();
        iPersistStorage.Release();
        return n2 != 1;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        int n2 = OS.GetFocus();
        if (this.objIOleInPlaceObject == null) {
            return this.handle == n2;
        }
        int[] nArray = new int[1];
        this.objIOleInPlaceObject.GetWindow(nArray);
        while (n2 != 0) {
            if (nArray[0] == n2) {
                return true;
            }
            n2 = OS.GetParent((int)n2);
        }
        return false;
    }

    private int OnClose() {
        return 0;
    }

    private int OnDataChange(int n2, int n3) {
        return 0;
    }

    private void onDispose(Event event) {
        this.inDispose = true;
        if (this.state != 0) {
            this.doVerb(-6);
        }
        this.deactivateInPlaceClient();
        this.releaseObjectInterfaces();
        this.deleteTempStorage();
        this.removeListener(12, this.listener);
        this.removeListener(15, this.listener);
        this.removeListener(9, this.listener);
        this.removeListener(31, this.listener);
        this.removeListener(1, this.listener);
        this.frame.removeListener(11, this.listener);
        this.frame.removeListener(10, this.listener);
        this.frame.Release();
        this.frame = null;
    }

    void onFocusIn(Event event) {
        if (this.inDispose) {
            return;
        }
        if (this.state != 3) {
            this.doVerb(-1);
        }
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        if (this.isFocusControl()) {
            return;
        }
        int[] nArray = new int[1];
        this.objIOleInPlaceObject.GetWindow(nArray);
        if (nArray[0] == 0) {
            return;
        }
        OS.SetFocus((int)nArray[0]);
    }

    void onFocusOut(Event event) {
    }

    private int OnInPlaceActivate() {
        this.state = 2;
        this.frame.setCurrentDocument(this);
        if (this.objIOleObject == null) {
            return 0;
        }
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIOleInPlaceObject, nArray) == 0) {
            this.objIOleInPlaceObject = new IOleInPlaceObject(nArray[0]);
        }
        return 0;
    }

    private int OnInPlaceDeactivate() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.Release();
        }
        this.objIOleInPlaceObject = null;
        this.state = 1;
        this.redraw();
        Shell shell = this.getShell();
        if (this.isFocusControl() || this.frame.isFocusControl()) {
            shell.traverse(16);
        }
        return 0;
    }

    private int OnPosRectChange(int n2) {
        Point point = this.getSize();
        this.setExtent(point.x, point.y);
        return 0;
    }

    private void onPaint(Event event) {
        if (this.state == 1 || this.state == 2) {
            SIZE sIZE = this.getExtent();
            Rectangle rectangle = this.getClientArea();
            RECT rECT = new RECT();
            if (this.getProgramID().startsWith("Excel.Sheet")) {
                rECT.left = rectangle.x;
                rECT.right = rectangle.x + rectangle.height * sIZE.cx / sIZE.cy;
                rECT.top = rectangle.y;
                rECT.bottom = rectangle.y + rectangle.height;
            } else {
                rECT.left = rectangle.x;
                rECT.right = rectangle.x + sIZE.cx;
                rECT.top = rectangle.y;
                rECT.bottom = rectangle.y + sIZE.cy;
            }
            int n2 = OS.GlobalAlloc((int)64, (int)16);
            OS.MoveMemory((int)n2, (RECT)rECT, (int)16);
            COM.OleDraw((int)this.objIUnknown.getAddress(), (int)this.aspect, (int)event.gc.handle, (int)n2);
            OS.GlobalFree((int)n2);
        }
    }

    private void onResize(Event event) {
        Rectangle rectangle = this.frame.getClientArea();
        this.setBounds(this.borderWidths.left, this.borderWidths.top, rectangle.width - this.borderWidths.left - this.borderWidths.right, rectangle.height - this.borderWidths.top - this.borderWidths.bottom);
        this.setObjectRects();
    }

    private void OnSave() {
    }

    private int OnShowWindow(int n2) {
        return 0;
    }

    private int OnUIActivate() {
        if (this.objIOleInPlaceObject == null) {
            return -2147467259;
        }
        this.state = 3;
        int[] nArray = new int[1];
        if (this.objIOleInPlaceObject.GetWindow(nArray) == 0) {
            OS.SetWindowPos((int)nArray[0], (int)0, (int)0, (int)0, (int)0, (int)0, (int)3);
        }
        return 0;
    }

    private int OnUIDeactivate(int n2) {
        Menu menu;
        if (this.frame == null || this.frame.isDisposed()) {
            return 0;
        }
        this.state = 2;
        this.frame.SetActiveObject(0, 0);
        this.redraw();
        Shell shell = this.getShell();
        if (this.isFocusControl() || this.frame.isFocusControl()) {
            shell.traverse(16);
        }
        if ((menu = shell.getMenuBar()) == null || menu.isDisposed()) {
            return 0;
        }
        int n3 = shell.handle;
        OS.SetMenu((int)n3, (int)menu.handle);
        return COM.OleSetMenuDescriptor((int)0, (int)n3, (int)0, (int)0, (int)0);
    }

    private void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 128: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    private int OnViewChange(int n2, int n3) {
        return 0;
    }

    protected int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        GUID gUID = new GUID();
        COM.MoveMemory((GUID)gUID, (int)n2, (int)16);
        if (COM.IsEqualGUID((GUID)gUID, (GUID)COM.IIDIUnknown)) {
            COM.MoveMemory((int)n3, (int[])new int[]{this.iUnknown.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID((GUID)gUID, (GUID)COM.IIDIAdviseSink)) {
            COM.MoveMemory((int)n3, (int[])new int[]{this.iAdviseSink.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID((GUID)gUID, (GUID)COM.IIDIOleClientSite)) {
            COM.MoveMemory((int)n3, (int[])new int[]{this.iOleClientSite.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID((GUID)gUID, (GUID)COM.IIDIOleInPlaceSite)) {
            COM.MoveMemory((int)n3, (int[])new int[]{this.iOleInPlaceSite.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory((int)n3, (int[])new int[]{0}, (int)4);
        return -2147467262;
    }

    public int queryStatus(int n2) {
        Object object;
        if (this.objIOleCommandTarget == null) {
            object = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleCommandTarget, object) != 0) {
                return 0;
            }
            this.objIOleCommandTarget = new IOleCommandTarget(object[0]);
        }
        object = new OLECMD();
        object.cmdID = n2;
        int n3 = this.objIOleCommandTarget.QueryStatus(null, 1, (OLECMD)object, null);
        if (n3 != 0) {
            return 0;
        }
        return object.cmdf;
    }

    protected int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    protected void releaseObjectInterfaces() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.Release();
        }
        this.objIOleInPlaceObject = null;
        if (this.objIOleObject != null) {
            this.objIOleObject.Close(1);
            this.objIOleObject.Release();
        }
        this.objIOleObject = null;
        if (this.objDocumentView != null) {
            this.objDocumentView.Release();
        }
        this.objDocumentView = null;
        if (this.objIViewObject2 != null) {
            this.objIViewObject2.SetAdvise(this.aspect, 0, 0);
            this.objIViewObject2.Release();
        }
        this.objIViewObject2 = null;
        if (this.objIOleCommandTarget != null) {
            this.objIOleCommandTarget.Release();
        }
        this.objIOleCommandTarget = null;
        if (this.objIUnknown != null) {
            this.objIUnknown.Release();
        }
        this.objIUnknown = null;
        COM.CoFreeUnusedLibraries();
    }

    public boolean save(File file, boolean bl) {
        if (bl) {
            return this.saveToStorageFile(file);
        }
        return this.saveToTraditionalFile(file);
    }

    private boolean saveFromContents(int n2, File file) {
        boolean bl = false;
        IStream iStream = new IStream(n2);
        iStream.AddRef();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n3 = 4096;
            int n4 = COM.CoTaskMemAlloc((int)n3);
            int[] nArray = new int[1];
            while (iStream.Read(n4, n3, nArray) == 0 && nArray[0] > 0) {
                byte[] byArray = new byte[nArray[0]];
                OS.MoveMemory((byte[])byArray, (int)n4, (int)nArray[0]);
                fileOutputStream.write(byArray);
                bl = true;
            }
            COM.CoTaskMemFree((int)n4);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iStream.Release();
        return bl;
    }

    private boolean saveFromOle10Native(int n2, File file) {
        boolean bl = false;
        IStream iStream = new IStream(n2);
        iStream.AddRef();
        int n3 = COM.CoTaskMemAlloc((int)4);
        int[] nArray = new int[1];
        int n4 = iStream.Read(n3, 4, null);
        OS.MoveMemory((int[])nArray, (int)n3, (int)4);
        COM.CoTaskMemFree((int)n3);
        if (n4 == 0 && nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            n3 = COM.CoTaskMemAlloc((int)nArray[0]);
            n4 = iStream.Read(n3, nArray[0], null);
            OS.MoveMemory((byte[])byArray, (int)n3, (int)nArray[0]);
            COM.CoTaskMemFree((int)n3);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        iStream.Release();
        return bl;
    }

    private int SaveObject() {
        this.updateStorage();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveToStorageFile(File file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!this.updateStorage()) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIPersistStorage, nArray) != 0) {
            return false;
        }
        IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
        try {
            nArray = new int[1];
            char[] cArray = (file.getAbsolutePath() + "\u0000").toCharArray();
            int n2 = 69650;
            int n3 = COM.StgCreateDocfile((char[])cArray, (int)n2, (int)0, (int[])nArray);
            if (n3 != 0) {
                boolean bl = false;
                return bl;
            }
            IStorage iStorage = new IStorage(nArray[0]);
            try {
                if (COM.OleSave((int)iPersistStorage.getAddress(), (int)iStorage.getAddress(), (boolean)false) == 0 && iStorage.Commit(0) == 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                iStorage.Release();
            }
        }
        finally {
            iPersistStorage.Release();
        }
        return false;
    }

    private boolean saveToTraditionalFile(File file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!this.updateStorage()) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.tempStorage.OpenStream("CONTENTS", 0, 16, 0, nArray) == 0) {
            return this.saveFromContents(nArray[0], file);
        }
        if (this.tempStorage.OpenStream("\u0001Ole10Native", 0, 16, 0, nArray) == 0) {
            return this.saveFromOle10Native(nArray[0], file);
        }
        return false;
    }

    private int Scroll(int n2) {
        return 0;
    }

    void setBorderSpace(RECT rECT) {
        this.borderWidths = rECT;
        Rectangle rectangle = this.frame.getClientArea();
        this.setBounds(this.borderWidths.left, this.borderWidths.top, rectangle.width - this.borderWidths.left - this.borderWidths.right, rectangle.height - this.borderWidths.top - this.borderWidths.bottom);
        this.setObjectRects();
    }

    private void setExtent(int n2, int n3) {
        if (this.objIOleObject == null || this.isStatic || this.inUpdate) {
            return;
        }
        SIZE sIZE = this.getExtent();
        if (n2 == sIZE.cx && n3 == sIZE.cy) {
            return;
        }
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n2;
        sIZE2.cy = n3;
        sIZE2 = this.xFormPixelsToHimetric(sIZE2);
        boolean bl = COM.OleIsRunning((int)this.objIOleObject.getAddress());
        if (!bl) {
            COM.OleRun((int)this.objIOleObject.getAddress());
        }
        if (this.objIOleObject.SetExtent(this.aspect, sIZE2) == 0) {
            this.inUpdate = true;
            this.objIOleObject.Update();
            this.inUpdate = false;
            if (!bl) {
                this.objIOleObject.Close(0);
            }
        }
    }

    public void setIndent(Rectangle rectangle) {
        this.indent = new RECT();
        this.indent.left = rectangle.x;
        this.indent.right = rectangle.width;
        this.indent.top = rectangle.y;
        this.indent.bottom = rectangle.height;
    }

    private void setObjectRects() {
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        RECT rECT = this.getRect();
        this.objIOleInPlaceObject.SetObjectRects(rECT, rECT);
    }

    private int ShowObject() {
        return 0;
    }

    public void showProperties(String string) {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDISpecifyPropertyPages, nArray) != 0) {
            return;
        }
        ISpecifyPropertyPages iSpecifyPropertyPages = new ISpecifyPropertyPages(nArray[0]);
        CAUUID cAUUID = new CAUUID();
        int n2 = iSpecifyPropertyPages.GetPages(cAUUID);
        iSpecifyPropertyPages.Release();
        if (n2 != 0) {
            return;
        }
        char[] cArray = null;
        if (string != null) {
            cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
        }
        n2 = COM.OleCreatePropertyFrame((int)this.frame.handle, (int)10, (int)10, (char[])cArray, (int)1, (int[])new int[]{this.objIUnknown.getAddress()}, (int)cAUUID.cElems, (int)cAUUID.pElems, (int)2048, (int)0, (int)0);
        COM.CoTaskMemFree((int)cAUUID.pElems);
    }

    private boolean updateStorage() {
        if (this.tempStorage == null) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray) != 0) {
            return false;
        }
        IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
        int n2 = COM.OleSave((int)iPersistStorage.getAddress(), (int)this.tempStorage.getAddress(), (boolean)true);
        if (n2 != 0) {
            COM.WriteClassStg((int)this.tempStorage.getAddress(), (GUID)this.objClsid);
            n2 = iPersistStorage.Save(this.tempStorage.getAddress(), true);
        }
        this.tempStorage.Commit(0);
        n2 = iPersistStorage.SaveCompleted(0);
        iPersistStorage.Release();
        return true;
    }

    private SIZE xFormHimetricToPixels(SIZE sIZE) {
        int n2 = OS.GetDC((int)0);
        int n3 = OS.GetDeviceCaps((int)n2, (int)88);
        int n4 = OS.GetDeviceCaps((int)n2, (int)90);
        OS.ReleaseDC((int)0, (int)n2);
        int n5 = Compatibility.round(sIZE.cx * n3, 2540);
        int n6 = Compatibility.round(sIZE.cy * n4, 2540);
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n5;
        sIZE2.cy = n6;
        return sIZE2;
    }

    private SIZE xFormPixelsToHimetric(SIZE sIZE) {
        int n2 = OS.GetDC((int)0);
        int n3 = OS.GetDeviceCaps((int)n2, (int)88);
        int n4 = OS.GetDeviceCaps((int)n2, (int)90);
        OS.ReleaseDC((int)0, (int)n2);
        int n5 = Compatibility.round(sIZE.cx * 2540, n3);
        int n6 = Compatibility.round(sIZE.cy * 2540, n4);
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n5;
        sIZE2.cy = n6;
        return sIZE2;
    }

    static /* synthetic */ void access$000(OleClientSite oleClientSite, Event event) {
        oleClientSite.onResize(event);
    }

    static /* synthetic */ void access$100(OleClientSite oleClientSite, Event event) {
        oleClientSite.onDispose(event);
    }

    static /* synthetic */ void access$200(OleClientSite oleClientSite, Event event) {
        oleClientSite.onPaint(event);
    }

    static /* synthetic */ void access$300(OleClientSite oleClientSite, Event event) {
        oleClientSite.onTraverse(event);
    }

    static /* synthetic */ int access$400(OleClientSite oleClientSite) {
        return oleClientSite.SaveObject();
    }

    static /* synthetic */ int access$500(OleClientSite oleClientSite, int n2) {
        return oleClientSite.GetContainer(n2);
    }

    static /* synthetic */ int access$600(OleClientSite oleClientSite) {
        return oleClientSite.ShowObject();
    }

    static /* synthetic */ int access$700(OleClientSite oleClientSite, int n2) {
        return oleClientSite.OnShowWindow(n2);
    }

    static /* synthetic */ int access$800(OleClientSite oleClientSite, int n2, int n3) {
        return oleClientSite.OnDataChange(n2, n3);
    }

    static /* synthetic */ int access$900(OleClientSite oleClientSite, int n2, int n3) {
        return oleClientSite.OnViewChange(n2, n3);
    }

    static /* synthetic */ void access$1000(OleClientSite oleClientSite) {
        oleClientSite.OnSave();
    }

    static /* synthetic */ int access$1100(OleClientSite oleClientSite) {
        return oleClientSite.OnClose();
    }

    static /* synthetic */ int access$1200(OleClientSite oleClientSite, int n2) {
        return oleClientSite.ContextSensitiveHelp(n2);
    }

    static /* synthetic */ int access$1300(OleClientSite oleClientSite) {
        return oleClientSite.CanInPlaceActivate();
    }

    static /* synthetic */ int access$1400(OleClientSite oleClientSite) {
        return oleClientSite.OnInPlaceActivate();
    }

    static /* synthetic */ int access$1500(OleClientSite oleClientSite) {
        return oleClientSite.OnUIActivate();
    }

    static /* synthetic */ int access$1600(OleClientSite oleClientSite, int n2, int n3, int n4, int n5, int n6) {
        return oleClientSite.GetWindowContext(n2, n3, n4, n5, n6);
    }

    static /* synthetic */ int access$1700(OleClientSite oleClientSite, int n2) {
        return oleClientSite.Scroll(n2);
    }

    static /* synthetic */ int access$1800(OleClientSite oleClientSite, int n2) {
        return oleClientSite.OnUIDeactivate(n2);
    }

    static /* synthetic */ int access$1900(OleClientSite oleClientSite) {
        return oleClientSite.OnInPlaceDeactivate();
    }

    static /* synthetic */ int access$2000(OleClientSite oleClientSite, int n2) {
        return oleClientSite.OnPosRectChange(n2);
    }
}

