/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CCoolItem;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    CoolBar parent;
    Control control;
    Container handle;

    public CoolItem(CoolBar coolBar, int n2) {
        super(coolBar, n2);
        this.parent = coolBar;
        this.handle = this.createHandle();
        coolBar.createItem(this, coolBar.getItemCount());
    }

    public CoolItem(CoolBar coolBar, int n2, int n3) {
        super(coolBar, n2);
        this.parent = coolBar;
        this.handle = this.createHandle();
        coolBar.createItem(this, n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3) {
        this.checkWidget();
        int n4 = this.parent.indexOf(this);
        if (n4 == -1) {
            return new Point(0, 0);
        }
        int n5 = n2;
        int n6 = n3;
        if (n2 == -1) {
            n5 = this.handle.getWidth();
        }
        if (n3 == -1) {
            n6 = this.handle.getHeight();
        }
        return new Point(n5, n6);
    }

    Container createHandle() {
        return (Container)((Object)CCoolItem.Factory.newInstance(this, this.style));
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.control = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null) {
            this.handle.removeAll();
        }
        this.control = control;
        if (control != null) {
            this.handle.add(control.handle);
        }
        this.handle.invalidate();
        this.handle.validate();
        this.handle.repaint();
    }

    public Point getPreferredSize() {
        this.checkWidget();
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    public void setPreferredSize(int n2, int n3) {
        this.checkWidget();
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.handle.setPreferredSize(new Dimension(n2, n3));
        } else if (this.handle instanceof JComponent) {
            ((JComponent)this.handle).setPreferredSize(new Dimension(n2, n3));
        }
        this.handle.invalidate();
        this.handle.validate();
        this.handle.repaint();
    }

    public void setPreferredSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setPreferredSize(point.x, point.y);
    }

    public Point getSize() {
        this.checkWidget();
        Dimension dimension = this.handle.getSize();
        return new Point(dimension.width, dimension.height);
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        this.handle.setSize(new Dimension(n2, n3));
    }

    public void setSize(Point point) {
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        Dimension dimension = this.handle.getMinimumSize();
        return new Point(dimension.width, dimension.height);
    }

    public void setMinimumSize(int n2, int n3) {
        this.checkWidget();
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.handle.setMinimumSize(new Dimension(n2, n3));
        } else if (this.handle instanceof JComponent) {
            ((JComponent)this.handle).setMinimumSize(new Dimension(n2, n3));
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }
}

