/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JMenuBar;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CButton;
import org.eclipse.swt.internal.swing.CShell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class Decorations
extends Canvas {
    Image image;
    Image smallImage;
    Image largeImage;
    Image[] images;
    Menu menuBar;
    Menu[] menus;
    Button defaultButton;
    Button saveDefault;
    boolean opened;

    Decorations() {
    }

    public Decorations(Composite composite, int n2) {
        super(composite, Decorations.checkStyle(n2));
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != null) continue;
            this.menus[i2] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void bringToTop() {
        ((CShell)((Object)this.handle)).toFront();
    }

    static int checkStyle(int n2) {
        if ((n2 & 8) != 0) {
            n2 &= 0xFFFFF30F;
        }
        if ((n2 & 0x4C0) != 0) {
            n2 |= 0x20;
        }
        if ((n2 & 0x480) != 0) {
            n2 |= 0x40;
        }
        if ((n2 & 0x40) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    void checkBorder() {
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!(this instanceof Shell)) {
            this.setVisible(false);
            if (!this.traverseDecorations(false)) {
                Shell shell = this.getShell();
                shell.setFocus();
            }
        }
        super.dispose();
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            for (int i2 = 0; i2 < menuArray.length; ++i2) {
                if (menuArray[i2] != menu) continue;
                control.setMenu(null);
                return;
            }
            menu.fixMenus(decorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return (((CShell)((Object)this.handle)).getExtendedState() & 6) != 0;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return (((CShell)((Object)this.handle)).getExtendedState() & 1) != 0;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return ((CShell)((Object)this.handle)).getTitle();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            int n2;
            block0: do {
                for (n2 = 0; n2 < this.menus.length; ++n2) {
                    Menu menu = this.menus[n2];
                    if (menu == null || menu.isDisposed()) continue;
                    while (menu.getParentMenu() != null) {
                        menu = menu.getParentMenu();
                    }
                    menu.dispose();
                    continue block0;
                }
            } while (n2 != this.menus.length);
            this.menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.image = null;
        this.largeImage = null;
        this.smallImage = null;
        this.images = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != menu) continue;
            this.menus[i2] = null;
            return;
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            ((CShell)((Object)this.handle)).setDefaultButton(null);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            ((CShell)((Object)this.handle)).setDefaultButton((CButton)((Object)this.defaultButton.handle));
        }
        if (bl) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        ((CShell)((Object)this.handle)).setIconImage(image.handle);
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            if (imageArray[i2] != null && !imageArray[i2].isDisposed()) continue;
            this.error(5);
        }
        this.images = imageArray;
        if (imageArray.length > 0) {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(imageArray.length);
            for (int i3 = 0; i3 < imageArray.length; ++i3) {
                arrayList.add(imageArray[i3].handle);
            }
            ((CShell)((Object)this.handle)).setIconImages(arrayList);
        } else {
            ((CShell)((Object)this.handle)).setIconImage(null);
        }
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        CShell cShell = (CShell)((Object)this.handle);
        if (bl) {
            cShell.setExtendedState(6);
        } else {
            cShell.setExtendedState(cShell.getExtendedState() & 0xFFFFFFF9);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (menu != null) {
            this.display.removeBar(menu);
        }
        this.menuBar = menu;
        ((CShell)((Object)this.handle)).setJMenuBar((JMenuBar)this.menuBar.handle);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        CShell cShell = (CShell)((Object)this.handle);
        if (bl) {
            cShell.setExtendedState(1);
        } else {
            cShell.setExtendedState(cShell.getExtendedState() & 0xFFFFFFFE);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        ((CShell)((Object)this.handle)).setTitle(string);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.handle.isVisible()) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.handle.setVisible(true);
            if (this.isDisposed()) {
                return;
            }
            this.opened = true;
        } else {
            this.handle.setVisible(false);
            if (this.isDisposed()) {
                return;
            }
            this.sendEvent(23);
        }
    }

    boolean traverseDecorations(boolean bl) {
        int n2;
        int n3;
        Control[] controlArray = this.parent._getChildren();
        int n4 = controlArray.length;
        for (n3 = 0; n3 < n4 && controlArray[n3] != this; ++n3) {
        }
        int n5 = n3;
        int n6 = n2 = bl ? 1 : -1;
        while ((n3 = (n3 + n2 + n4) % n4) != n5) {
            Control control = controlArray[n3];
            if (control.isDisposed() || !(control instanceof Decorations) || !control.setFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

