/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CSash;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Point origin;
    Point targetPoint;

    public Sash(Composite composite, int n2) {
        super(composite, Sash.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Sash.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state |= 0x100;
    }

    Container createHandle() {
        return (Container)((Object)CSash.Factory.newInstance(this, this.style));
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 501: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 506: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 502: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 501: {
                    this.origin = ((MouseEvent)aWTEvent).getPoint();
                    Event event = new Event();
                    Rectangle rectangle = this.getBounds();
                    event.x = rectangle.x;
                    event.y = rectangle.y;
                    event.width = rectangle.width;
                    event.height = rectangle.height;
                    this.targetPoint = new Point(rectangle.x, rectangle.y);
                    this.sendEvent(13, event);
                    break;
                }
                case 502: {
                    Event event = new Event();
                    Rectangle rectangle = this.getBounds();
                    event.x = this.targetPoint.x;
                    event.y = this.targetPoint.y;
                    event.width = rectangle.width;
                    event.height = rectangle.height;
                    this.sendEvent(13, event);
                    this.origin = null;
                    this.targetPoint = null;
                    break;
                }
                case 506: {
                    Event event = new Event();
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    Dimension dimension = this.handle.getParent().getSize();
                    Rectangle rectangle = this.getBounds();
                    event.x = rectangle.x;
                    event.y = rectangle.y;
                    if ((this.style & 0x200) != 0) {
                        event.x += mouseEvent.getX() - this.origin.x;
                        if (event.x < 0) {
                            event.x = 0;
                        } else if (event.x >= dimension.width - rectangle.width) {
                            event.x = dimension.width - rectangle.width;
                        }
                    } else {
                        event.y += mouseEvent.getY() - this.origin.y;
                        if (event.y < 0) {
                            event.y = 0;
                        } else if (event.y >= dimension.height - rectangle.height) {
                            event.y = dimension.height - rectangle.height;
                        }
                    }
                    event.width = rectangle.width;
                    event.height = rectangle.height;
                    if ((this.style & 0x10000) == 0) {
                        event.detail = 1;
                    }
                    this.sendEvent(13, event);
                    if (!event.doit) break;
                    this.targetPoint.x = event.x;
                    this.targetPoint.y = event.y;
                    ((CSash)((Object)this.handle)).setDragLocation((this.style & 0x200) != 0 ? this.targetPoint.x : this.targetPoint.y);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

