/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Container;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.swing.CScale;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite composite, int n2) {
        super(composite, Scale.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Scale.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state |= 0x300;
    }

    Container createHandle() {
        return (Container)((Object)CScale.Factory.newInstance(this, this.style));
    }

    public int getIncrement() {
        this.checkWidget();
        return ((CScale)((Object)this.handle)).getMinorTickSpacing();
    }

    public int getMaximum() {
        this.checkWidget();
        return ((CScale)((Object)this.handle)).getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return ((CScale)((Object)this.handle)).getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return ((CScale)((Object)this.handle)).getMajorTickSpacing();
    }

    public int getSelection() {
        this.checkWidget();
        return ((CScale)((Object)this.handle)).getValue();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = this.getMinimum();
        int n4 = this.getMaximum();
        if (n2 > n4 - n3) {
            return;
        }
        ((CScale)((Object)this.handle)).setMinorTickSpacing(n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = this.getMinimum();
        if (0 <= n3 && n3 < n2) {
            ((CScale)((Object)this.handle)).setMaximum(n2);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = this.getMaximum();
        if (0 <= n2 && n2 < n3) {
            ((CScale)((Object)this.handle)).setMinimum(n2);
        }
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = this.getMinimum();
        int n4 = this.getMaximum();
        if (n2 > n4 - n3) {
            return;
        }
        ((CScale)((Object)this.handle)).setMajorTickSpacing(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((CScale)((Object)this.handle)).setValue(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof ChangeEvent) {
            if (!this.hooks(13)) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof ChangeEvent) {
                this.sendEvent(13);
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

