/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Container;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CSpinner;
import org.eclipse.swt.internal.swing.TextFilterEvent;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int pageIncrement;

    public Spinner(Composite composite, int n2) {
        super(composite, Spinner.checkStyle(n2));
    }

    static int checkStyle(int n2) {
        return n2 & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CSpinner.Factory.newInstance(this, this.style));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        Point point = super.computeSize(n2, n3, bl);
        return new Point(point.x, this.handle.getPreferredSize().height);
    }

    public void copy() {
        this.checkWidget();
        ((CSpinner)((Object)this.handle)).copy();
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CSpinner)((Object)this.handle)).cut();
    }

    public int getDigits() {
        this.checkWidget();
        return ((CSpinner)((Object)this.handle)).getDigitCount();
    }

    public int getIncrement() {
        this.checkWidget();
        return ((CSpinner)((Object)this.handle)).getStepSize();
    }

    public int getMaximum() {
        this.checkWidget();
        return ((CSpinner)((Object)this.handle)).getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return ((CSpinner)((Object)this.handle)).getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return ((CSpinner)((Object)this.handle)).getSelectedValue();
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CSpinner)((Object)this.handle)).paste();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void setDigits(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(5);
        }
        ((CSpinner)((Object)this.handle)).setDigitCount(n2);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        ((CSpinner)((Object)this.handle)).setStepSize(n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CSpinner)((Object)this.handle)).setMaximum(n2);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CSpinner)((Object)this.handle)).setMinimum(n2);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((CSpinner)((Object)this.handle)).setSelectedValue(n2);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 <= n3) {
            return;
        }
        if (n5 < 0) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        n2 = Math.min(Math.max(n3, n2), n4);
        this.setIncrement(n6);
        this.setPageIncrement(n7);
        this.setDigits(n5);
        this.setSelection(n2);
    }

    String verifyText(String string, int n2, int n3, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof ChangeEvent) {
            if (!this.hooks(13)) {
                super.processEvent(eventObject);
                return;
            }
        } else if (eventObject instanceof TextFilterEvent) {
            if (!this.hooks(25)) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof ChangeEvent) {
                this.sendEvent(13);
            } else if (eventObject instanceof TextFilterEvent) {
                TextFilterEvent textFilterEvent = (TextFilterEvent)eventObject;
                textFilterEvent.setText(this.verifyText(textFilterEvent.getText(), textFilterEvent.getStart(), textFilterEvent.getStart() + textFilterEvent.getEnd(), this.createKeyEvent(textFilterEvent.getKeyEvent())));
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(DocumentEvent documentEvent) {
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            this.sendEvent(24, new Event());
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

