/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.TrayIcon;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    TrayItem item;
    String text = "";
    String message = "";
    int x;
    int y;
    boolean autoHide = true;
    boolean hasLocation;
    boolean visible;

    public ToolTip(Shell shell, int n2) {
        super(shell, ToolTip.checkStyle(n2));
        this.parent = shell;
        this.checkOrientation(shell);
        Utils.notImplemented();
    }

    static int checkStyle(int n2) {
        int n3 = 11;
        if ((n2 & n3) == 0) {
            return n2;
        }
        return ToolTip.checkBits(n2, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void destroyWidget() {
        Utils.notImplemented();
        this.releaseHandle();
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        Utils.notImplemented();
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        if (this.item != null) {
            return this.getVisible() && this.item.getVisible();
        }
        return this.getVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.item = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.item == null && this.autoHide) {
            Utils.notImplemented();
        }
        if (this.item != null && this.item.toolTip == this) {
            this.item.toolTip = null;
        }
        this.item = null;
        this.message = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autoHide = bl;
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        this.x = n2;
        this.y = n3;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.getVisible()) {
            return;
        }
        if (this.item == null) {
            Utils.notImplemented();
        } else if (bl) {
            TrayIcon.MessageType messageType = null;
            messageType = (this.style & 1) != 0 ? TrayIcon.MessageType.ERROR : ((this.style & 8) != 0 ? TrayIcon.MessageType.WARNING : ((this.style & 2) != 0 ? TrayIcon.MessageType.INFO : TrayIcon.MessageType.NONE));
            this.item.trayIcon.displayMessage(this.text, this.message, messageType);
            this.sendEvent(22);
        } else {
            Utils.notImplemented();
        }
    }
}

