/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.GreenfootImage;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.collision.ibsp.Rect;
import greenfoot.util.GreenfootUtil;
import junit.framework.TestCase;

public class ActorTest
extends TestCase {
    private World world;

    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
    }

    public void testNoImage() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o = new TestObject(11, 31);
        o.setImage((GreenfootImage)null);
        this.world.addObject(o, 0, 0);
        ActorTest.assertNull((Object)o.getImage());
    }

    public void testRotatedSizeSmall() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject o = new TestObject(20, 20);
        this.world.addObject(o, 0, 0);
        o.setRotation(45);
        Rect r = o.getBoundingRect();
        ActorTest.assertTrue((r.getWidth() >= 28 && r.getWidth() <= 29 ? 1 : 0) != 0);
        ActorTest.assertTrue((r.getHeight() >= 28 && r.getWidth() <= 29 ? 1 : 0) != 0);
    }

    public void testOutOfBounds() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o = new TestObject(11, 31);
        int x = 2;
        int y = 3;
        this.world.addObject(o, x, y);
        IndexOutOfBoundsException exception = null;
        try {
            o.setLocation(11, 11);
        }
        catch (IndexOutOfBoundsException e) {
            exception = e;
        }
        ActorTest.assertNull((Object)exception);
        ActorTest.assertEquals((int)9, (int)o.getX());
        ActorTest.assertEquals((int)9, (int)o.getY());
    }

    public void testRotationCenter() {
        this.world = WorldCreator.createWorld(700, 480, 1);
        TestObject o = new TestObject(1, 1);
        o.setRotation(-173);
        this.world.addObject(o, 0, 0);
        o.setLocation(0, 0);
        Rect rect = o.getBoundingRect();
        ActorTest.assertEquals((int)-1, (int)rect.getX());
        ActorTest.assertEquals((int)-1, (int)rect.getY());
        ActorTest.assertEquals((int)2, (int)rect.getTop());
        ActorTest.assertEquals((int)2, (int)rect.getRight());
    }
}

