/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RClassEvent;
import rmiextension.wrappers.event.RClassListenerImpl;

public class ClassStateManager
extends RClassListenerImpl {
    private GProject project;
    private List<CompiledStateListener> listeners = new LinkedList<CompiledStateListener>();

    public ClassStateManager(GProject project) throws RemoteException {
        this.project = project;
    }

    public GProject getProject() {
        return this.project;
    }

    @Override
    public void classStateChanged(RClassEvent event) throws RemoteException {
        RClass eventClass = event.getRClass();
        int eventId = event.getEventId();
        try {
            RProject eventProject = eventClass.getPackage().getProject();
            if (!this.project.getRProject().equals(eventProject)) {
                return;
            }
            GPackage pkg = this.project.getPackage(eventClass.getPackage());
            GClass gClass = pkg.getGClass(eventClass, true);
            if (eventId == 0) {
                boolean compiled = event.isClassCompiled();
                gClass.setCompiledState(compiled);
                for (CompiledStateListener listener : this.listeners) {
                    listener.compiledStateChanged(gClass, compiled);
                }
            } else if (eventId == 1) {
                gClass.nameChanged(event.getOldName());
            }
        }
        catch (PackageNotFoundException packageNotFoundException) {
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    public void addCompiledStateListener(CompiledStateListener listener) {
        this.listeners.add(listener);
    }

    public static interface CompiledStateListener {
        public void compiledStateChanged(GClass var1, boolean var2);
    }
}

