/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.Actor;
import greenfoot.World;
import greenfoot.core.ActInterruptedException;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.WorldCanvas;
import greenfoot.platforms.SimulationDelegate;
import greenfoot.util.HDTimer;
import java.awt.EventQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.EventListenerList;

public class Simulation
extends Thread
implements WorldListener {
    private static int MAX_FRAME_RATE = 65;
    private static int MIN_FRAME_RATE = 35;
    private WorldHandler worldHandler;
    private boolean paused;
    private volatile boolean enabled;
    private boolean runOnce;
    private Queue<Runnable> queuedTasks = new LinkedList<Runnable>();
    private EventListenerList listenerList = new EventListenerList();
    private SimulationEvent startedEvent;
    private SimulationEvent stoppedEvent;
    private SimulationEvent disabledEvent;
    private SimulationEvent speedChangeEvent;
    private SimulationEvent debuggerPausedEvent;
    private SimulationEvent debuggerResumedEvent;
    private static Simulation instance;
    public static final int MAX_SIMULATION_SPEED = 100;
    private int speed;
    private long lastDelayTime;
    private long delay;
    private Object repaintLock = new Object();
    private long lastRepaintTime;
    private boolean paintPending;
    private SimulationDelegate delegate;
    private Object interruptLock = new Object();
    private boolean delaying;
    private boolean interruptDelay;
    private boolean isRunning = false;
    private volatile boolean abort;
    public static final String PAUSED = "simulationWait";
    public static final String WORLD_STARTED = "worldStarted";
    public static final String WORLD_STOPPED = "worldStopped";
    public static String RUN_QUEUED_TASKS;
    public static final String ACT_ACTOR = "actActor";
    public static final String ACT_WORLD = "actWorld";
    public static final String NEW_INSTANCE = "newInstance";

    static {
        RUN_QUEUED_TASKS = "runQueuedTasks";
    }

    private Simulation(SimulationDelegate simulationDelegate) {
        this.setName("SimulationThread");
        this.delegate = simulationDelegate;
        this.startedEvent = new SimulationEvent(this, 0);
        this.stoppedEvent = new SimulationEvent(this, 1);
        this.speedChangeEvent = new SimulationEvent(this, 2);
        this.disabledEvent = new SimulationEvent(this, 3);
        this.debuggerPausedEvent = new SimulationEvent(this, 5);
        this.debuggerResumedEvent = new SimulationEvent(this, 6);
        this.setPriority(1);
        this.paused = true;
        this.speed = 50;
        this.delay = this.calculateDelay(this.speed);
        HDTimer.init();
    }

    public static void initialize(SimulationDelegate simulationDelegate) {
        instance = new Simulation(simulationDelegate);
    }

    public static Simulation getInstance() {
        return instance;
    }

    public void attachWorldHandler(WorldHandler worldHandler) {
        this.worldHandler = worldHandler;
        worldHandler.addWorldListener(this);
        this.addSimulationListener(worldHandler);
        this.start();
    }

    @Override
    public void run() {
        this.runContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContent() {
        while (!this.abort) {
            try {
                this.maybePause();
                if (this.worldHandler.hasWorld()) {
                    this.runOneLoop(this.worldHandler.getWorld());
                }
                this.delay();
            }
            catch (ActInterruptedException actInterruptedException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                Simulation simulation = this;
                synchronized (simulation) {
                    this.paused = true;
                }
                t.printStackTrace();
            }
        }
        Simulation simulation = this;
        synchronized (simulation) {
            if (this.isRunning) {
                World world = this.worldHandler.getWorld();
                if (world != null) {
                    Simulation.worldStopped(world);
                }
                this.isRunning = false;
            }
        }
    }

    public synchronized void runLater(Runnable r) {
        this.queuedTasks.add(r);
        if (this.paused || !this.enabled) {
            this.notify();
        }
    }

    private void simulationWait() throws InterruptedException {
        this.wait();
    }

    private static void worldStarted(World world) {
        world.started();
    }

    private static void worldStopped(World world) {
        world.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePause() throws InterruptedException {
        while (!this.abort) {
            boolean doResumeRunning;
            Object object;
            World world;
            boolean checkStop;
            this.runQueuedTasks();
            Simulation simulation = this;
            synchronized (simulation) {
                checkStop = (this.paused || !this.enabled) && this.isRunning;
                world = this.worldHandler.getWorld();
                if (checkStop) {
                    this.isRunning = false;
                    object = this.interruptLock;
                    synchronized (object) {
                        this.interruptDelay = false;
                    }
                } else if (this.isRunning) {
                    return;
                }
            }
            if (checkStop) {
                try {
                    this.signalStopping(world);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                Simulation ie = this;
                synchronized (ie) {
                    this.runOnce = false;
                    if (!this.paused) {
                        this.isRunning = this.enabled;
                    }
                }
            }
            object = this;
            synchronized (object) {
                boolean bl = doResumeRunning = !this.paused && this.enabled && !this.abort && !this.isRunning;
                if (!(this.isRunning || doResumeRunning || this.runOnce)) {
                    if (this.enabled) {
                        this.fireSimulationEvent(this.stoppedEvent);
                    }
                    if (this.worldHandler != null) {
                        this.worldHandler.repaint();
                    }
                    if (!this.queuedTasks.isEmpty()) {
                        continue;
                    }
                    System.gc();
                    try {
                        this.simulationWait();
                        this.lastDelayTime = System.nanoTime();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (doResumeRunning) {
                this.resumeRunning();
            }
            object = this;
            synchronized (object) {
                if (this.runOnce || this.isRunning) {
                    this.runOnce = false;
                    return;
                }
            }
        }
        this.runQueuedTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeRunning() throws InterruptedException {
        this.isRunning = true;
        this.lastDelayTime = System.nanoTime();
        this.fireSimulationEvent(this.startedEvent);
        World world = this.worldHandler.getWorld();
        if (world != null) {
            ReentrantReadWriteLock lock = this.worldHandler.getWorldLock();
            try {
                lock.writeLock().lockInterruptibly();
            }
            catch (InterruptedException ie) {
                this.isRunning = false;
                throw ie;
            }
            try {
                try {
                    Simulation.worldStarted(world);
                }
                catch (Throwable t) {
                    this.isRunning = false;
                    Object object = this.interruptLock;
                    synchronized (object) {
                        Thread.interrupted();
                        this.interruptDelay = false;
                    }
                    this.setPaused(true);
                    t.printStackTrace();
                    lock.writeLock().unlock();
                    return;
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalStopping(World world) throws InterruptedException {
        if (world != null) {
            ReentrantReadWriteLock lock = this.worldHandler.getWorldLock();
            lock.writeLock().lockInterruptibly();
            try {
                try {
                    Simulation.worldStopped(world);
                }
                catch (ActInterruptedException aie) {
                    Simulation simulation = this;
                    synchronized (simulation) {
                        this.paused = true;
                    }
                    throw aie;
                }
                catch (Throwable t) {
                    Simulation simulation = this;
                    synchronized (simulation) {
                        this.paused = true;
                    }
                    t.printStackTrace();
                    lock.writeLock().unlock();
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runQueuedTasks() {
        var2_1 = this;
        synchronized (var2_1) {
            r = this.queuedTasks.poll();
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
            if (true) ** GOTO lbl29
        }
        do {
            world = WorldHandler.getInstance().getWorld();
            lock = null;
            if (world != null) {
                lock = this.worldHandler.getWorldLock();
                lock.writeLock().lock();
            }
            try {
                r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (world != null) {
                lock.writeLock().unlock();
            }
            var3_3 = this;
            synchronized (var3_3) {
                r = this.queuedTasks.poll();
            }
lbl29:
            // 2 sources

        } while (r != null);
    }

    /*
     * Exception decompiling
     */
    private void runOneLoop(World world) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void actActor(Actor actor) {
        actor.act();
    }

    private static void actWorld(World world) {
        world.act();
    }

    public static Object newInstance(Constructor<?> constructor) throws InvocationTargetException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        return constructor.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintIfNeeded() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLast = Math.max(1L, currentTime - this.lastRepaintTime);
        if (1000L / timeSinceLast <= (long)MAX_FRAME_RATE) {
            try {
                Object object = this.repaintLock;
                synchronized (object) {
                    if (!this.paintPending) {
                        this.lastRepaintTime = currentTime;
                        this.worldHandler.repaint();
                        this.paintPending = true;
                    }
                    if (1000L / timeSinceLast <= (long)MIN_FRAME_RATE) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Simulation.this.forcedRepaint();
                            }
                        });
                        while (this.paintPending) {
                            this.repaintLock.wait();
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcedRepaint() {
        WorldCanvas wcanvas = WorldHandler.getInstance().getWorldCanvas();
        Object object = this.repaintLock;
        synchronized (object) {
            if (WorldHandler.getInstance().hasWorld()) {
                wcanvas.paintImmediately(wcanvas.getBounds());
            }
            if (this.paintPending) {
                this.paintPending = false;
                this.repaintLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worldRepainted() {
        Object object = this.repaintLock;
        synchronized (object) {
            this.paintPending = false;
            this.repaintLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runOnce() {
        if (this.enabled) {
            Object object = this.interruptLock;
            synchronized (object) {
                this.interruptDelay = false;
            }
        }
        this.runOnce = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPaused(boolean b) {
        if (this.paused == b) {
            return;
        }
        this.paused = b;
        if (this.enabled) {
            if (!this.paused) {
                Object object = this.interruptLock;
                synchronized (object) {
                    this.interruptDelay = false;
                }
            }
            this.notifyAll();
            if (this.paused) {
                this.interruptDelay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptDelay() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.delaying) {
                this.interrupt();
            } else {
                this.interruptDelay = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setEnabled(boolean b) {
        if (b == this.enabled) {
            return;
        }
        this.enabled = b;
        if (b) {
            this.notifyAll();
            if (this.paused) {
                this.fireSimulationEvent(this.stoppedEvent);
            }
        } else {
            this.interruptDelay();
            if (!this.paused) {
                this.paused = true;
            } else {
                Object object = this.interruptLock;
                synchronized (object) {
                    this.interruptDelay = false;
                }
            }
            this.fireSimulationEvent(this.disabledEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSimulationEvent(SimulationEvent event) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == SimulationListener.class) {
                    ((SimulationListener)listeners[i + 1]).simulationChanged(event);
                }
                i -= 2;
            }
        }
    }

    public void notifyThreadStatus(boolean halted) {
        if (halted) {
            this.fireSimulationEvent(this.debuggerPausedEvent);
        } else {
            this.fireSimulationEvent(this.debuggerResumedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulationListener(SimulationListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(SimulationListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulationListener(SimulationListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(SimulationListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeed(int speed) {
        boolean speedChanged;
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        Simulation simulation = this;
        synchronized (simulation) {
            boolean bl = speedChanged = this.speed != speed;
            if (speedChanged) {
                this.speed = speed;
                this.delegate.setSpeed(speed);
                this.delay = this.calculateDelay(speed);
                if (!this.paused) {
                    Object object = this.interruptLock;
                    synchronized (object) {
                        if (this.delaying) {
                            this.interrupt();
                        }
                    }
                }
            }
        }
        if (speedChanged) {
            this.fireSimulationEvent(this.speedChangeEvent);
        }
    }

    private long calculateDelay(int speed) {
        long rawDelay = 100 - speed;
        long min = 30000L;
        long max = 10000000000L;
        double a = Math.pow((double)max / (double)min, 0.010101010101010102);
        long delay = 0L;
        if (rawDelay > 0L) {
            delay = (long)(Math.pow(a, rawDelay - 1L) * (double)min);
        }
        return delay;
    }

    public synchronized int getSpeed() {
        return this.speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(int numCycles) {
        block26: {
            World world = this.worldHandler.getWorld();
            Simulation simulation = this;
            synchronized (simulation) {
                if (this.paused && this.isRunning && !this.runOnce) {
                    return;
                }
                if (!this.enabled) {
                    return;
                }
                Object object = this.interruptLock;
                synchronized (object) {
                    if (this.interruptDelay) {
                        return;
                    }
                    this.delaying = true;
                }
            }
            try {
                try {
                    this.worldHandler.repaint();
                    int i = 0;
                    while (i < numCycles) {
                        if (world != null) {
                            HDTimer.wait(this.delay, this.worldHandler.getWorldLock());
                        } else {
                            HDTimer.sleep(this.delay);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = this.interruptLock;
                    synchronized (object) {
                        Thread.interrupted();
                        this.interruptDelay = false;
                        this.delaying = false;
                        break block26;
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = this.interruptLock;
                synchronized (object) {
                    Thread.interrupted();
                    this.interruptDelay = false;
                    this.delaying = false;
                }
                throw throwable;
            }
            Object object = this.interruptLock;
            synchronized (object) {
                Thread.interrupted();
                this.interruptDelay = false;
                this.delaying = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void delay() {
        currentTime = System.nanoTime();
        timeElapsed = currentTime - this.lastDelayTime;
        actualDelay = Math.max(this.delay - timeElapsed, 0L);
        var7_4 = this;
        synchronized (var7_4) {
            var8_6 = this.interruptLock;
            synchronized (var8_6) {
                if (this.interruptDelay) {
                    this.interruptDelay = false;
                    if (this.paused || this.abort) {
                        this.lastDelayTime = currentTime;
                        return;
                    }
                }
                this.delaying = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var7_4
            if (true) ** GOTO lbl39
        }
        do {
            try {
                HDTimer.sleep(actualDelay);
            }
            catch (InterruptedException ie) {
                var8_6 = this;
                synchronized (var8_6) {
                    if (!this.enabled || this.paused || this.abort) {
                        break;
                    }
                }
            }
            currentTime = System.nanoTime();
            timeElapsed = currentTime - this.lastDelayTime;
            actualDelay = this.delay - timeElapsed;
lbl39:
            // 2 sources

        } while (actualDelay > 0L);
        this.lastDelayTime = currentTime;
        var7_4 = this.interruptLock;
        synchronized (var7_4) {
            Thread.interrupted();
            this.interruptDelay = false;
            this.delaying = false;
        }
    }

    public void abort() {
        this.abort = true;
        this.setEnabled(false);
    }

    @Override
    public void worldCreated(WorldEvent e) {
        this.setEnabled(true);
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.setEnabled(false);
    }
}

