/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import bluej.Config;
import bluej.utility.DialogManager;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassButton;
import greenfoot.gui.classbrowser.Selectable;
import greenfoot.gui.classbrowser.SelectionListener;
import greenfoot.gui.classbrowser.role.ActorClassRole;
import greenfoot.gui.classbrowser.role.ClassRole;
import greenfoot.gui.classbrowser.role.NormalClassRole;
import greenfoot.gui.classbrowser.role.WorldClassRole;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.record.InteractionListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;

public class ClassView
extends ClassButton
implements Selectable {
    GClass gClass;
    private ClassRole role;
    ClassBrowser classBrowser;
    private String superclass;
    private InteractionListener interactionListener;

    public ClassView(ClassBrowser classBrowser, GClass gClass, InteractionListener interactionListener) {
        this.classBrowser = classBrowser;
        this.interactionListener = interactionListener;
        this.init(gClass);
    }

    public boolean isCoreClass() {
        return this.gClass.isActorClass() || this.gClass.isWorldClass();
    }

    public void updateSuperClass() {
        String superClassGuess = this.getSuperclass();
        if (superClassGuess == null || superClassGuess.equals(this.superclass)) {
            return;
        }
        this.superclass = this.getSuperclass();
        if (this.classBrowser != null) {
            this.classBrowser.consolidateLayout(this);
        }
    }

    private ClassRole determineRole(GProject project) {
        ClassRole classRole = null;
        classRole = this.gClass.isActorClass() ? new ActorClassRole(project) : (this.gClass.isWorldClass() ? new WorldClassRole(project, false) : (this.gClass.isActorSubclass() ? new ActorClassRole(project) : (this.gClass.isWorldSubclass() ? new WorldClassRole(project, true) : NormalClassRole.getInstance())));
        return classRole;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    private void init(GClass gClass) {
        this.gClass = gClass;
        gClass.setClassView(this);
        this.superclass = this.getSuperclass();
        this.initUI();
        this.update();
    }

    public Class<?> getRealClass() {
        return this.gClass.getJavaClass();
    }

    public GClass getGClass() {
        return this.gClass;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = this.role.createPopupMenu(this.classBrowser, this, this.interactionListener, this.isUncompiled());
        popupMenu.setInvoker(this);
        return popupMenu;
    }

    private void setRole(ClassRole role) {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role = role;
        WorldHandler.getInstance().addWorldListener(this.role);
    }

    private void update() {
        this.clearUI();
        this.setRole(this.determineRole(this.classBrowser.getProject()));
        this.role.buildUI(this, this.gClass);
        this.updateSuperClass();
    }

    public ClassRole getRole() {
        return this.role;
    }

    public String getQualifiedClassName() {
        return this.gClass.getQualifiedName();
    }

    public String getClassName() {
        return this.gClass.getName();
    }

    @Override
    public void select() {
        this.setSelected(true);
        this.fireSelectionChangeEvent();
    }

    @Override
    public boolean deselect() {
        if (this.isSelected()) {
            this.setSelected(false);
            this.fireSelectionChangeEvent();
            return true;
        }
        return false;
    }

    public void createInstance() {
        Simulation.getInstance().runLater(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block11: {
                    block12: {
                        realClass = ClassView.this.getRealClass();
                        try {
                            if (realClass == null) {
                                return;
                            }
                            constructor = realClass.getConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            newObject = Simulation.newInstance(constructor);
                            ClassView.access$0(ClassView.this).createdActor(newObject, new String[0], null);
                            invocationListener = GreenfootMain.getInstance().getInvocationListener();
                            if (invocationListener != null) {
                                invocationListener.localObjectCreated(newObject, LocationTracker.instance().getMouseButtonEvent());
                            }
                            return;
                        }
                        catch (LinkageError le) {
                            le.printStackTrace();
                            break block11;
                        }
                        catch (NoSuchMethodException le) {
                            break block11;
                        }
                        catch (IllegalArgumentException le) {
                            break block11;
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                            break block11;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            break block11;
                        }
                        catch (InvocationTargetException e) {
                            cause = e.getCause();
                            if (cause == null) break block12;
                            strace = cause.getStackTrace();
                            i = strace.length;
                            ** while (i > 0)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (strace[i - 1].getClassName().equals(realClass.getName())) {
                                newStrace = new StackTraceElement[i];
                                System.arraycopy(strace, 0, newStrace, 0, i);
                                cause.setStackTrace(newStrace);
                                break;
                            }
                            --i;
                            continue;
                        }
lbl39:
                        // 2 sources

                        cause.printStackTrace();
                        break block11;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public GClass createSubclass(String className) {
        try {
            GProject proj = this.gClass.getPackage().getProject();
            GPackage pkg = proj.getDefaultPackage();
            File dir = proj.getDir();
            File newJavaFile = new File(dir, String.valueOf(className) + ".java");
            String superClassName = this.getClassName();
            GreenfootUtilDelegateIDE.getInstance().createSkeleton(className, superClassName, newJavaFile, this.role.getTemplateFileName(), proj.getCharsetName());
            GClass newClass = pkg.newClass(className, false);
            newClass.setSuperclassGuess(this.getQualifiedClassName());
            return newClass;
        }
        catch (IOException ioe) {
            DialogManager.showErrorText((Component)this, (String)(String.valueOf(Config.getString((String)"greenfoot.cannotCreateClass")) + ": " + ioe.getLocalizedMessage()));
            return null;
        }
    }

    public void remove() {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role.remove();
        this.classBrowser.removeClass(this);
        this.gClass.remove();
        this.gClass = null;
    }

    public String getSuperclass() {
        return this.gClass.getSuperclassGuess();
    }

    protected void fireSelectionChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SelectionListener.class) {
                ((SelectionListener)listeners[i + 1]).selectionChange(this);
            }
            i -= 2;
        }
    }

    public void addSelectionChangeListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionChangeListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    public void nameChanged(String oldName) {
        this.classBrowser.renameClass(this, oldName);
        this.updateView();
    }

    public void updateView() {
        this.update();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            this.getRootPane().revalidate();
        }
    }

    @Override
    protected boolean isValidClass() {
        return this.gClass != null;
    }

    @Override
    protected boolean isUncompiled() {
        return !this.gClass.isCompiled();
    }

    @Override
    protected void doubleClick() {
        this.gClass.edit();
    }

    @Override
    protected void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    static /* synthetic */ InteractionListener access$0(ClassView classView) {
        return classView.interactionListener;
    }
}

