/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.images;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.util.ExternalAppLauncher;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class NewImageDialog
extends EscapeDialog {
    private static final int MAX_IMAGE_HEIGHT = 2000;
    private static final int MAX_IMAGE_WIDTH = 2000;
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 100;
    private JTextField name;
    private JSpinner width;
    private JSpinner height;
    private JButton okButton;
    private File projImagesDir;
    private JDialog parent;
    private File file;
    private int imageWidth;
    private int imageHeight;

    public NewImageDialog(JDialog parent, File projImagesDir, String rootName) {
        super((Dialog)parent, Config.getString((String)"imagelib.new.image.title"));
        this.parent = parent;
        this.projImagesDir = projImagesDir;
        this.imageWidth = Config.getPropInteger((String)"greenfoot.image.create.width", (int)100);
        this.imageHeight = Config.getPropInteger((String)"greenfoot.image.create.height", (int)100);
        this.buildUI(rootName);
    }

    private void buildUI(String rootName) {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel detailsPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        detailsPanel.add(new JLabel(String.valueOf(Config.getString((String)"imagelib.new.image.name")) + " "));
        this.name = new JTextField(10);
        this.name.setText(rootName);
        this.name.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                NewImageDialog.this.checkName();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewImageDialog.this.checkName();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                NewImageDialog.this.checkName();
            }
        });
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 0));
        fileNamePanel.add(this.name);
        fileNamePanel.add(new JLabel(".png"));
        detailsPanel.add(fileNamePanel);
        detailsPanel.add(new JLabel(Config.getString((String)"imagelib.new.image.width")));
        this.width = new JSpinner(new SpinnerNumberModel(this.imageWidth, 1, 2000, 1));
        detailsPanel.add(this.width);
        detailsPanel.add(new JLabel(Config.getString((String)"imagelib.new.image.height")));
        this.height = new JSpinner(new SpinnerNumberModel(this.imageHeight, 1, 2000, 1));
        detailsPanel.add(this.height);
        detailsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, detailsPanel.getPreferredSize().height));
        mainPanel.add(detailsPanel);
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(NewImageDialog.fixHeight(Box.createVerticalStrut(11)));
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        this.okButton = BlueJTheme.getOkButton();
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewImageDialog.this.createAndEdit();
            }
        });
        this.okButton.setAlignmentY(1.0f);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewImageDialog.this.dispose();
            }
        });
        cancelButton.setAlignmentY(1.0f);
        if (Config.isMacOS()) {
            buttonBox.add(cancelButton);
            buttonBox.add(Box.createHorizontalStrut(10));
            buttonBox.add(this.okButton);
        } else {
            buttonBox.add(this.okButton);
            buttonBox.add(Box.createHorizontalStrut(10));
            buttonBox.add(cancelButton);
        }
        mainPanel.add(buttonBox);
        this.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.checkName();
    }

    public File displayModal() {
        this.setModal(true);
        DialogManager.centreDialog((JDialog)((Object)this));
        this.setVisible(true);
        this.dispose();
        this.setModal(false);
        return this.file;
    }

    public File getFile() {
        return this.file;
    }

    private static Component fixHeight(Component src) {
        Dimension d = src.getMaximumSize();
        d.height = src.getPreferredSize().height;
        src.setMaximumSize(d);
        return src;
    }

    private void checkName() {
        if (this.name.getText().trim().isEmpty()) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private void createAndEdit() {
        BufferedImage im = new BufferedImage((Integer)this.width.getValue(), (Integer)this.height.getValue(), 2);
        String fileName = this.name.getText();
        fileName = String.valueOf(fileName) + ".png";
        this.file = new File(this.projImagesDir, fileName);
        if (this.file.exists()) {
            int r = JOptionPane.showOptionDialog((Component)((Object)this), String.valueOf(Config.getString((String)"imagelib.write.exists.part1")) + this.file + Config.getString((String)"imagelib.write.exists.part2"), Config.getString((String)"imagelib.write.exists.title"), 2, 2, null, null, null);
            if (r == 0) {
                this.writeAndEdit(im);
            } else {
                this.setVisible(false);
            }
        } else {
            this.writeAndEdit(im);
        }
    }

    private void writeAndEdit(BufferedImage im) {
        try {
            if (ImageIO.write((RenderedImage)im, "png", this.file)) {
                ExternalAppLauncher.editImage(this.file);
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "png " + Config.getString((String)"imagelib.image.unsupportedformat.text"), Config.getString((String)"imagelib.image.unsupportedformat.title"), 0);
            }
        }
        catch (IOException ex) {
            Debug.reportError((String)"Error editing new image", (Throwable)ex);
        }
    }
}

