/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.importer.scratch;

import greenfoot.importer.scratch.ImageMedia;
import greenfoot.importer.scratch.ScratchObject;
import greenfoot.importer.scratch.ScratchObjectArray;
import greenfoot.importer.scratch.ScratchSpriteMorph;
import greenfoot.importer.scratch.ScriptableScratchMorph;
import java.util.LinkedList;
import java.util.List;

public class ScratchStageMorph
extends ScriptableScratchMorph {
    public ScratchStageMorph(int version, List<ScratchObject> scratchObjects) {
        super(125, version, scratchObjects);
    }

    @Override
    public int fields() {
        return super.fields() + 9;
    }

    ScratchObjectArray getSprites() {
        return (ScratchObjectArray)this.scratchObjects.get(super.fields() + 4);
    }

    @Override
    protected void constructorContents(StringBuilder acc) {
        ImageMedia image = this.getCostume();
        acc.append("super(").append(image.getWidth()).append(", ").append(image.getHeight()).append(", 1);\n");
        LinkedList<String> classes = new LinkedList<String>();
        ScratchObjectArray sprites = this.getSprites();
        ScratchObject[] scratchObjectArray = sprites.getValue();
        int n = scratchObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScratchObject o = scratchObjectArray[n2];
            ScratchSpriteMorph sprite = (ScratchSpriteMorph)o;
            String spriteName = sprite.getObjNameJava();
            acc.append("addObject(new ").append(spriteName).append("(), ");
            acc.append(sprite.getGreenfootCentre().x.intValue());
            acc.append(", ");
            acc.append(sprite.getGreenfootCentre().y.intValue());
            acc.append(");\n");
            classes.addFirst(spriteName);
            ++n2;
        }
        if (!classes.isEmpty()) {
            acc.append("setPaintOrder(Bubble.class");
            for (String cls : classes) {
                acc.append(", ").append(cls).append(".class");
            }
            acc.append(");\n");
        }
    }

    @Override
    protected String greenfootSuperClass() {
        return "World";
    }
}

