/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.localdebugger.LocalObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class LocalDebugger
extends Debugger {
    public void setUserLibraries(URL[] libraries) {
        throw new UnsupportedOperationException();
    }

    public int addDebuggerListener(DebuggerListener l) {
        throw new UnsupportedOperationException();
    }

    public boolean addObject(String scopeId, String newInstanceName, DebuggerObject dob) {
        throw new UnsupportedOperationException();
    }

    public void close(boolean restart) {
        throw new UnsupportedOperationException();
    }

    public void disposeWindows() {
        throw new UnsupportedOperationException();
    }

    public DebuggerClass getClass(String className, boolean initialize) throws ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public DebuggerObject getMirror(String value) {
        throw new UnsupportedOperationException();
    }

    public Map<String, DebuggerObject> getObjects() {
        throw new UnsupportedOperationException();
    }

    public int getStatus() {
        throw new UnsupportedOperationException();
    }

    public DebuggerThreadTreeModel getThreadTreeModel() {
        throw new UnsupportedOperationException();
    }

    public String guessNewName(String className) {
        throw new UnsupportedOperationException();
    }

    public String guessNewName(DebuggerObject obj) {
        throw new UnsupportedOperationException();
    }

    public void hideSystemThreads(boolean hide) {
        throw new UnsupportedOperationException();
    }

    public DebuggerResult instantiateClass(String className) {
        ClassLoader currentLoader = ExecServer.getCurrentClassLoader();
        try {
            Class<?> cl = currentLoader.loadClass(className);
            QueuedInstantiation q = new QueuedInstantiation(cl);
            Simulation.getInstance().runLater(q);
            return q.getResult();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.reportError((String)"Invoking constructor", (Throwable)cnfe);
        }
        catch (LinkageError le) {
            Debug.reportError((String)"Invoking constructor", (Throwable)le);
        }
        return new DebuggerResult(new ExceptionDescription("Internal error"));
    }

    public DebuggerResult instantiateClass(String className, String[] paramTypes, DebuggerObject[] args) {
        throw new UnsupportedOperationException();
    }

    public void launch() {
        throw new UnsupportedOperationException();
    }

    public void newClassLoader(BPClassLoader bpClassLoader) {
        throw new UnsupportedOperationException();
    }

    public void removeBreakpointsForClass(String className) {
        throw new UnsupportedOperationException();
    }

    public void removeDebuggerListener(DebuggerListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeObject(String scopeId, String instanceName) {
        throw new UnsupportedOperationException();
    }

    public DebuggerResult runClassMain(String className) throws ClassNotFoundException {
        ClassLoader currentLoader = ExecServer.getCurrentClassLoader();
        Class<?> c = currentLoader.loadClass(className);
        QueuedExecution qe = new QueuedExecution(c);
        Simulation.getInstance().runLater(qe);
        return qe.getResult();
    }

    public DebuggerTestResult runTestMethod(String className, String methodName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, DebuggerObject> runTestSetUp(String className) {
        throw new UnsupportedOperationException();
    }

    public String toggleBreakpoint(String className, int line, boolean set, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public String toggleBreakpoint(String className, String method, boolean set, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public String toggleBreakpoint(DebuggerClass debuggerClass, String method, boolean set, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    private static ExceptionDescription getExceptionDescription(Throwable t) {
        StackTraceElement[] stackTrace;
        ArrayList<SourceLocation> stack = new ArrayList<SourceLocation>();
        StackTraceElement[] stackTraceElementArray = stackTrace = t.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            stack.add(new SourceLocation(element.getClassName(), element.getFileName(), element.getMethodName(), element.getLineNumber()));
            ++n2;
        }
        new ExceptionDescription(t.getClass().getName(), t.getLocalizedMessage(), stack);
        return null;
    }

    private static class QueuedExecution
    implements Runnable {
        private Class<?> c;
        private DebuggerResult result;

        public QueuedExecution(Class<?> c) {
            this.c = c;
        }

        @Override
        public synchronized void run() {
            try {
                Method m = this.c.getMethod("run", new Class[0]);
                Object result = m.invoke(null, new Object[0]);
                this.result = new DebuggerResult((DebuggerObject)LocalObject.getLocalObject(result));
            }
            catch (IllegalAccessException iae) {
                Debug.reportError((String)"LocalDebugger runClassMain error", (Throwable)iae);
                this.result = new DebuggerResult(new ExceptionDescription("Internal error"));
            }
            catch (NoSuchMethodException nsme) {
                Debug.reportError((String)"LocalDebugger runClassMain error", (Throwable)nsme);
                this.result = new DebuggerResult(new ExceptionDescription("Internal error"));
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace(System.err);
                ExceptionDescription exception = LocalDebugger.getExceptionDescription(ite.getCause());
                this.result = new DebuggerResult(exception);
            }
            this.notify();
        }

        public synchronized DebuggerResult getResult() {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.result;
        }
    }

    private static class QueuedInstantiation
    implements Runnable {
        private Class<?> c;
        private DebuggerResult result;

        public QueuedInstantiation(Class<?> c) {
            this.c = c;
        }

        @Override
        public synchronized void run() {
            try {
                Constructor<?> cons = this.c.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                Object o = Simulation.newInstance(cons);
                this.result = new DebuggerResult((DebuggerObject)LocalObject.getLocalObject(o));
            }
            catch (InstantiationException ite) {
                Debug.reportError((String)"LocalDebugger instantiateClass error", (Throwable)ite);
                this.result = new DebuggerResult(new ExceptionDescription("Internal error"));
            }
            catch (IllegalAccessException iae) {
                Debug.reportError((String)"LocalDebugger instantiateClass error", (Throwable)iae);
                this.result = new DebuggerResult(new ExceptionDescription("Internal error"));
            }
            catch (NoSuchMethodException nsme) {
                Debug.reportError((String)"LocalDebugger instantiateClass error", (Throwable)nsme);
                this.result = new DebuggerResult(new ExceptionDescription("Internal error"));
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace(System.err);
                ExceptionDescription exception = LocalDebugger.getExceptionDescription(ite.getCause());
                this.result = new DebuggerResult(exception);
            }
            catch (LinkageError le) {
                le.printStackTrace();
                this.result = new DebuggerResult(LocalDebugger.getExceptionDescription(le));
            }
            this.notify();
        }

        public synchronized DebuggerResult getResult() {
            while (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.result;
        }
    }
}

